/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.entity;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

public class HttpPath
implements Path {
    private final List<Relationship> relationships;
    private final List<Node> nodes;

    public HttpPath(List<Node> nodes, List<Relationship> relationships) {
        this.relationships = relationships;
        this.nodes = nodes;
    }

    public Node startNode() {
        return this.nodes.get(0);
    }

    public Node endNode() {
        return this.nodes.get(this.nodes.size() - 1);
    }

    public Relationship lastRelationship() {
        return this.relationships.get(this.relationships.size() - 1);
    }

    public Iterable<Relationship> relationships() {
        return this.relationships;
    }

    public Iterable<Relationship> reverseRelationships() {
        throw new NotImplementedException("HttpPath cannot reverse relationships");
    }

    public Iterable<Node> nodes() {
        return this.nodes;
    }

    public Iterable<Node> reverseNodes() {
        throw new NotImplementedException("HttpPath cannot reverse nodes");
    }

    public int length() {
        return this.relationships.size();
    }

    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            Iterator<? extends Entity> current;
            Iterator<? extends Entity> next;
            {
                this.current = HttpPath.this.nodes().iterator();
                this.next = HttpPath.this.relationships().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.current.hasNext();
            }

            @Override
            public Entity next() {
                try {
                    Entity entity = this.current.next();
                    return entity;
                }
                finally {
                    Iterator<? extends Entity> temp = this.current;
                    this.current = this.next;
                    this.next = temp;
                }
            }

            @Override
            public void remove() {
                this.next.remove();
            }
        };
    }
}

