/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.format.jolt;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Map;
import org.neo4j.server.http.cypher.format.jolt.Sigil;

final class JoltMapSerializer
extends StdSerializer<Map<String, ?>> {
    static final JavaType HANDLED_TYPE = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class);

    JoltMapSerializer() {
        super(HANDLED_TYPE);
    }

    public void serialize(Map<String, ?> map, JsonGenerator generator, SerializerProvider provider) throws IOException {
        generator.writeStartObject(map);
        generator.writeFieldName(Sigil.MAP.getValue());
        generator.writeStartObject();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            generator.writeFieldName(entry.getKey());
            generator.writeObject(entry.getValue());
        }
        generator.writeEndObject();
        generator.writeEndObject();
    }
}

