/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.csv.reader;

import org.neo4j.io.ByteUnit;

public class Configuration {
    public static final Configuration COMMAS = Configuration.newBuilder().withDelimiter(',').withArrayDelimiter(';').build();
    public static final Configuration TABS = Configuration.newBuilder().withDelimiter('\t').withArrayDelimiter(',').build();
    public static final boolean DEFAULT_LEGACY_STYLE_QUOTING = false;
    private final char quotationCharacter;
    private final char delimiter;
    private final char arrayDelimiter;
    private final int bufferSize;
    private final boolean multilineFields;
    private final boolean trimStrings;
    private final boolean emptyQuotedStringsAsNull;
    private final boolean legacyStyleQuoting;

    private Configuration(Builder b) {
        this.quotationCharacter = b.quotationCharacter;
        this.delimiter = b.delimiter;
        this.arrayDelimiter = b.arrayDelimiter;
        this.bufferSize = b.bufferSize;
        this.multilineFields = b.multilineFields;
        this.trimStrings = b.trimStrings;
        this.emptyQuotedStringsAsNull = b.emptyQuotedStringsAsNull;
        this.legacyStyleQuoting = b.legacyStyleQuoting;
    }

    public char quotationCharacter() {
        return this.quotationCharacter;
    }

    public char delimiter() {
        return this.delimiter;
    }

    public char arrayDelimiter() {
        return this.arrayDelimiter;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public boolean multilineFields() {
        return this.multilineFields;
    }

    public boolean trimStrings() {
        return this.trimStrings;
    }

    public boolean emptyQuotedStringsAsNull() {
        return this.emptyQuotedStringsAsNull;
    }

    public boolean legacyStyleQuoting() {
        return this.legacyStyleQuoting;
    }

    public Builder toBuilder() {
        return new Builder().withQuotationCharacter(this.quotationCharacter).withDelimiter(this.delimiter).withArrayDelimiter(this.arrayDelimiter).withBufferSize(this.bufferSize).withMultilineFields(this.multilineFields).withTrimStrings(this.trimStrings).withEmptyQuotedStringsAsNull(this.emptyQuotedStringsAsNull).withLegacyStyleQuoting(this.legacyStyleQuoting);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private char quotationCharacter = (char)34;
        private char delimiter = (char)44;
        private char arrayDelimiter = (char)59;
        private int bufferSize = (int)ByteUnit.mebiBytes((long)4L);
        private boolean multilineFields;
        private boolean trimStrings;
        private boolean emptyQuotedStringsAsNull;
        private boolean legacyStyleQuoting = false;

        public Builder withQuotationCharacter(char quotationCharacter) {
            this.quotationCharacter = quotationCharacter;
            return this;
        }

        public Builder withDelimiter(char delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder withArrayDelimiter(char arrayDelimiter) {
            this.arrayDelimiter = arrayDelimiter;
            return this;
        }

        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder withMultilineFields(boolean multilineFields) {
            this.multilineFields = multilineFields;
            return this;
        }

        public Builder withTrimStrings(boolean trimStrings) {
            this.trimStrings = trimStrings;
            return this;
        }

        public Builder withEmptyQuotedStringsAsNull(boolean emptyQuotedStringsAsNull) {
            this.emptyQuotedStringsAsNull = emptyQuotedStringsAsNull;
            return this;
        }

        public Builder withLegacyStyleQuoting(boolean legacyStyleQuoting) {
            this.legacyStyleQuoting = legacyStyleQuoting;
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }
}

