/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Map;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.collection.trackable.HeapTrackingUnifiedMap;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public class HeapTrackingMapValueBuilder
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingMapValueBuilder.class);
    private static final long HEAP_SIZE_ALLOCATION_THRESHOLD = 4096L;
    private final HeapTrackingUnifiedMap<String, AnyValue> values;
    private final MemoryTracker scopedMemoryTracker;
    private long unAllocatedHeapSize;

    public static HeapTrackingMapValueBuilder newHeapTrackingMapValueBuilder(MemoryTracker memoryTracker) {
        return new HeapTrackingMapValueBuilder(memoryTracker);
    }

    public HeapTrackingMapValueBuilder(MemoryTracker memoryTracker) {
        this.scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        this.scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        this.values = HeapTrackingCollections.newMap((MemoryTracker)this.scopedMemoryTracker);
    }

    public void put(String key, AnyValue value) {
        this.unAllocatedHeapSize += value.estimatedHeapUsage();
        if (this.unAllocatedHeapSize >= 4096L) {
            this.scopedMemoryTracker.allocateHeap(this.unAllocatedHeapSize);
            this.unAllocatedHeapSize = 0L;
        }
        this.values.put((Object)key, (Object)value);
    }

    public MapValue build() {
        this.scopedMemoryTracker.allocateHeap(this.unAllocatedHeapSize);
        this.unAllocatedHeapSize = 0L;
        return new MapValue.MapWrappingMapValue((Map<String, AnyValue>)this.values, this.payloadSize());
    }

    public MapValue buildAndClose() {
        MapValue value = this.build();
        this.close();
        return value;
    }

    private long payloadSize() {
        return this.unAllocatedHeapSize + this.scopedMemoryTracker.estimatedHeapMemory() - SHALLOW_SIZE;
    }

    @VisibleForTesting
    public long getUnAllocatedHeapSize() {
        return this.unAllocatedHeapSize;
    }

    @Override
    public void close() {
        this.scopedMemoryTracker.close();
    }
}

