/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import org.neo4j.cypher.internal.CypherQueryObfuscator$;
import org.neo4j.cypher.internal.util.LiteralOffset;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.kernel.api.query.QueryObfuscator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001\u0002\b\u0010\u0001aA\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006e\u0001!\ta\r\u0005\u0006o\u0001!\t\u0005\u000f\u0005\u0006\u0011\u0002!\t%\u0013\u0005\u0006)\u0002!I!V\u0004\u0006Q>A\t!\u001b\u0004\u0006\u001d=A\tA\u001b\u0005\u0006e\u001d!\tA\u001c\u0005\b_\u001e\u0011\r\u0011\"\u0003q\u0011\u0019\u0019x\u0001)A\u0005c\"9Ao\u0002b\u0001\n\u0013)\bB\u0002?\bA\u0003%a\u000fC\u0003~\u000f\u0011\u0005aPA\u000bDsBDWM])vKJLxJ\u00194vg\u000e\fGo\u001c:\u000b\u0005A\t\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005I\u0019\u0012AB2za\",'O\u0003\u0002\u0015+\u0005)a.Z85U*\ta#A\u0002pe\u001e\u001c\u0001aE\u0002\u00013\u0005\u0002\"AG\u0010\u000e\u0003mQ!\u0001H\u000f\u0002\t1\fgn\u001a\u0006\u0002=\u0005!!.\u0019<b\u0013\t\u00013D\u0001\u0004PE*,7\r\u001e\t\u0003E%j\u0011a\t\u0006\u0003I\u0015\nQ!];fefT!AJ\u0014\u0002\u0007\u0005\u0004\u0018N\u0003\u0002)'\u000511.\u001a:oK2L!AK\u0012\u0003\u001fE+XM]=PE\u001a,8oY1u_J\fQa\u001d;bi\u0016\u0004\"!\f\u0019\u000e\u00039R!aL\b\u0002\tU$\u0018\u000e\\\u0005\u0003c9\u00121c\u00142gkN\u001c\u0017\r^5p]6+G/\u00193bi\u0006\fa\u0001P5oSRtDC\u0001\u001b7!\t)\u0004!D\u0001\u0010\u0011\u0015Y#\u00011\u0001-\u00035y'MZ;tG\u0006$X\rV3yiR\u0011\u0011H\u0012\t\u0003u\rs!aO!\u0011\u0005qzT\"A\u001f\u000b\u0005y:\u0012A\u0002\u001fs_>$hHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011u(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"@\u0011\u001595\u00011\u0001:\u00031\u0011\u0018m^)vKJLH+\u001a=u\u0003My'MZ;tG\u0006$X\rU1sC6,G/\u001a:t)\tQ%\u000b\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u00069a/\u001b:uk\u0006d'BA(\u0014\u0003\u00191\u0018\r\\;fg&\u0011\u0011\u000b\u0014\u0002\t\u001b\u0006\u0004h+\u00197vK\")1\u000b\u0002a\u0001\u0015\u0006\u0011\"/Y<Rk\u0016\u0014\u0018\u0010U1sC6,G/\u001a:t\u0003Ma\u0017\u000e^3sC2\u001cFO]5oO2+gn\u001a;i)\u00111&,\u001a4\u0011\u0005]CV\"A \n\u0005e{$aA%oi\")1,\u0002a\u00019\u0006\u0011\u0012\r\u001a6bG\u0016tGo\u00115be\u0006\u001cG/\u001a:t!\ri&-\u000f\b\u0003=\u0002t!\u0001P0\n\u0003\u0001K!!Y \u0002\u000fA\f7m[1hK&\u00111\r\u001a\u0002\u0004'\u0016\f(BA1@\u0011\u00159U\u00011\u0001:\u0011\u00159W\u00011\u0001W\u0003%1'o\\7J]\u0012,\u00070A\u000bDsBDWM])vKJLxJ\u00194vg\u000e\fGo\u001c:\u0011\u0005U:1CA\u0004l!\t9F.\u0003\u0002n\u007f\t1\u0011I\\=SK\u001a$\u0012![\u0001\u0013\u001f\n3UkU\"B)\u0016#u\fT%U\u000bJ\u000bE*F\u0001r!\tQ\"/\u0003\u0002E7\u0005\u0019rJ\u0011$V'\u000e\u000bE+\u0012#`\u0019&#VIU!MA\u0005QqJ\u0011$V'\u000e\u000bE+\u0012#\u0016\u0003Y\u0004\"a\u001e>\u000e\u0003aT!!\u001f(\u0002\u0011M$xN]1cY\u0016L!a\u001f=\u0003\u0013Q+\u0007\u0010\u001e,bYV,\u0017aC(C\rV\u001b6)\u0011+F\t\u0002\nQ!\u00199qYf$\"!I@\t\r\u0005\u0005Q\u00021\u0001-\u0003My'MZ;tG\u0006$\u0018n\u001c8NKR\fG-\u0019;b\u0001")
public class CypherQueryObfuscator
implements QueryObfuscator {
    private final ObfuscationMetadata state;

    public static QueryObfuscator apply(ObfuscationMetadata obfuscationMetadata) {
        return CypherQueryObfuscator$.MODULE$.apply(obfuscationMetadata);
    }

    public String obfuscateText(String rawQueryText) {
        String string;
        if (this.state.sensitiveLiteralOffsets().isEmpty()) {
            string = rawQueryText;
        } else {
            scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
            IntRef i = IntRef.create((int)0);
            Vector adjacentCharacters = new StringOps(Predef$.MODULE$.augmentString(rawQueryText)).sliding(2).toVector();
            this.state.sensitiveLiteralOffsets().foreach((Function1 & Serializable & scala.Serializable)literalOffset -> {
                CypherQueryObfuscator.$anonfun$obfuscateText$1(this, rawQueryText, i, sb, adjacentCharacters, literalOffset);
                return BoxedUnit.UNIT;
            });
            Object object = i.elem < rawQueryText.length() ? sb.append(rawQueryText.substring(i.elem)) : BoxedUnit.UNIT;
            string = sb.toString();
        }
        return string;
    }

    public MapValue obfuscateParameters(MapValue rawQueryParameters) {
        MapValue mapValue;
        if (this.state.sensitiveParameterNames().isEmpty()) {
            mapValue = rawQueryParameters;
        } else {
            ObjectRef params = ObjectRef.create((Object)rawQueryParameters);
            this.state.sensitiveParameterNames().foreach((Function1 & Serializable & scala.Serializable)p -> {
                params.elem = ((MapValue)params.elem).updatedWith(p, (AnyValue)CypherQueryObfuscator$.MODULE$.org$neo4j$cypher$internal$CypherQueryObfuscator$$OBFUSCATED());
                return BoxedUnit.UNIT;
            });
            mapValue = (MapValue)params.elem;
        }
        return mapValue;
    }

    private int literalStringLength(Seq<String> adjacentCharacters, String rawQueryText, int fromIndex) {
        char openingQuote = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(rawQueryText), fromIndex);
        if (openingQuote != '\"' && openingQuote != '\'') {
            throw new IllegalStateException(new StringBuilder(34).append("Expected opening quote at offset ").append(fromIndex).append(".").toString());
        }
        int lastCharacterIndex = adjacentCharacters.indexWhere((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)CypherQueryObfuscator.$anonfun$literalStringLength$1(openingQuote, s)), fromIndex);
        if (lastCharacterIndex == -1) {
            throw new IllegalStateException("Expected to find closing quote.");
        }
        return lastCharacterIndex - fromIndex + 2;
    }

    public static final /* synthetic */ void $anonfun$obfuscateText$1(CypherQueryObfuscator $this, String rawQueryText$1, IntRef i$1, scala.collection.mutable.StringBuilder sb$1, Vector adjacentCharacters$1, LiteralOffset literalOffset) {
        int start = literalOffset.start();
        if (start >= rawQueryText$1.length() || start < i$1.elem) {
            throw new IllegalStateException(new StringBuilder(31).append("Literal offset out of bounds: ").append(literalOffset).append(".").toString());
        }
        sb$1.append(rawQueryText$1.substring(i$1.elem, start));
        sb$1.append(CypherQueryObfuscator$.MODULE$.org$neo4j$cypher$internal$CypherQueryObfuscator$$OBFUSCATED_LITERAL());
        i$1.elem = start + BoxesRunTime.unboxToInt((Object)literalOffset.length().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.literalStringLength((Seq<String>)adjacentCharacters$1, rawQueryText$1, start)));
    }

    public static final /* synthetic */ boolean $anonfun$literalStringLength$1(char openingQuote$1, String s) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0) != '\\' && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 1) == openingQuote$1;
    }

    public CypherQueryObfuscator(ObfuscationMetadata state) {
        this.state = state;
    }
}

