/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

public class QuantizedProjection {
    private final long max;
    private final long projectedMax;
    private double absoluteWay;
    private long step;

    public QuantizedProjection(long max, long projectedMax) {
        this.max = max;
        this.projectedMax = projectedMax;
    }

    public boolean next(long step) {
        double absoluteStep = (double)step / (double)this.max;
        if (this.absoluteWay + absoluteStep > 1.0) {
            return false;
        }
        long prevProjection = Math.round(this.absoluteWay * (double)this.projectedMax);
        this.absoluteWay += absoluteStep;
        long projection = Math.round(this.absoluteWay * (double)this.projectedMax);
        this.step = projection - prevProjection;
        return true;
    }

    public long step() {
        return this.step;
    }
}

