/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.DatabaseConfig;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.DatabaseOptions;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.ModularDatabaseCreationContext;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.graphdb.factory.module.edition.context.EditionDatabaseComponents;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.DatabaseCreationContext;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.MapCachingDatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.SystemGraphDatabaseIdRepository;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.context.TransactionVersionContextSupplier;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.StorageEngineFactory;

public abstract class AbstractDatabaseManager<DB extends DatabaseContext>
extends LifecycleAdapter
implements DatabaseManager<DB> {
    protected final Map<NamedDatabaseId, DB> databaseMap;
    protected final GlobalModule globalModule;
    protected final AbstractEditionModule edition;
    protected final Log log;
    protected final boolean manageDatabasesOnStartAndStop;
    protected final Config config;
    protected final LogProvider logProvider;
    private final DatabaseIdRepository.Caching databaseIdRepository;

    protected AbstractDatabaseManager(GlobalModule globalModule, AbstractEditionModule edition, boolean manageDatabasesOnStartAndStop) {
        this.logProvider = globalModule.getLogService().getInternalLogProvider();
        this.log = this.logProvider.getLog(((Object)((Object)this)).getClass());
        this.globalModule = globalModule;
        this.config = globalModule.getGlobalConfig();
        this.edition = edition;
        this.manageDatabasesOnStartAndStop = manageDatabasesOnStartAndStop;
        this.databaseMap = new ConcurrentHashMap<NamedDatabaseId, DB>();
        this.databaseIdRepository = this.createDatabaseIdRepository(globalModule);
    }

    private DatabaseIdRepository.Caching createDatabaseIdRepository(GlobalModule globalModule) {
        return CommunityEditionModule.tryResolveOrCreate(DatabaseIdRepository.Caching.class, globalModule.getExternalDependencyResolver(), () -> new MapCachingDatabaseIdRepository((DatabaseIdRepository)new SystemGraphDatabaseIdRepository(() -> ((AbstractDatabaseManager)this).getSystemDatabaseContext())));
    }

    public DatabaseIdRepository.Caching databaseIdRepository() {
        return this.databaseIdRepository;
    }

    public final void init() {
    }

    public void start() throws Exception {
        if (this.manageDatabasesOnStartAndStop) {
            this.startAllDatabases();
        }
    }

    private void startAllDatabases() {
        this.forEachDatabase(this::startDatabase, false, "start");
    }

    public void stop() throws Exception {
        if (this.manageDatabasesOnStartAndStop) {
            this.stopAllDatabases();
        }
    }

    private void stopAllDatabases() {
        this.forEachDatabase(this::stopDatabase, true, "stop");
    }

    public Optional<DB> getDatabaseContext(NamedDatabaseId namedDatabaseId) {
        return Optional.ofNullable((DatabaseContext)this.databaseMap.get(namedDatabaseId));
    }

    public Optional<DB> getDatabaseContext(String databaseName) {
        try {
            return this.databaseIdRepository().getByName(databaseName).flatMap(this::getDatabaseContext);
        }
        catch (DatabaseShutdownException e) {
            return this.searchContext(id -> id.name().equals(databaseName));
        }
    }

    public Optional<DB> getDatabaseContext(DatabaseId databaseId) {
        try {
            return this.databaseIdRepository().getById(databaseId).flatMap(this::getDatabaseContext);
        }
        catch (DatabaseShutdownException e) {
            return this.searchContext(id -> id.databaseId().equals((Object)databaseId));
        }
    }

    public final SortedMap<NamedDatabaseId, DB> registeredDatabases() {
        return this.databasesSnapshot();
    }

    private NavigableMap<NamedDatabaseId, DB> databasesSnapshot() {
        return Collections.unmodifiableNavigableMap(new TreeMap<NamedDatabaseId, DB>(this.databaseMap));
    }

    private Optional<DB> searchContext(Predicate<NamedDatabaseId> predicate) {
        return this.databaseMap.entrySet().stream().filter(entry -> predicate.test((NamedDatabaseId)entry.getKey())).map(Map.Entry::getValue).findFirst();
    }

    protected abstract DB createDatabaseContext(NamedDatabaseId var1, DatabaseOptions var2) throws Exception;

    protected ModularDatabaseCreationContext newDatabaseCreationContext(NamedDatabaseId namedDatabaseId, DatabaseOptions databaseOptions, Dependencies parentDependencies, Monitors parentMonitors) {
        EditionDatabaseComponents editionDatabaseComponents = this.edition.createDatabaseComponents(namedDatabaseId);
        GlobalProcedures globalProcedures = (GlobalProcedures)parentDependencies.resolveDependency(GlobalProcedures.class);
        DatabaseConfig databaseConfig = new DatabaseConfig(databaseOptions.settings(), this.config, namedDatabaseId);
        StorageEngineFactory storageEngineFactory = DatabaseCreationContext.selectStorageEngine((FileSystemAbstraction)this.globalModule.getFileSystem(), (Neo4jLayout)this.globalModule.getNeo4jLayout(), (PageCache)this.globalModule.getPageCache(), (Configuration)databaseConfig, (NamedDatabaseId)namedDatabaseId);
        return new ModularDatabaseCreationContext(namedDatabaseId, this.globalModule, parentDependencies, parentMonitors, editionDatabaseComponents, globalProcedures, this.createVersionContextSupplier(databaseConfig), databaseConfig, LeaseService.NO_LEASES, editionDatabaseComponents.getExternalIdReuseConditionProvider(), storageEngineFactory, this.edition.getReadOnlyChecker());
    }

    private void forEachDatabase(BiConsumer<NamedDatabaseId, DB> consumer, boolean systemDatabaseLast, String operationName) {
        Set snapshot = systemDatabaseLast ? this.databasesSnapshot().descendingMap().entrySet() : this.databasesSnapshot().entrySet();
        DatabaseManagementException dbmsExceptions = null;
        for (Map.Entry entry : snapshot) {
            NamedDatabaseId namedDatabaseId = (NamedDatabaseId)entry.getKey();
            DatabaseContext context = (DatabaseContext)entry.getValue();
            try {
                consumer.accept(namedDatabaseId, context);
            }
            catch (Throwable t) {
                DatabaseManagementException dbmsException = new DatabaseManagementException(String.format("An error occurred! Unable to %s the database `%s`.", operationName, namedDatabaseId), t);
                dbmsExceptions = (DatabaseManagementException)Exceptions.chain(dbmsExceptions, (Throwable)dbmsException);
            }
        }
        if (dbmsExceptions != null) {
            throw dbmsExceptions;
        }
    }

    protected void startDatabase(NamedDatabaseId namedDatabaseId, DB context) {
        try {
            this.log.info("Starting '%s'.", new Object[]{namedDatabaseId});
            Database database = context.database();
            database.start();
        }
        catch (Throwable t) {
            throw new DatabaseManagementException(String.format("An error occurred! Unable to start `%s`.", namedDatabaseId), t);
        }
    }

    protected void stopDatabase(NamedDatabaseId namedDatabaseId, DB context) {
        try {
            this.log.info("Stopping '%s'.", new Object[]{namedDatabaseId});
            Database database = context.database();
            database.stop();
            this.log.info("Stopped '%s' successfully.", new Object[]{namedDatabaseId});
        }
        catch (Throwable t) {
            this.log.error("Error stopping '%s'.", new Object[]{namedDatabaseId});
            throw new DatabaseManagementException(String.format("An error occurred! Unable to stop `%s`.", namedDatabaseId), t);
        }
    }

    protected final VersionContextSupplier createVersionContextSupplier(DatabaseConfig databaseConfig) {
        VersionContextSupplier.Factory factory = AbstractDatabaseManager.externalVersionContextSupplierFactory(this.globalModule).orElse(AbstractDatabaseManager.internalVersionContextSupplierFactory(databaseConfig));
        return factory.create();
    }

    private static Optional<VersionContextSupplier.Factory> externalVersionContextSupplierFactory(GlobalModule globalModule) {
        Class<VersionContextSupplier.Factory> klass;
        DependencyResolver externalDependencies = globalModule.getExternalDependencyResolver();
        if (externalDependencies.containsDependency(klass = VersionContextSupplier.Factory.class)) {
            return Optional.of((VersionContextSupplier.Factory)externalDependencies.resolveDependency(klass));
        }
        return Optional.empty();
    }

    private static VersionContextSupplier.Factory internalVersionContextSupplierFactory(DatabaseConfig databaseConfig) {
        return () -> (Boolean)databaseConfig.get(GraphDatabaseInternalSettings.snapshot_query) != false ? new TransactionVersionContextSupplier() : EmptyVersionContextSupplier.EMPTY;
    }
}

