/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Objects;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementException;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.AbstractDatabaseManager;
import org.neo4j.dbms.database.DatabaseOptions;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.ModularDatabaseCreationContext;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.DatabaseCreationContext;
import org.neo4j.kernel.database.NamedDatabaseId;

public final class DefaultDatabaseManager
extends AbstractDatabaseManager<StandaloneDatabaseContext> {
    public DefaultDatabaseManager(GlobalModule globalModule, AbstractEditionModule edition) {
        super(globalModule, edition, true);
    }

    public void initialiseSystemDatabase() {
        this.createDatabase(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID);
    }

    public void initialiseDefaultDatabase() {
        String databaseName = (String)this.config.get(GraphDatabaseSettings.default_database);
        NamedDatabaseId namedDatabaseId = (NamedDatabaseId)this.databaseIdRepository().getByName(databaseName).orElseThrow(() -> new DatabaseNotFoundException("Default database not found: " + databaseName));
        StandaloneDatabaseContext context = this.createDatabase(namedDatabaseId);
        if (this.manageDatabasesOnStartAndStop) {
            this.startDatabase(namedDatabaseId, context);
        }
    }

    public synchronized StandaloneDatabaseContext createDatabase(NamedDatabaseId namedDatabaseId) {
        Objects.requireNonNull(namedDatabaseId);
        this.log.info("Creating '%s'.", new Object[]{namedDatabaseId});
        this.checkDatabaseLimit(namedDatabaseId);
        StandaloneDatabaseContext databaseContext = this.createDatabaseContext(namedDatabaseId, DatabaseOptions.EMPTY);
        this.databaseMap.put(namedDatabaseId, databaseContext);
        return databaseContext;
    }

    @Override
    protected StandaloneDatabaseContext createDatabaseContext(NamedDatabaseId namedDatabaseId, DatabaseOptions databaseOptions) {
        ModularDatabaseCreationContext databaseCreationContext = this.newDatabaseCreationContext(namedDatabaseId, databaseOptions, this.globalModule.getGlobalDependencies(), this.globalModule.getGlobalMonitors());
        Database kernelDatabase = new Database((DatabaseCreationContext)databaseCreationContext);
        return new StandaloneDatabaseContext(kernelDatabase);
    }

    public void dropDatabase(NamedDatabaseId ignore) {
        throw new DatabaseManagementException("Default database manager does not support database drop.");
    }

    public synchronized void upgradeDatabase(NamedDatabaseId namedDatabaseId) throws DatabaseNotFoundException {
        StandaloneDatabaseContext context = (StandaloneDatabaseContext)this.getDatabaseContext(namedDatabaseId).orElseThrow(() -> new DatabaseNotFoundException("Database not found: " + namedDatabaseId));
        Database database = context.database();
        this.log.info("Upgrading '%s'.", new Object[]{namedDatabaseId});
        context.fail(null);
        try {
            database.upgrade(true);
        }
        catch (Throwable throwable) {
            String message = "Failed to upgrade " + namedDatabaseId;
            context.fail(throwable);
            throw new DatabaseManagementException(message, throwable);
        }
    }

    public void stopDatabase(NamedDatabaseId ignore) {
        throw new DatabaseManagementException("Default database manager does not support database stop.");
    }

    public void startDatabase(NamedDatabaseId namedDatabaseId) {
        throw new DatabaseManagementException("Default database manager does not support starting databases.");
    }

    @Override
    protected void stopDatabase(NamedDatabaseId namedDatabaseId, StandaloneDatabaseContext context) {
        try {
            super.stopDatabase(namedDatabaseId, context);
        }
        catch (Throwable t) {
            this.log.error("Failed to stop " + namedDatabaseId, t);
            context.fail(t);
        }
    }

    @Override
    protected void startDatabase(NamedDatabaseId namedDatabaseId, StandaloneDatabaseContext context) {
        try {
            super.startDatabase(namedDatabaseId, context);
        }
        catch (Throwable t) {
            this.log.error("Failed to start " + namedDatabaseId, t);
            context.fail(t);
        }
    }

    private void checkDatabaseLimit(NamedDatabaseId namedDatabaseId) {
        if (this.databaseMap.size() >= 2) {
            throw new DatabaseManagementException("Default database already exists. Fail to create another: " + namedDatabaseId);
        }
    }
}

