/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.AbstractSystemGraphComponent;
import org.neo4j.dbms.database.KnownSystemComponentVersion;
import org.neo4j.dbms.database.KnownSystemComponentVersions;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.systemgraph.versions.CommunityTopologyComponentVersion_0_44;
import org.neo4j.dbms.systemgraph.versions.KnownCommunityTopologyComponentVersion;
import org.neo4j.dbms.systemgraph.versions.NoCommunityTopologyComponentVersion;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class CommunityTopologyGraphComponent
extends AbstractSystemGraphComponent {
    private final Log log;
    private final KnownSystemComponentVersions<KnownCommunityTopologyComponentVersion> knownCommunityTopologyComponentVersions = new KnownSystemComponentVersions((KnownSystemComponentVersion)new NoCommunityTopologyComponentVersion());

    public CommunityTopologyGraphComponent(Config config, LogProvider logProvider) {
        super(config);
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        CommunityTopologyComponentVersion_0_44 version0 = new CommunityTopologyComponentVersion_0_44();
        this.knownCommunityTopologyComponentVersions.add((KnownSystemComponentVersion)version0);
    }

    public String componentName() {
        return "community-topology-graph";
    }

    public SystemGraphComponent.Status detect(Transaction tx) {
        return ((KnownCommunityTopologyComponentVersion)this.knownCommunityTopologyComponentVersions.detectCurrentComponentVersion(tx)).getStatus();
    }

    protected void initializeSystemGraphModel(Transaction tx) {
        KnownCommunityTopologyComponentVersion latest = (KnownCommunityTopologyComponentVersion)this.knownCommunityTopologyComponentVersions.latestComponentVersion();
        latest.setVersionProperty(tx, latest.version);
        latest.initializeTopologyGraph(tx);
    }

    public void upgradeToCurrent(GraphDatabaseService system) throws Exception {
        SystemGraphComponent.executeWithFullAccess((GraphDatabaseService)system, tx -> {
            KnownCommunityTopologyComponentVersion currentVersion = (KnownCommunityTopologyComponentVersion)this.knownCommunityTopologyComponentVersions.detectCurrentComponentVersion(tx);
            this.log.debug(String.format("Trying to upgrade component '%s' with version %d and status %s to latest version", "community-topology-graph", currentVersion.version, currentVersion.getStatus()));
            if (currentVersion.version == -1) {
                this.log.debug("The current version does not have a community topology graph, doing a full initialization");
                this.initializeSystemGraphModel((Transaction)tx);
            } else if (currentVersion.migrationSupported()) {
                this.log.info(String.format("Upgrading '%s' component to latest version", "community-topology-graph"));
                ((KnownCommunityTopologyComponentVersion)this.knownCommunityTopologyComponentVersions.latestComponentVersion()).upgradeTopologyGraph((Transaction)tx, currentVersion.version);
            } else {
                throw currentVersion.unsupported();
            }
        });
    }
}

