/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.bufferpool.impl;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.bufferpool.impl.Bucket;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

class BucketBootstrapper {
    private static final double SMALL_BUFFER_SLICE_COEFFICIENT = 0.125;
    private static final int LARGE_BUFFER_SLICE_COUNT = 1;
    private static final int SMALLEST_POOLED_BUFFER = 256;
    private static final int LARGEST_POOLED_BUFFER = (int)ByteUnit.mebiBytes(1L);
    private static final int LARGE_BUFFER_THRESHOLD = (int)ByteUnit.kibiBytes(64L);
    private final List<Bucket> buckets = new ArrayList<Bucket>();
    private final int maxPooledBufferCapacity;

    BucketBootstrapper(MemoryTracker memoryTracker) {
        for (int bufferSize = 256; bufferSize <= LARGEST_POOLED_BUFFER; bufferSize <<= 1) {
            int bufferCapacity = bufferSize;
            if ((long)bufferCapacity == ByteUnit.kibiBytes(16L)) {
                bufferCapacity = (int)ByteUnit.kibiBytes(16L) + 512;
            }
            this.buckets.add(this.createBucket(bufferCapacity, memoryTracker));
        }
        this.maxPooledBufferCapacity = this.buckets.get(this.buckets.size() - 1).getBufferCapacity();
    }

    private Bucket createBucket(int bufferCapacity, MemoryTracker memoryTracker) {
        int sliceCount = 1;
        if (bufferCapacity <= LARGE_BUFFER_THRESHOLD) {
            sliceCount = this.calculateSmallBufferSliceCount();
        }
        return new Bucket(bufferCapacity, sliceCount, memoryTracker);
    }

    private int calculateSmallBufferSliceCount() {
        return (int)Math.ceil((double)this.getAvailableCpuCount() * 0.125);
    }

    List<Bucket> getBuckets() {
        return this.buckets;
    }

    int getMaxPooledBufferCapacity() {
        return this.maxPooledBufferCapacity;
    }

    @VisibleForTesting
    protected int getAvailableCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }
}

