/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.RecordReader;
import org.neo4j.consistency.checker.SchemaComplianceChecker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.function.ThrowingIntFunction;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class RecordLoading {
    static final BiConsumer<Long, DynamicRecord> NO_DYNAMIC_HANDLER = (id, r) -> {};
    private final NeoStores neoStores;

    RecordLoading(NeoStores neoStores) {
        this.neoStores = neoStores;
    }

    static long[] safeGetNodeLabels(CheckerContext context, StoreCursors storeCursors, long nodeId, long labelField, RecordReader<DynamicRecord> labelReader) {
        if (!NodeLabelsField.fieldPointsToDynamicRecordOfLabels((long)labelField)) {
            return InlineNodeLabels.parseInlined((long)labelField);
        }
        ArrayList records = new ArrayList();
        LongHashSet seenRecordIds = new LongHashSet();
        ConsistencyReport.Reporter reporter = context.reporter;
        RecordLoading recordLoader = context.recordLoader;
        int nodeLabelBlockSize = context.neoStores.getNodeStore().getDynamicLabelStore().getRecordDataSize();
        if (RecordLoading.safeLoadDynamicRecordChain(record -> records.add(record.copy()), labelReader, (MutableLongSet)seenRecordIds, NodeLabelsField.firstDynamicLabelRecordId((long)labelField), nodeLabelBlockSize, (id, labelRecord) -> reporter.forNode(recordLoader.node(nodeId, storeCursors)).dynamicRecordChainCycle((DynamicRecord)labelRecord), (id, labelRecord) -> reporter.forNode(recordLoader.node(nodeId, storeCursors)).dynamicLabelRecordNotInUse((DynamicRecord)labelRecord), (id, labelRecord) -> reporter.forNode(recordLoader.node(nodeId, storeCursors)).dynamicLabelRecordNotInUse((DynamicRecord)labelRecord), (id, labelRecord) -> reporter.forDynamicBlock(RecordType.NODE_DYNAMIC_LABEL, (DynamicRecord)labelRecord).emptyBlock(), labelRecord -> reporter.forDynamicBlock(RecordType.NODE_DYNAMIC_LABEL, (DynamicRecord)labelRecord).recordNotFullReferencesNext(), labelRecord -> reporter.forDynamicBlock(RecordType.NODE_DYNAMIC_LABEL, (DynamicRecord)labelRecord).invalidLength())) {
            return DynamicNodeLabels.getDynamicLabelsArray(records, (AbstractDynamicStore)((AbstractDynamicStore)labelReader.store()), (StoreCursors)storeCursors);
        }
        return null;
    }

    private static Value[] matchAllProperties(IntObjectMap<Value> values, int[] propertyKeyIds, IndexType indexType) {
        Value[] array = new Value[propertyKeyIds.length];
        for (int i = 0; i < propertyKeyIds.length; ++i) {
            int propertyKeyId = propertyKeyIds[i];
            Value value = (Value)values.get(propertyKeyId);
            if (value == null || !SchemaComplianceChecker.isValueSupportedByIndex(indexType, value)) {
                return null;
            }
            array[i] = value;
        }
        return array;
    }

    private static Value[] matchAnyProperty(IntObjectMap<Value> values, int[] propertyKeyIds, IndexType indexType) {
        Value[] array = new Value[propertyKeyIds.length];
        boolean anyFound = false;
        for (int i = 0; i < propertyKeyIds.length; ++i) {
            Value value = (Value)values.get(propertyKeyIds[i]);
            if (value != null && SchemaComplianceChecker.isValueSupportedByIndex(indexType, value)) {
                anyFound = true;
            } else {
                value = Values.NO_VALUE;
            }
            array[i] = value;
        }
        return anyFound ? array : null;
    }

    static Value[] entityIntersectionWithSchema(long[] entityTokens, IntObjectMap<Value> values, SchemaDescriptor schema, IndexType indexType) {
        Value[] valueArray = null;
        if (schema.isAffected(entityTokens)) {
            boolean requireAllTokens = schema.propertySchemaType() == PropertySchemaType.COMPLETE_ALL_TOKENS;
            valueArray = requireAllTokens ? RecordLoading.matchAllProperties(values, schema.getPropertyIds(), indexType) : RecordLoading.matchAnyProperty(values, schema.getPropertyIds(), indexType);
        }
        return valueArray;
    }

    <T extends PrimitiveRecord> T entity(T entityCursor, StoreCursors storeCursors) {
        if (entityCursor instanceof NodeRecord) {
            return (T)this.node(entityCursor.getId(), storeCursors);
        }
        if (entityCursor instanceof RelationshipRecord) {
            return (T)this.relationship(entityCursor.getId(), storeCursors);
        }
        throw new IllegalArgumentException("Was expecting either node cursor or relationship cursor, got " + entityCursor);
    }

    NodeRecord node(long id, StoreCursors storeCursors) {
        return (NodeRecord)RecordLoading.loadRecord(this.neoStores.getNodeStore(), id, storeCursors.readCursor((CursorType)RecordCursorTypes.NODE_CURSOR));
    }

    PropertyRecord property(long id, StoreCursors storeCursors) {
        return (PropertyRecord)RecordLoading.loadRecord(this.neoStores.getPropertyStore(), id, storeCursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR));
    }

    RelationshipRecord relationship(long id, StoreCursors storeCursors) {
        return (RelationshipRecord)RecordLoading.loadRecord(this.neoStores.getRelationshipStore(), id, storeCursors.readCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR));
    }

    RelationshipRecord relationship(RelationshipRecord into, long id, StoreCursors storeCursors) {
        return RecordLoading.loadRecord(this.neoStores.getRelationshipStore(), into, id, storeCursors.readCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR));
    }

    RelationshipGroupRecord relationshipGroup(long id, StoreCursors storeCursors) {
        return (RelationshipGroupRecord)RecordLoading.loadRecord(this.neoStores.getRelationshipGroupStore(), id, storeCursors.readCursor((CursorType)RecordCursorTypes.GROUP_CURSOR));
    }

    static <RECORD extends AbstractBaseRecord> RECORD loadRecord(RecordStore<RECORD> store, long id, PageCursor pageCursor) {
        return (RECORD)RecordLoading.loadRecord(store, store.newRecord(), id, pageCursor);
    }

    static <RECORD extends AbstractBaseRecord> RECORD loadRecord(RecordStore<RECORD> store, RECORD record, long id, PageCursor pageCursor) {
        return (RECORD)store.getRecordByCursor(id, record, RecordLoad.FORCE, pageCursor);
    }

    static <RECORD extends TokenRecord> List<NamedToken> safeLoadTokens(TokenStore<RECORD> tokenStore, CursorContext cursorContext) {
        long highId = tokenStore.getHighId();
        ArrayList<NamedToken> tokens = new ArrayList<NamedToken>();
        DynamicStringStore nameStore = tokenStore.getNameStore();
        ArrayList nameRecords = new ArrayList();
        LongHashSet seenRecordIds = new LongHashSet();
        int nameBlockSize = nameStore.getRecordDataSize();
        try (RecordReader tokenReader = new RecordReader(tokenStore, true, cursorContext);
             RecordReader<DynamicRecord> nameReader = new RecordReader<DynamicRecord>((CommonAbstractStore<DynamicRecord, ?>)nameStore, false, cursorContext);){
            for (long id = 0L; id < highId; ++id) {
                String name;
                TokenRecord record = (TokenRecord)tokenReader.read(id);
                nameRecords.clear();
                if (!record.inUse()) continue;
                seenRecordIds = RecordLoading.lightReplace(seenRecordIds);
                if (!Record.NULL_REFERENCE.is((long)record.getNameId()) && RecordLoading.safeLoadDynamicRecordChain(r -> nameRecords.add(r.copy()), nameReader, (MutableLongSet)seenRecordIds, record.getNameId(), nameBlockSize)) {
                    record.addNameRecords(nameRecords);
                    name = tokenStore.getStringFor(record, StoreCursors.NULL);
                } else {
                    name = String.format("<name not loaded due to token(%d) referencing unused name record>", id);
                }
                tokens.add(new NamedToken(name, Math.toIntExact(id), record.isInternal()));
            }
        }
        return tokens;
    }

    static boolean safeLoadDynamicRecordChain(Consumer<DynamicRecord> target, RecordReader<DynamicRecord> reader, MutableLongSet seenRecordIds, long recordId, int blockSize) {
        return RecordLoading.safeLoadDynamicRecordChain(target, reader, seenRecordIds, recordId, blockSize, NO_DYNAMIC_HANDLER, NO_DYNAMIC_HANDLER, NO_DYNAMIC_HANDLER, NO_DYNAMIC_HANDLER, r -> {}, r -> {});
    }

    static boolean safeLoadDynamicRecordChain(Consumer<DynamicRecord> target, RecordReader<DynamicRecord> reader, MutableLongSet seenRecordIds, long recordId, int blockSize, BiConsumer<Long, DynamicRecord> circularReferenceReport, BiConsumer<Long, DynamicRecord> unusedChainReport, BiConsumer<Long, DynamicRecord> brokenChainReport, BiConsumer<Long, DynamicRecord> emptyRecordReport, Consumer<DynamicRecord> notFullReferencesNextReport, Consumer<DynamicRecord> invalidLengthReport) {
        assert (seenRecordIds.isEmpty());
        long firstRecordId = recordId;
        long prevRecordId = Record.NULL_REFERENCE.longValue();
        boolean chainIsOk = true;
        while (!Record.NULL_REFERENCE.is(recordId)) {
            if (!seenRecordIds.add(recordId)) {
                circularReferenceReport.accept(firstRecordId, reader.record());
                return false;
            }
            DynamicRecord record = reader.read(recordId);
            if (!record.inUse()) {
                BiConsumer<Long, DynamicRecord> reporter = recordId == firstRecordId ? unusedChainReport : brokenChainReport;
                reporter.accept(prevRecordId, record);
                return false;
            }
            if (record.getLength() == 0) {
                emptyRecordReport.accept(firstRecordId, record);
                chainIsOk = false;
            }
            if (record.getLength() < blockSize && !Record.NULL_REFERENCE.is(record.getNextBlock())) {
                notFullReferencesNextReport.accept(record);
                chainIsOk = false;
            }
            if (record.getLength() > blockSize) {
                invalidLengthReport.accept(record);
                chainIsOk = false;
            }
            target.accept(record);
            prevRecordId = recordId;
            recordId = record.getNextBlock();
        }
        return chainIsOk;
    }

    static <RECORD extends AbstractBaseRecord, TOKEN extends TokenRecord> boolean checkValidInternalToken(RECORD entity, int token, TokenHolder tokens, TokenStore<TOKEN> tokenStore, BiConsumer<RECORD, Integer> illegalTokenReport, BiConsumer<RECORD, TOKEN> unusedReporter, StoreCursors storeCursors) {
        return RecordLoading.checkValidToken(entity, token, tokens, tokenStore, illegalTokenReport, unusedReporter, (ThrowingIntFunction<NamedToken, TokenNotFoundException>)((ThrowingIntFunction)arg_0 -> ((TokenHolder)tokens).getInternalTokenById(arg_0)), storeCursors);
    }

    static <RECORD extends AbstractBaseRecord, TOKEN extends TokenRecord> boolean checkValidToken(RECORD entity, int token, TokenHolder tokens, TokenStore<TOKEN> tokenStore, BiConsumer<RECORD, Integer> illegalTokenReport, BiConsumer<RECORD, TOKEN> unusedReporter, StoreCursors storeCursors) {
        return RecordLoading.checkValidToken(entity, token, tokens, tokenStore, illegalTokenReport, unusedReporter, (ThrowingIntFunction<NamedToken, TokenNotFoundException>)((ThrowingIntFunction)arg_0 -> ((TokenHolder)tokens).getTokenById(arg_0)), storeCursors);
    }

    private static <RECORD extends AbstractBaseRecord, TOKEN extends TokenRecord> boolean checkValidToken(RECORD entity, int token, TokenHolder tokens, TokenStore<TOKEN> tokenStore, BiConsumer<RECORD, Integer> illegalTokenReport, BiConsumer<RECORD, TOKEN> unusedReporter, ThrowingIntFunction<NamedToken, TokenNotFoundException> tokenGetter, StoreCursors storeCursors) {
        if (token < 0) {
            illegalTokenReport.accept(entity, token);
            return false;
        }
        try {
            tokens.getTokenById(token);
        }
        catch (TokenNotFoundException tnfe) {
            TokenRecord tokenRecord = (TokenRecord)tokenStore.getRecordByCursor((long)token, (AbstractBaseRecord)((TokenRecord)tokenStore.newRecord()), RecordLoad.FORCE, tokenStore.getTokenStoreCursor(storeCursors));
            unusedReporter.accept(entity, tokenRecord);
            return false;
        }
        return true;
    }

    static ArrayList<DynamicRecord> lightReplace(ArrayList<DynamicRecord> list) {
        return list.isEmpty() ? list : new ArrayList();
    }

    static LongHashSet lightReplace(LongHashSet set) {
        return set.isEmpty() ? set : new LongHashSet();
    }

    static IntHashSet lightReplace(IntHashSet set) {
        return set.isEmpty() ? set : new IntHashSet();
    }

    static IntObjectHashMap<Value> lightReplace(IntObjectHashMap<Value> map) {
        return map.isEmpty() ? map : new IntObjectHashMap();
    }
}

