/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.pushtocloud;

interface PushToCloudConsole {
    public String readLine(String var1, Object ... var2);

    public char[] readPassword(String var1, Object ... var2);

    public boolean readDevMode(String var1);

    public static PushToCloudConsole realConsole() {
        return new PushToCloudConsole(){

            @Override
            public String readLine(String fmt, Object ... args) {
                return System.console().readLine(fmt, args);
            }

            @Override
            public char[] readPassword(String fmt, Object ... args) {
                return System.console().readPassword(fmt, args);
            }

            @Override
            public boolean readDevMode(String devModeEnvVar) {
                return Boolean.parseBoolean(System.getenv(devModeEnvVar));
            }
        };
    }

    public static PushToCloudConsole fakeConsole(final String username, final String password, final boolean devMode) {
        return new PushToCloudConsole(){

            @Override
            public String readLine(String fmt, Object ... args) {
                return username;
            }

            @Override
            public char[] readPassword(String fmt, Object ... args) {
                return password.toCharArray();
            }

            @Override
            public boolean readDevMode(String devModeEnvVar) {
                return devMode;
            }
        };
    }
}

