/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.collection.trackable.HeapTrackingLongObjectHashMap;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

class HeapTrackingIntObjectHashMap<V>
extends IntObjectHashMap<V>
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingLongObjectHashMap.class);
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final MemoryTracker memoryTracker;
    private int trackedCapacity;

    static <V> HeapTrackingIntObjectHashMap<V> createIntObjectHashMap(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingIntObjectHashMap.arraysHeapSize(16));
        return new HeapTrackingIntObjectHashMap<V>(memoryTracker, 16);
    }

    private HeapTrackingIntObjectHashMap(MemoryTracker memoryTracker, int trackedCapacity) {
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = trackedCapacity;
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            this.memoryTracker.allocateHeap(HeapTrackingIntObjectHashMap.arraysHeapSize(sizeToAllocate));
            this.memoryTracker.releaseHeap(HeapTrackingIntObjectHashMap.arraysHeapSize(this.trackedCapacity));
            this.trackedCapacity = sizeToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(HeapTrackingIntObjectHashMap.arraysHeapSize(this.trackedCapacity) + SHALLOW_SIZE);
    }

    static long arraysHeapSize(int arrayLength) {
        long keyArray = HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * 4L));
        long valueArray = HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * (long)HeapEstimator.OBJECT_REFERENCE_BYTES));
        return keyArray + valueArray;
    }
}

