/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.ResourceUtils;

public abstract class ResourceClosingIterator<T, V>
implements ResourceIterator<V> {
    private Resource[] resources;
    private final Iterator<T> iterator;

    public static <R> ResourceIterator<R> newResourceIterator(Iterator<R> iterator, Resource ... resources) {
        return new ResourceClosingIterator<R, R>(iterator, resources){

            @Override
            public R map(R elem) {
                return elem;
            }
        };
    }

    ResourceClosingIterator(Iterator<T> iterator, Resource ... resources) {
        this.resources = resources;
        this.iterator = iterator;
    }

    public void close() {
        if (this.resources != null) {
            ResourceUtils.closeAll((Resource[])this.resources);
            this.resources = null;
        }
    }

    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    public abstract V map(T var1);

    public V next() {
        try {
            return this.map(this.iterator.next());
        }
        catch (NoSuchElementException e) {
            this.close();
            throw e;
        }
    }

    public void remove() {
        this.iterator.remove();
    }
}

