/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.scheduling;

import io.netty.channel.Channel;
import java.util.Collection;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.Job;
import org.neo4j.bolt.runtime.scheduling.BoltConnectionQueueMonitor;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public class BoltConnectionReadLimiter
implements BoltConnectionQueueMonitor {
    private final Log log;
    private final int lowWatermark;
    private final int highWatermark;
    private int queueSize;

    public BoltConnectionReadLimiter(LogService logService, int lowWatermark, int highWatermark) {
        if (highWatermark <= 0) {
            throw new IllegalArgumentException("invalid highWatermark value");
        }
        if (lowWatermark < 0 || lowWatermark >= highWatermark) {
            throw new IllegalArgumentException("invalid lowWatermark value");
        }
        this.log = logService.getInternalLog(this.getClass());
        this.lowWatermark = lowWatermark;
        this.highWatermark = highWatermark;
    }

    @Override
    public synchronized void enqueued(BoltConnection to, Job job) {
        ++this.queueSize;
        this.checkLimitsOnEnqueue(to);
    }

    @Override
    public synchronized void drained(BoltConnection from, Collection<Job> batch) {
        this.queueSize -= batch.size();
        this.checkLimitsOnDequeue(from);
    }

    private void checkLimitsOnEnqueue(BoltConnection connection) {
        Channel channel = connection.channel();
        if (this.queueSize > this.highWatermark && channel.config().isAutoRead()) {
            if (this.log != null) {
                this.log.warn("Channel [%s]: client produced %d messages on the worker queue, auto-read is being disabled.", new Object[]{channel.remoteAddress(), this.queueSize});
            }
            channel.config().setAutoRead(false);
        }
    }

    private void checkLimitsOnDequeue(BoltConnection connection) {
        Channel channel = connection.channel();
        if (this.queueSize <= this.lowWatermark && !channel.config().isAutoRead()) {
            if (this.log != null) {
                this.log.warn("Channel [%s]: consumed messages on the worker queue below %d, auto-read is being enabled.", new Object[]{channel.remoteAddress(), this.lowWatermark});
            }
            channel.config().setAutoRead(true);
        }
    }
}

