/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v4.runtime;

import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.ResultConsumer;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.runtime.statemachine.StatementMetadata;
import org.neo4j.bolt.transaction.TransactionNotFoundException;
import org.neo4j.bolt.v3.messaging.request.CommitMessage;
import org.neo4j.bolt.v3.messaging.request.RollbackMessage;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v4.runtime.AbstractStreamingState;
import org.neo4j.exceptions.KernelException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class InTransactionState
extends AbstractStreamingState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(InTransactionState.class);
    public static final String QUERY_ID_KEY = "qid";

    @Override
    protected BoltStateMachineState processUnsafe(RequestMessage message, StateMachineContext context) throws Throwable {
        context.connectionState().ensureNoPendingTerminationNotice();
        if (message instanceof RunMessage) {
            return this.processRunMessage((RunMessage)message, context);
        }
        if (message instanceof CommitMessage) {
            return this.processCommitMessage(context);
        }
        if (message instanceof RollbackMessage) {
            return this.processRollbackMessage(context);
        }
        return super.processUnsafe(message, context);
    }

    @Override
    public String name() {
        return "IN_TRANSACTION";
    }

    @Override
    protected BoltStateMachineState processStreamPullResultMessage(int statementId, ResultConsumer resultConsumer, StateMachineContext context, long noToPull) throws Throwable {
        context.getTransactionManager().pullData(context.connectionState().getCurrentTransactionId(), statementId, noToPull, resultConsumer);
        return this;
    }

    @Override
    protected BoltStateMachineState processStreamDiscardResultMessage(int statementId, ResultConsumer resultConsumer, StateMachineContext context, long noToDiscard) throws Throwable {
        context.getTransactionManager().discardData(context.connectionState().getCurrentTransactionId(), statementId, noToDiscard, resultConsumer);
        return this;
    }

    private BoltStateMachineState processRunMessage(RunMessage message, StateMachineContext context) throws KernelException, TransactionNotFoundException {
        context.connectionState().ensureNoPendingTerminationNotice();
        long start = context.clock().millis();
        StatementMetadata metadata = context.getTransactionManager().runQuery(context.connectionState().getCurrentTransactionId(), message.statement(), message.params());
        long end = context.clock().millis();
        context.connectionState().onMetadata("fields", (AnyValue)Values.stringArray((String[])metadata.fieldNames()));
        context.connectionState().onMetadata("t_first", (AnyValue)Values.longValue((long)(end - start)));
        context.connectionState().onMetadata(QUERY_ID_KEY, (AnyValue)Values.longValue((long)metadata.queryId()));
        return this;
    }

    protected BoltStateMachineState processCommitMessage(StateMachineContext context) throws KernelException, TransactionNotFoundException {
        Bookmark bookmark = context.getTransactionManager().commit(context.connectionState().getCurrentTransactionId());
        context.connectionState().clearCurrentTransactionId();
        bookmark.attachTo(context.connectionState());
        return this.readyState;
    }

    protected BoltStateMachineState processRollbackMessage(StateMachineContext context) throws KernelException, TransactionNotFoundException {
        context.getTransactionManager().rollback(context.connectionState().getCurrentTransactionId());
        context.connectionState().clearCurrentTransactionId();
        return this.readyState;
    }
}

