/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v44.runtime;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.BoltQueryExecutor;
import org.neo4j.bolt.runtime.BoltResult;
import org.neo4j.bolt.runtime.BoltResultHandle;
import org.neo4j.bolt.runtime.statemachine.StatementProcessorReleaseManager;
import org.neo4j.bolt.runtime.statemachine.impl.AbstractTransactionStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.impl.BoltAdapterSubscriber;
import org.neo4j.bolt.v4.runtime.TransactionStateMachineV4SPI;
import org.neo4j.bolt.v44.runtime.CypherAdapterStreamV44;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class TransactionStateMachineV44SPI
extends TransactionStateMachineV4SPI {
    public TransactionStateMachineV44SPI(BoltGraphDatabaseServiceSPI boltGraphDatabaseServiceSPI, BoltChannel boltChannel, SystemNanoClock clock, StatementProcessorReleaseManager resourceReleaseManager, String transactionId) {
        super(boltGraphDatabaseServiceSPI, boltChannel, clock, resourceReleaseManager, transactionId);
    }

    @Override
    protected BoltResultHandle newBoltResultHandle(String statement, MapValue params, BoltQueryExecutor boltQueryExecutor) {
        return new BoltResultHandleV44(statement, params, boltQueryExecutor);
    }

    private class BoltResultHandleV44
    extends AbstractTransactionStateMachineSPI.AbstractBoltResultHandle {
        BoltResultHandleV44(String statement, MapValue params, BoltQueryExecutor boltQueryExecutor) {
            super(TransactionStateMachineV44SPI.this, statement, params, boltQueryExecutor);
        }

        @Override
        protected BoltResult newBoltResult(QueryExecution result, BoltAdapterSubscriber subscriber, Clock clock) {
            return new CypherAdapterStreamV44(result, subscriber, clock, TransactionStateMachineV44SPI.this.databaseReference.alias().name());
        }
    }
}

