/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database.readonly;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.kernel.database.NamedDatabaseId;

public class ReadOnlyDatabases {
    private volatile Set<Lookup> readOnlyDatabases;
    private volatile long updateId;
    private final Set<LookupFactory> readOnlyDatabasesLookupFactories;

    public ReadOnlyDatabases(LookupFactory ... readOnlyDatabasesLookupFactories) {
        this.readOnlyDatabasesLookupFactories = Set.of(readOnlyDatabasesLookupFactories);
        this.readOnlyDatabases = Set.of();
        this.updateId = -1L;
    }

    public boolean isReadOnly(NamedDatabaseId namedDatabaseId) {
        Objects.requireNonNull(namedDatabaseId);
        if (namedDatabaseId.isSystemDatabase()) {
            return false;
        }
        return this.readOnlyDatabases.stream().anyMatch(l -> l.databaseIsReadOnly(namedDatabaseId));
    }

    long updateId() {
        return this.updateId;
    }

    public DatabaseReadOnlyChecker forDatabase(NamedDatabaseId namedDatabaseId) {
        Objects.requireNonNull(namedDatabaseId);
        if (namedDatabaseId.isSystemDatabase()) {
            return DatabaseReadOnlyChecker.writable();
        }
        this.refresh();
        return new DatabaseReadOnlyChecker.Default(this, namedDatabaseId);
    }

    public synchronized void refresh() {
        ++this.updateId;
        this.readOnlyDatabases = this.readOnlyDatabasesLookupFactories.stream().map(LookupFactory::lookupReadOnlyDatabases).collect(Collectors.toUnmodifiableSet());
    }

    @FunctionalInterface
    public static interface Lookup {
        public boolean databaseIsReadOnly(NamedDatabaseId var1);
    }

    @FunctionalInterface
    public static interface LookupFactory {
        public Lookup lookupReadOnlyDatabases();
    }
}

