/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;

public class ProceduresTimeFormatHelper {
    public static String formatTime(Instant instant, ZoneId zoneId) {
        return OffsetDateTime.ofInstant(instant, zoneId).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static String formatTime(long startTime, ZoneId zoneId) {
        return ProceduresTimeFormatHelper.formatTime(Instant.ofEpochMilli(startTime), zoneId);
    }

    public static String formatInterval(long l) {
        long hr = TimeUnit.MILLISECONDS.toHours(l);
        long min = TimeUnit.MILLISECONDS.toMinutes(l - TimeUnit.HOURS.toMillis(hr));
        long sec = TimeUnit.MILLISECONDS.toSeconds(l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min));
        long ms = l - TimeUnit.HOURS.toMillis(hr) - TimeUnit.MINUTES.toMillis(min) - TimeUnit.SECONDS.toMillis(sec);
        return String.format("%02d:%02d:%02d.%03d", hr, min, sec, ms);
    }
}

