/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.DataImporter;
import org.neo4j.internal.batchimport.staging.LonelyProcessingStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class DeleteDuplicateNodesStep
extends LonelyProcessingStep {
    private static final String DELETE_DUPLICATE_IMPORT_STEP_TAG = "deleteDuplicateImportStep";
    private final NodeStore nodeStore;
    private final PropertyStore propertyStore;
    private final LongIterator nodeIds;
    private final DataImporter.Monitor storeMonitor;
    private final PageCacheTracer pageCacheTracer;
    private final NeoStores neoStores;
    private long nodesRemoved;
    private long propertiesRemoved;

    public DeleteDuplicateNodesStep(StageControl control, Configuration config, LongIterator nodeIds, NeoStores neoStores, DataImporter.Monitor storeMonitor, PageCacheTracer pageCacheTracer) {
        super(control, "DEDUP", config, new StatsProvider[0]);
        this.neoStores = neoStores;
        this.nodeStore = neoStores.getNodeStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.nodeIds = nodeIds;
        this.storeMonitor = storeMonitor;
        this.pageCacheTracer = pageCacheTracer;
    }

    protected void process() {
        NodeRecord nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        PropertyRecord propertyRecord = this.propertyStore.newRecord();
        try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(DELETE_DUPLICATE_IMPORT_STEP_TAG));
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.neoStores, cursorContext);){
            while (this.nodeIds.hasNext()) {
                long duplicateNodeId = this.nodeIds.next();
                this.nodeStore.getRecordByCursor(duplicateNodeId, nodeRecord, RecordLoad.NORMAL, storeCursors.readCursor(RecordCursorTypes.NODE_CURSOR));
                assert (nodeRecord.inUse()) : nodeRecord;
                this.nodeStore.ensureHeavy(nodeRecord, (StoreCursors)storeCursors);
                long nextProp = nodeRecord.getNextProp();
                while (!Record.NULL_REFERENCE.is(nextProp)) {
                    this.propertyStore.getRecordByCursor(nextProp, propertyRecord, RecordLoad.NORMAL, storeCursors.readCursor(RecordCursorTypes.PROPERTY_CURSOR));
                    assert (propertyRecord.inUse()) : propertyRecord + " for " + nodeRecord;
                    this.propertyStore.ensureHeavy(propertyRecord, (StoreCursors)storeCursors);
                    this.propertiesRemoved += (long)propertyRecord.numberOfProperties();
                    nextProp = propertyRecord.getNextProp();
                    DeleteDuplicateNodesStep.deletePropertyRecordIncludingValueRecords(propertyRecord);
                    PageCursor propertyWriteCursor = storeCursors.writeCursor(RecordCursorTypes.PROPERTY_CURSOR);
                    try {
                        this.propertyStore.updateRecord(propertyRecord, propertyWriteCursor, cursorContext, (StoreCursors)storeCursors);
                    }
                    finally {
                        if (propertyWriteCursor == null) continue;
                        propertyWriteCursor.close();
                    }
                }
                nodeRecord.setInUse(false);
                for (DynamicRecord labelRecord : nodeRecord.getDynamicLabelRecords()) {
                    labelRecord.setInUse(false);
                }
                try (PageCursor nodeWriteCursor = storeCursors.writeCursor(RecordCursorTypes.NODE_CURSOR);){
                    this.nodeStore.updateRecord(nodeRecord, nodeWriteCursor, cursorContext, (StoreCursors)storeCursors);
                }
                ++this.nodesRemoved;
            }
        }
    }

    private static void deletePropertyRecordIncludingValueRecords(PropertyRecord record) {
        for (PropertyBlock block : record) {
            for (DynamicRecord valueRecord : block.getValueRecords()) {
                assert (valueRecord.inUse());
                valueRecord.setInUse(false);
                record.addDeletedRecord(valueRecord);
            }
        }
        record.clearPropertyBlocks();
        record.setInUse(false);
    }

    public void close() throws Exception {
        super.close();
        this.storeMonitor.nodesRemoved(this.nodesRemoved);
        this.storeMonitor.propertiesRemoved(this.propertiesRemoved);
    }
}

