/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.Arrays;
import java.util.Collections;
import org.neo4j.internal.batchimport.BatchingIdGetter;
import org.neo4j.internal.batchimport.DataImporter;
import org.neo4j.internal.batchimport.EntityImporter;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.input.Group;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.batchimport.store.BatchingTokenRepository;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.values.storable.Values;

public class NodeImporter
extends EntityImporter {
    private final BatchingTokenRepository.BatchingLabelTokenRepository labelTokenRepository;
    private final NodeStore nodeStore;
    private final NodeRecord nodeRecord;
    private final IdMapper idMapper;
    private final BatchingIdGetter nodeIds;
    private final PropertyStore idPropertyStore;
    private final PropertyRecord idPropertyRecord;
    private final PropertyBlock idPropertyBlock = new PropertyBlock();
    private final PageCursor nodeUpdateCursor;
    private final PageCursor idPropertyUpdateCursor;
    private String[] labels = new String[10];
    private int labelsCursor;
    private long nodeCount;
    private long highestId = -1L;
    private boolean hasLabelField;

    NodeImporter(BatchingNeoStores stores, IdMapper idMapper, DataImporter.Monitor monitor, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        super(stores, monitor, pageCacheTracer, memoryTracker);
        this.labelTokenRepository = stores.getLabelRepository();
        this.idMapper = idMapper;
        this.nodeStore = stores.getNodeStore();
        this.nodeRecord = (NodeRecord)this.nodeStore.newRecord();
        this.nodeIds = new BatchingIdGetter(this.nodeStore);
        this.idPropertyStore = stores.getTemporaryPropertyStore();
        this.idPropertyRecord = this.idPropertyStore.newRecord();
        this.nodeUpdateCursor = this.nodeStore.openPageCursorForWriting(0L, this.cursorContext);
        this.idPropertyUpdateCursor = this.idPropertyStore.openPageCursorForWriting(0L, this.cursorContext);
        this.nodeRecord.setInUse(true);
    }

    public boolean id(long id) {
        this.nodeRecord.setId(id);
        this.highestId = Long.max(this.highestId, id);
        return true;
    }

    public boolean id(Object id, Group group) {
        return this.id(id, group, this.nodeIds);
    }

    public boolean id(Object id, Group group, IdSequence idSequence) {
        long nodeId = idSequence.nextId(this.cursorContext);
        this.nodeRecord.setId(nodeId);
        this.highestId = Long.max(this.highestId, nodeId);
        this.idMapper.put(id, nodeId, group);
        if (id != null) {
            this.idPropertyStore.encodeValue(this.idPropertyBlock, 0, Values.of((Object)id), this.cursorContext, this.memoryTracker);
            this.idPropertyRecord.addPropertyBlock(this.idPropertyBlock);
            this.idPropertyRecord.setId(nodeId);
            this.idPropertyRecord.setInUse(true);
            this.idPropertyStore.updateRecord(this.idPropertyRecord, IdUpdateListener.IGNORE, this.idPropertyUpdateCursor, this.cursorContext, this.tempStoreCursors);
            this.idPropertyRecord.clear();
        }
        return true;
    }

    public boolean labels(String[] labels) {
        assert (!this.hasLabelField);
        int requiredLength = this.labelsCursor + labels.length;
        if (requiredLength > this.labels.length) {
            this.labels = Arrays.copyOf(this.labels, Integer.max(requiredLength, this.labels.length * 2));
        }
        System.arraycopy(labels, 0, this.labels, this.labelsCursor, labels.length);
        this.labelsCursor += labels.length;
        return true;
    }

    public boolean labelField(long labelField) {
        this.hasLabelField = true;
        this.nodeRecord.setLabelField(labelField, Collections.emptyList());
        return true;
    }

    @Override
    public void endOfEntity() {
        if (this.nodeRecord.getId() == Record.NULL_REFERENCE.longValue()) {
            this.nodeRecord.setId(this.nodeIds.nextId(this.cursorContext));
        }
        if (!this.hasLabelField) {
            long[] labelIds = this.labelTokenRepository.getOrCreateIds(this.labels, this.labelsCursor);
            InlineNodeLabels.putSorted(this.nodeRecord, labelIds, null, this.nodeStore.getDynamicLabelStore(), this.cursorContext, this.storeCursors, this.memoryTracker);
        }
        this.labelsCursor = 0;
        this.nodeRecord.setNextProp(this.createAndWritePropertyChain(this.cursorContext));
        this.nodeRecord.setInUse(true);
        this.nodeStore.updateRecord(this.nodeRecord, IdUpdateListener.IGNORE, this.nodeUpdateCursor, this.cursorContext, this.storeCursors);
        ++this.nodeCount;
        this.nodeRecord.clear();
        this.nodeRecord.setId(Record.NULL_REFERENCE.longValue());
        this.hasLabelField = false;
        super.endOfEntity();
    }

    @Override
    protected PrimitiveRecord primitiveRecord() {
        return this.nodeRecord;
    }

    @Override
    public void close() {
        super.close();
        this.monitor.nodesImported(this.nodeCount);
        this.nodeStore.setHighestPossibleIdInUse(this.highestId);
        this.nodeUpdateCursor.close();
        this.idPropertyUpdateCursor.close();
        this.cursorContext.close();
    }

    @Override
    void freeUnusedIds() {
        super.freeUnusedIds();
        NodeImporter.freeUnusedIds(this.nodeStore, this.nodeIds, this.cursorContext);
    }
}

