/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Objects;
import java.util.function.LongFunction;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.hashing.HashFunction;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.util.Preconditions;

public class LockVerificationMonitor
implements RecordAccess.LoadMonitor {
    private final ResourceLocker locks;
    private final ReadableTransactionState txState;
    private final StoreLoader loader;

    LockVerificationMonitor(ResourceLocker locks, ReadableTransactionState txState, StoreLoader loader) {
        this.locks = locks;
        this.txState = txState;
        this.loader = loader;
    }

    @Override
    public void markedAsChanged(AbstractBaseRecord before) {
        if (!before.inUse()) {
            return;
        }
        if (before instanceof NodeRecord) {
            this.verifyNodeSufficientlyLocked((NodeRecord)before);
        } else if (before instanceof RelationshipRecord) {
            this.verifyRelationshipSufficientlyLocked((RelationshipRecord)before);
        } else if (before instanceof RelationshipGroupRecord) {
            this.verifyRelationshipGroupSufficientlyLocked((RelationshipGroupRecord)before);
        } else if (before instanceof PropertyRecord) {
            this.verifyPropertySufficientlyLocked((PropertyRecord)before);
        } else if (before instanceof SchemaRecord) {
            this.verifySchemaSufficientlyLocked((SchemaRecord)before);
        }
    }

    private void verifySchemaSufficientlyLocked(SchemaRecord record) {
        LockVerificationMonitor.assertRecordsEquals(record, this.loader::loadSchemaRecord);
        LockVerificationMonitor.assertSchemaLocked(this.locks, this.loader.loadSchema(record.getId()), record);
    }

    private void verifyPropertySufficientlyLocked(PropertyRecord before) {
        LockVerificationMonitor.assertRecordsEquals(before, id -> {
            PropertyRecord stored = this.loader.loadProperty(id);
            stored.setEntity(before);
            return stored;
        });
        if (before.isNodeSet()) {
            if (!this.txState.nodeIsAddedInThisTx(before.getNodeId())) {
                this.assertLocked(before.getNodeId(), (ResourceType)ResourceTypes.NODE, before);
            }
        } else if (before.isRelSet()) {
            if (!this.txState.relationshipIsAddedInThisTx(before.getRelId())) {
                this.assertLocked(before.getRelId(), (ResourceType)ResourceTypes.RELATIONSHIP, before);
            }
        } else if (before.isSchemaSet()) {
            LockVerificationMonitor.assertSchemaLocked(this.locks, this.loader.loadSchema(before.getSchemaRuleId()), before);
        }
    }

    private void verifyNodeSufficientlyLocked(NodeRecord before) {
        LockVerificationMonitor.assertRecordsEquals(before, this.loader::loadNode);
        long id = before.getId();
        if (!this.txState.nodeIsAddedInThisTx(id)) {
            this.assertLocked(id, (ResourceType)ResourceTypes.NODE, before);
        }
        if (this.txState.nodeIsDeletedInThisTx(id)) {
            this.assertLocked(id, (ResourceType)ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, before);
        }
    }

    private void verifyRelationshipSufficientlyLocked(RelationshipRecord before) {
        LockVerificationMonitor.assertRecordsEquals(before, this.loader::loadRelationship);
        long id = before.getId();
        boolean addedInThisTx = this.txState.relationshipIsAddedInThisTx(id);
        Preconditions.checkState((before.inUse() == !addedInThisTx ? 1 : 0) != 0, (String)"Relationship[%d] inUse:%b, but txState.relationshipIsAddedInThisTx:%b", (Object[])new Object[]{id, before.inUse(), addedInThisTx});
        LockVerificationMonitor.checkRelationship(this.txState, this.locks, this.loader, before);
    }

    private void verifyRelationshipGroupSufficientlyLocked(RelationshipGroupRecord before) {
        LockVerificationMonitor.assertRecordsEquals(before, this.loader::loadRelationshipGroup);
        long node = before.getOwningNode();
        if (!this.txState.nodeIsAddedInThisTx(node)) {
            this.assertLocked(node, (ResourceType)ResourceTypes.RELATIONSHIP_GROUP, before);
        }
    }

    private void assertLocked(long id, ResourceType resource, AbstractBaseRecord record) {
        LockVerificationMonitor.assertLocked(this.locks, id, resource, LockType.EXCLUSIVE, record);
    }

    static void checkRelationship(ReadableTransactionState txState, ResourceLocker locks, StoreLoader loader, RelationshipRecord record) {
        long id = record.getId();
        if (!txState.relationshipIsAddedInThisTx(id) && !txState.relationshipIsDeletedInThisTx(id)) {
            LockVerificationMonitor.assertLocked(locks, id, (ResourceType)ResourceTypes.RELATIONSHIP, LockType.EXCLUSIVE, record);
        } else if (txState.relationshipIsDeletedInThisTx(id)) {
            LockVerificationMonitor.assertLocked(locks, id, (ResourceType)ResourceTypes.RELATIONSHIP, LockType.EXCLUSIVE, record);
        } else {
            LockVerificationMonitor.checkRelationshipNode(txState, locks, loader, record.getFirstNode());
            LockVerificationMonitor.checkRelationshipNode(txState, locks, loader, record.getSecondNode());
        }
    }

    private static void checkRelationshipNode(ReadableTransactionState txState, ResourceLocker locks, StoreLoader loader, long nodeId) {
        NodeRecord node;
        if (!txState.nodeIsAddedInThisTx(nodeId) && (node = loader.loadNode(nodeId)).inUse() && node.isDense()) {
            LockVerificationMonitor.assertLocked(locks, nodeId, (ResourceType)ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, LockType.SHARED, node);
            Preconditions.checkState((LockVerificationMonitor.hasLock(locks, nodeId, (ResourceType)ResourceTypes.NODE, LockType.EXCLUSIVE) || LockVerificationMonitor.hasLock(locks, nodeId, (ResourceType)ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, LockType.SHARED) ? 1 : 0) != 0, (String)"%s modified w/ neither [%s,%s] nor [%s,%s]", (Object[])new Object[]{locks, ResourceTypes.NODE, LockType.EXCLUSIVE, ResourceTypes.NODE_RELATIONSHIP_GROUP_DELETE, LockType.SHARED});
        }
    }

    static void assertLocked(ResourceLocker locks, long id, ResourceType resource, LockType type, AbstractBaseRecord record) {
        Preconditions.checkState((boolean)LockVerificationMonitor.hasLock(locks, id, resource, type), (String)"%s [%s,%s] modified without %s lock, record:%s.", (Object[])new Object[]{locks, resource, id, type, record});
    }

    static void assertSchemaLocked(ResourceLocker locks, SchemaRule schemaRule, AbstractBaseRecord record) {
        if (schemaRule instanceof IndexDescriptor && ((IndexDescriptor)schemaRule).isUnique()) {
            return;
        }
        Objects.requireNonNull(schemaRule);
        LockVerificationMonitor.assertLocked(locks, LockVerificationMonitor.schemaNameResourceId(schemaRule.getName()), (ResourceType)ResourceTypes.SCHEMA_NAME, LockType.EXCLUSIVE, record);
        SchemaDescriptor schema = schemaRule.schema();
        for (long key : schema.lockingKeys()) {
            LockVerificationMonitor.assertLocked(locks, key, schema.keyType(), LockType.EXCLUSIVE, record);
        }
    }

    private static boolean hasLock(ResourceLocker locks, long id, ResourceType resource, LockType type) {
        return locks.holdsLock(id, resource, type);
    }

    private static long schemaNameResourceId(String schemaName) {
        HashFunction hashFunc = HashFunction.incrementalXXH64();
        long hash = hashFunc.initialise(81985529216486895L);
        hash = schemaName.chars().asLongStream().reduce(hash, (arg_0, arg_1) -> ((HashFunction)hashFunc).update(arg_0, arg_1));
        return hashFunc.finalise(hash);
    }

    static <RECORD extends AbstractBaseRecord> void assertRecordsEquals(RECORD before, LongFunction<RECORD> loader) {
        AbstractBaseRecord stored = (AbstractBaseRecord)loader.apply(before.getId());
        if (before.inUse() || stored.inUse()) {
            Preconditions.checkState((boolean)stored.equals(before), (String)"Record which got marked as changed is not what the store has, i.e. it was read before lock was acquired%nbefore:%s%nstore:%s", (Object[])new Object[]{before, stored});
        }
    }

    public static class NeoStoresLoader
    implements StoreLoader {
        private final NeoStores neoStores;
        private final SchemaRuleAccess schemaRuleAccess;
        private final StoreCursors storeCursors;

        public NeoStoresLoader(NeoStores neoStores, SchemaRuleAccess schemaRuleAccess, StoreCursors storeCursors) {
            this.neoStores = neoStores;
            this.schemaRuleAccess = schemaRuleAccess;
            this.storeCursors = storeCursors;
        }

        @Override
        public NodeRecord loadNode(long id) {
            return NeoStoresLoader.readRecord(id, this.neoStores.getNodeStore(), this.storeCursors.readCursor((CursorType)RecordCursorTypes.NODE_CURSOR));
        }

        @Override
        public RelationshipRecord loadRelationship(long id) {
            return NeoStoresLoader.readRecord(id, this.neoStores.getRelationshipStore(), this.storeCursors.readCursor((CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR));
        }

        @Override
        public RelationshipGroupRecord loadRelationshipGroup(long id) {
            return NeoStoresLoader.readRecord(id, this.neoStores.getRelationshipGroupStore(), this.storeCursors.readCursor((CursorType)RecordCursorTypes.GROUP_CURSOR));
        }

        @Override
        public PropertyRecord loadProperty(long id) {
            PropertyStore propertyStore = this.neoStores.getPropertyStore();
            PropertyRecord record = NeoStoresLoader.readRecord(id, propertyStore, this.storeCursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR));
            propertyStore.ensureHeavy(record, this.storeCursors);
            return record;
        }

        @Override
        public SchemaRule loadSchema(long id) {
            try {
                return this.schemaRuleAccess.loadSingleSchemaRule(id, this.storeCursors);
            }
            catch (MalformedSchemaRuleException e) {
                return null;
            }
        }

        @Override
        public SchemaRecord loadSchemaRecord(long id) {
            return NeoStoresLoader.readRecord(id, this.neoStores.getSchemaStore(), this.storeCursors.readCursor((CursorType)RecordCursorTypes.SCHEMA_CURSOR));
        }

        private static <RECORD extends AbstractBaseRecord> RECORD readRecord(long id, RecordStore<RECORD> store, PageCursor pageCursor) {
            return store.getRecordByCursor(id, store.newRecord(), RecordLoad.ALWAYS, pageCursor);
        }
    }

    public static interface StoreLoader {
        public NodeRecord loadNode(long var1);

        public RelationshipRecord loadRelationship(long var1);

        public RelationshipGroupRecord loadRelationshipGroup(long var1);

        public PropertyRecord loadProperty(long var1);

        public SchemaRule loadSchema(long var1);

        public SchemaRecord loadSchemaRecord(long var1);
    }

    public static interface Factory {
        public static final Factory IGNORE = (locks, txState, neoStores, schemaRuleAccess, storeCursors) -> RecordAccess.LoadMonitor.NULL_MONITOR;

        public RecordAccess.LoadMonitor create(ResourceLocker var1, ReadableTransactionState var2, NeoStores var3, SchemaRuleAccess var4, StoreCursors var5);

        public static Factory defaultFactory(Config config) {
            boolean enabled = (Boolean)config.get(GraphDatabaseInternalSettings.additional_lock_verification);
            return enabled ? (locks, txState, neoStores, schemaRuleAccess, storeCursors) -> new LockVerificationMonitor(locks, txState, new NeoStoresLoader(neoStores, schemaRuleAccess, storeCursors)) : IGNORE;
        }
    }
}

