/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.SchemaIdType;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.UnexpectedStoreVersionException;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.format.CapabilityType;

public class NeoStores
implements AutoCloseable {
    private static final String ID_USAGE_LOGGER_TAG = "idUsageLogger";
    private static final String STORE_ALREADY_CLOSED_MESSAGE = "Specified store was already closed.";
    private static final String STORE_NOT_INITIALIZED_TEMPLATE = "Specified store was not initialized. Please specify %s as one of the stores types that should be open to be able to use it.";
    private static final String OPEN_ALL_STORES_TAG = "openAllStores";
    private static final StoreType[] STORE_TYPES = StoreType.values();
    private final FileSystemAbstraction fileSystem;
    private final RecordDatabaseLayout layout;
    private final Config config;
    private final IdGeneratorFactory idGeneratorFactory;
    private final PageCache pageCache;
    private final LogProvider logProvider;
    private final boolean createIfNotExist;
    private final StoreType[] initializedStores;
    private final RecordFormats recordFormats;
    private final CommonAbstractStore[] stores;
    private final PageCacheTracer pageCacheTracer;
    private final ImmutableSet<OpenOption> openOptions;
    private final DatabaseReadOnlyChecker readOnlyChecker;

    NeoStores(FileSystemAbstraction fileSystem, RecordDatabaseLayout layout, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, RecordFormats recordFormats, boolean createIfNotExist, PageCacheTracer pageCacheTracer, DatabaseReadOnlyChecker readOnlyChecker, StoreType[] storeTypes, ImmutableSet<OpenOption> openOptions) {
        this.fileSystem = fileSystem;
        this.layout = layout;
        this.config = config;
        this.idGeneratorFactory = idGeneratorFactory;
        this.pageCache = pageCache;
        this.logProvider = logProvider;
        this.recordFormats = recordFormats;
        this.createIfNotExist = createIfNotExist;
        this.pageCacheTracer = pageCacheTracer;
        this.readOnlyChecker = readOnlyChecker;
        this.openOptions = openOptions;
        this.stores = new CommonAbstractStore[StoreType.values().length];
        try (CursorContext cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer(OPEN_ALL_STORES_TAG));){
            try {
                this.verifyRecordFormat(storeTypes, cursorContext);
                for (StoreType type : storeTypes) {
                    this.getOrOpenStore(type, cursorContext);
                }
            }
            catch (RuntimeException initException) {
                try {
                    this.close();
                }
                catch (RuntimeException closeException) {
                    initException.addSuppressed(closeException);
                }
                throw initException;
            }
        }
        this.initializedStores = storeTypes;
    }

    @Override
    public void close() {
        RuntimeException ex = null;
        for (StoreType type : STORE_TYPES) {
            try {
                this.closeStore(type);
            }
            catch (RuntimeException t) {
                ex = (RuntimeException)Exceptions.chain(ex, (Throwable)t);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private void verifyRecordFormat(StoreType[] storeTypes, CursorContext cursorContext) {
        String actualStoreVersion;
        RecordFormats actualStoreFormat;
        long existingFormat;
        String expectedStoreVersion = this.recordFormats.storeVersion();
        if (!this.fileSystem.fileExists(this.layout.metadataStore())) {
            return;
        }
        if (ArrayUtils.contains((Object[])storeTypes, (Object)((Object)StoreType.META_DATA))) {
            MetaDataStore metaDataStore = (MetaDataStore)this.getOrOpenStore(StoreType.META_DATA, cursorContext);
            try (PageCursor cursor = metaDataStore.openPageCursorForReading(MetaDataStore.Position.STORE_VERSION.id(), cursorContext);){
                existingFormat = metaDataStore.getRecordByCursor(MetaDataStore.Position.STORE_VERSION.id(), metaDataStore.newRecord(), RecordLoad.CHECK, cursor).getValue();
            }
        }
        try {
            existingFormat = MetaDataStore.getRecord(this.pageCache, this.layout.metadataStore(), MetaDataStore.Position.STORE_VERSION, this.layout.getDatabaseName(), cursorContext);
        }
        catch (NoSuchFileException e) {
            return;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
        if (existingFormat != -1L && !this.isCompatibleFormats(actualStoreFormat = RecordFormatSelector.selectForVersion(actualStoreVersion = MetaDataStore.versionLongToString(existingFormat)))) {
            throw new UnexpectedStoreVersionException(actualStoreVersion, expectedStoreVersion);
        }
    }

    private boolean isCompatibleFormats(RecordFormats storeFormat) {
        return this.recordFormats.hasCompatibleCapabilities(storeFormat, CapabilityType.FORMAT) && this.recordFormats.generation() >= storeFormat.generation();
    }

    private void closeStore(StoreType type) {
        int i = type.ordinal();
        if (this.stores[i] != null) {
            try {
                this.stores[i].close();
            }
            finally {
                this.stores[i] = null;
            }
        }
    }

    public void flush(CursorContext cursorContext) throws IOException {
        this.pageCache.flushAndForce();
        this.visitStores(store -> store.getIdGenerator().checkpoint(cursorContext));
    }

    private CommonAbstractStore openStore(StoreType type, CursorContext cursorContext) {
        CommonAbstractStore store;
        int storeIndex = type.ordinal();
        this.stores[storeIndex] = store = type.open(this, cursorContext);
        return store;
    }

    private <T extends CommonAbstractStore> T initialize(T store, CursorContext cursorContext) {
        store.initialise(this.createIfNotExist, cursorContext);
        return store;
    }

    private CommonAbstractStore getStore(StoreType storeType) {
        CommonAbstractStore store = this.stores[storeType.ordinal()];
        if (store == null) {
            String message = ArrayUtils.contains((Object[])this.initializedStores, (Object)((Object)storeType)) ? STORE_ALREADY_CLOSED_MESSAGE : String.format(STORE_NOT_INITIALIZED_TEMPLATE, storeType.name());
            throw new IllegalStateException(message);
        }
        return store;
    }

    private CommonAbstractStore getOrOpenStore(StoreType storeType, CursorContext cursorContext) {
        CommonAbstractStore store = this.stores[storeType.ordinal()];
        if (store == null) {
            store = this.openStore(storeType, cursorContext);
        }
        return store;
    }

    public MetaDataStore getMetaDataStore() {
        return (MetaDataStore)this.getStore(StoreType.META_DATA);
    }

    public NodeStore getNodeStore() {
        return (NodeStore)this.getStore(StoreType.NODE);
    }

    public RelationshipStore getRelationshipStore() {
        return (RelationshipStore)this.getStore(StoreType.RELATIONSHIP);
    }

    public RelationshipTypeTokenStore getRelationshipTypeTokenStore() {
        return (RelationshipTypeTokenStore)this.getStore(StoreType.RELATIONSHIP_TYPE_TOKEN);
    }

    public LabelTokenStore getLabelTokenStore() {
        return (LabelTokenStore)this.getStore(StoreType.LABEL_TOKEN);
    }

    public PropertyStore getPropertyStore() {
        return (PropertyStore)this.getStore(StoreType.PROPERTY);
    }

    public PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return (PropertyKeyTokenStore)this.getStore(StoreType.PROPERTY_KEY_TOKEN);
    }

    public RelationshipGroupStore getRelationshipGroupStore() {
        return (RelationshipGroupStore)this.getStore(StoreType.RELATIONSHIP_GROUP);
    }

    public SchemaStore getSchemaStore() {
        return (SchemaStore)this.getStore(StoreType.SCHEMA);
    }

    public void start(CursorContext cursorContext) throws IOException {
        this.start(store -> {}, cursorContext);
    }

    public void start(Consumer<CommonAbstractStore<?, ?>> listener, CursorContext cursorContext) throws IOException {
        this.visitStores(store -> {
            store.start(cursorContext);
            listener.accept((CommonAbstractStore<?, ?>)store);
        });
    }

    public void verifyStoreOk() {
        this.visitStores(CommonAbstractStore::checkStoreOk);
    }

    public void logVersions(DiagnosticsLogger msgLog) {
        this.visitStores(store -> store.logVersions(msgLog));
    }

    public void logIdUsage(DiagnosticsLogger msgLog) {
        try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(ID_USAGE_LOGGER_TAG));){
            this.visitStores(store -> store.logIdUsage(msgLog, cursorContext));
        }
    }

    private <E extends Exception> void visitStores(ThrowingConsumer<CommonAbstractStore, E> visitor) throws E {
        for (CommonAbstractStore store : this.stores) {
            if (store == null) continue;
            visitor.accept((Object)store);
        }
    }

    CommonAbstractStore createNodeStore(CursorContext cursorContext) {
        return this.initialize(new NodeStore(this.layout.nodeStore(), this.layout.idNodeStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicArrayStore)this.getOrOpenStore(StoreType.NODE_LABEL, cursorContext), this.recordFormats, this.readOnlyChecker, this.layout.getDatabaseName(), this.openOptions), cursorContext);
    }

    CommonAbstractStore createNodeLabelStore(CursorContext cursorContext) {
        return this.createDynamicArrayStore(this.layout.nodeLabelStore(), this.layout.idNodeLabelStore(), RecordIdType.NODE_LABELS, (Setting<Integer>)GraphDatabaseInternalSettings.label_block_size, cursorContext);
    }

    CommonAbstractStore createPropertyKeyTokenStore(CursorContext cursorContext) {
        return this.initialize(new PropertyKeyTokenStore(this.layout.propertyKeyTokenStore(), this.layout.idPropertyKeyTokenStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicStringStore)this.getOrOpenStore(StoreType.PROPERTY_KEY_TOKEN_NAME, cursorContext), this.recordFormats, this.readOnlyChecker, this.layout.getDatabaseName(), this.openOptions), cursorContext);
    }

    CommonAbstractStore createPropertyKeyTokenNamesStore(CursorContext cursorContext) {
        return this.createDynamicStringStore(this.layout.propertyKeyTokenNamesStore(), this.layout.idPropertyKeyTokenNamesStore(), RecordIdType.PROPERTY_KEY_TOKEN_NAME, 30, cursorContext);
    }

    CommonAbstractStore createPropertyStore(CursorContext cursorContext) {
        return this.initialize(new PropertyStore(this.layout.propertyStore(), this.layout.idPropertyStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicStringStore)this.getOrOpenStore(StoreType.PROPERTY_STRING, cursorContext), (PropertyKeyTokenStore)this.getOrOpenStore(StoreType.PROPERTY_KEY_TOKEN, cursorContext), (DynamicArrayStore)this.getOrOpenStore(StoreType.PROPERTY_ARRAY, cursorContext), this.recordFormats, this.readOnlyChecker, this.layout.getDatabaseName(), this.openOptions), cursorContext);
    }

    CommonAbstractStore createPropertyStringStore(CursorContext cursorContext) {
        return this.createDynamicStringStore(this.layout.propertyStringStore(), this.layout.idPropertyStringStore(), cursorContext);
    }

    CommonAbstractStore createPropertyArrayStore(CursorContext cursorContext) {
        return this.createDynamicArrayStore(this.layout.propertyArrayStore(), this.layout.idPropertyArrayStore(), RecordIdType.ARRAY_BLOCK, (Setting<Integer>)GraphDatabaseInternalSettings.array_block_size, cursorContext);
    }

    CommonAbstractStore createRelationshipStore(CursorContext cursorContext) {
        return this.initialize(new RelationshipStore(this.layout.relationshipStore(), this.layout.idRelationshipStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, this.recordFormats, this.readOnlyChecker, this.layout.getDatabaseName(), this.openOptions), cursorContext);
    }

    CommonAbstractStore createRelationshipTypeTokenStore(CursorContext cursorContext) {
        return this.initialize(new RelationshipTypeTokenStore(this.layout.relationshipTypeTokenStore(), this.layout.idRelationshipTypeTokenStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicStringStore)this.getOrOpenStore(StoreType.RELATIONSHIP_TYPE_TOKEN_NAME, cursorContext), this.recordFormats, this.readOnlyChecker, this.layout.getDatabaseName(), this.openOptions), cursorContext);
    }

    CommonAbstractStore createRelationshipTypeTokenNamesStore(CursorContext cursorContext) {
        return this.createDynamicStringStore(this.layout.relationshipTypeTokenNamesStore(), this.layout.idRelationshipTypeTokenNamesStore(), RecordIdType.RELATIONSHIP_TYPE_TOKEN_NAME, 30, cursorContext);
    }

    CommonAbstractStore createLabelTokenStore(CursorContext cursorContext) {
        return this.initialize(new LabelTokenStore(this.layout.labelTokenStore(), this.layout.idLabelTokenStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, (DynamicStringStore)this.getOrOpenStore(StoreType.LABEL_TOKEN_NAME, cursorContext), this.recordFormats, this.readOnlyChecker, this.layout.getDatabaseName(), this.openOptions), cursorContext);
    }

    CommonAbstractStore createSchemaStore(CursorContext cursorContext) {
        return this.initialize(new SchemaStore(this.layout.schemaStore(), this.layout.idSchemaStore(), this.config, (IdType)SchemaIdType.SCHEMA, this.idGeneratorFactory, this.pageCache, this.logProvider, (PropertyStore)this.getOrOpenStore(StoreType.PROPERTY, cursorContext), this.recordFormats, this.readOnlyChecker, this.layout.getDatabaseName(), this.openOptions), cursorContext);
    }

    CommonAbstractStore createRelationshipGroupStore(CursorContext cursorContext) {
        return this.initialize(new RelationshipGroupStore(this.layout.relationshipGroupStore(), this.layout.idRelationshipGroupStore(), this.config, this.idGeneratorFactory, this.pageCache, this.logProvider, this.recordFormats, this.readOnlyChecker, this.layout.getDatabaseName(), this.openOptions), cursorContext);
    }

    CommonAbstractStore createLabelTokenNamesStore(CursorContext cursorContext) {
        return this.createDynamicStringStore(this.layout.labelTokenNamesStore(), this.layout.idLabelTokenNamesStore(), RecordIdType.LABEL_TOKEN_NAME, 30, cursorContext);
    }

    CommonAbstractStore createMetadataStore(CursorContext cursorContext) {
        return this.initialize(new MetaDataStore(this.layout.metadataStore(), this.config, this.pageCache, this.logProvider, this.recordFormats.metaData((Integer)this.config.get(GraphDatabaseInternalSettings.reserved_page_header_bytes)), this.recordFormats.storeVersion(), this.pageCacheTracer, this.readOnlyChecker, this.layout.getDatabaseName(), this.openOptions), cursorContext);
    }

    private CommonAbstractStore createDynamicStringStore(Path storeFile, Path idFile, CursorContext cursorContext) {
        return this.createDynamicStringStore(storeFile, idFile, RecordIdType.STRING_BLOCK, (Integer)this.config.get(GraphDatabaseInternalSettings.string_block_size), cursorContext);
    }

    private CommonAbstractStore createDynamicStringStore(Path storeFile, Path idFile, RecordIdType idType, int blockSize, CursorContext cursorContext) {
        return this.initialize(new DynamicStringStore(storeFile, idFile, this.config, idType, this.idGeneratorFactory, this.pageCache, this.logProvider, blockSize, this.recordFormats.dynamic(), this.recordFormats.storeVersion(), this.readOnlyChecker, this.layout.getDatabaseName(), this.openOptions), cursorContext);
    }

    private CommonAbstractStore createDynamicArrayStore(Path storeFile, Path idFile, RecordIdType idType, Setting<Integer> blockSizeProperty, CursorContext cursorContext) {
        return this.createDynamicArrayStore(storeFile, idFile, idType, (Integer)this.config.get(blockSizeProperty), cursorContext);
    }

    CommonAbstractStore createDynamicArrayStore(Path storeFile, Path idFile, RecordIdType idType, int blockSize, CursorContext cursorContext) {
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Block size of dynamic array store should be positive integer.");
        }
        return this.initialize(new DynamicArrayStore(storeFile, idFile, this.config, idType, this.idGeneratorFactory, this.pageCache, this.logProvider, blockSize, this.recordFormats, this.readOnlyChecker, this.layout.getDatabaseName(), this.openOptions), cursorContext);
    }

    public <RECORD extends AbstractBaseRecord> RecordStore<RECORD> getRecordStore(StoreType type) {
        return this.getStore(type);
    }

    public RecordFormats getRecordFormats() {
        return this.recordFormats;
    }

    public static boolean isStorePresent(FileSystemAbstraction fs, RecordDatabaseLayout databaseLayout) {
        return fs.fileExists(databaseLayout.metadataStore());
    }
}

