/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.impl.store.format.RecordFormats;

public final class RecordFormatPropertyConfigurator {
    private RecordFormatPropertyConfigurator() {
    }

    private static void configureIntegerSetting(Config config, Setting<Integer> setting, int fullBlockSize, int headerSize) {
        int updatedBlockSize;
        int defaultValue = (Integer)setting.defaultValue();
        int propertyValue = (Integer)config.get(setting);
        if (propertyValue == defaultValue && (updatedBlockSize = fullBlockSize - headerSize) != propertyValue) {
            if (updatedBlockSize < 16) {
                throw new IllegalArgumentException("Block size should be bigger then 16");
            }
            config.set(setting, (Object)updatedBlockSize);
        }
    }

    public static void configureRecordFormat(RecordFormats recordFormats, Config config) {
        int headerSize = recordFormats.dynamic().getRecordHeaderSize();
        RecordFormatPropertyConfigurator.configureIntegerSetting(config, (Setting<Integer>)GraphDatabaseInternalSettings.string_block_size, 128, headerSize);
        RecordFormatPropertyConfigurator.configureIntegerSetting(config, (Setting<Integer>)GraphDatabaseInternalSettings.array_block_size, 128, headerSize);
        RecordFormatPropertyConfigurator.configureIntegerSetting(config, (Setting<Integer>)GraphDatabaseInternalSettings.label_block_size, 64, headerSize);
    }
}

