/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacy;

import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaStore35;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursorsAdapter;

public class SchemaStore35StoreCursors
extends StoreCursorsAdapter {
    private final SchemaStore35 schemaStore35;
    private final CursorContext cursorContext;
    private PageCursor schemaCursor;

    public SchemaStore35StoreCursors(SchemaStore35 schemaStore35, CursorContext cursorContext) {
        this.schemaStore35 = schemaStore35;
        this.cursorContext = cursorContext;
    }

    public PageCursor readCursor(CursorType type) {
        if (RecordCursorTypes.SCHEMA_CURSOR == type) {
            if (this.schemaCursor == null) {
                this.schemaCursor = this.schemaStore35.openPageCursorForReading(0L, this.cursorContext);
            }
            return this.schemaCursor;
        }
        return super.readCursor(type);
    }

    public PageCursor writeCursor(CursorType type) {
        if (RecordCursorTypes.SCHEMA_CURSOR == type) {
            return this.schemaStore35.openPageCursorForWriting(0L, this.cursorContext);
        }
        return super.writeCursor(type);
    }

    public void close() {
        if (this.schemaCursor != null) {
            this.schemaCursor.close();
            this.schemaCursor = null;
        }
        super.close();
    }
}

