/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.internal;

import java.util.function.ToLongFunction;
import org.neo4j.graphdb.Entity;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.impl.coreapi.internal.CursorEntityFactory;
import org.neo4j.kernel.impl.coreapi.internal.PrefetchingEntityResourceIterator;

public class CursorIterator<CURSOR extends Cursor, E extends Entity>
extends PrefetchingEntityResourceIterator<CURSOR, E> {
    private final CURSOR cursor;
    private final ToLongFunction<CURSOR> toReferenceFunction;
    private final ResourceTracker resourceTracker;

    public CursorIterator(CURSOR cursor, ToLongFunction<CURSOR> toReferenceFunction, CursorEntityFactory<CURSOR, E> entityFactory, ResourceTracker resourceTracker) {
        super(cursor, entityFactory);
        this.cursor = cursor;
        this.toReferenceFunction = toReferenceFunction;
        this.resourceTracker = resourceTracker;
        resourceTracker.registerCloseableResource((AutoCloseable)((Object)this));
    }

    @Override
    long fetchNext() {
        if (this.cursor.next()) {
            return this.toReferenceFunction.applyAsLong(this.cursor);
        }
        return -1L;
    }

    @Override
    void closeResources() {
        this.resourceTracker.unregisterCloseableResource((AutoCloseable)((Object)this));
        IOUtils.closeAllSilently((AutoCloseable[])new Cursor[]{this.cursor});
    }
}

