/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexFiles;

class IndexMonitorAdaptor
extends GBPTree.Monitor.Delegate {
    private final IndexProvider.Monitor indexMonitor;
    private final IndexFiles indexFiles;
    private final IndexDescriptor descriptor;

    IndexMonitorAdaptor(GBPTree.Monitor treeMonitor, IndexProvider.Monitor indexMonitor, IndexFiles indexFiles, IndexDescriptor descriptor) {
        super(treeMonitor);
        this.indexMonitor = indexMonitor;
        this.indexFiles = indexFiles;
        this.descriptor = descriptor;
    }

    public void cleanupRegistered() {
        this.indexMonitor.recoveryCleanupRegistered(this.indexFiles.getStoreFile(), this.descriptor);
        super.cleanupRegistered();
    }

    public void cleanupStarted() {
        this.indexMonitor.recoveryCleanupStarted(this.indexFiles.getStoreFile(), this.descriptor);
        super.cleanupStarted();
    }

    public void cleanupFinished(long numberOfPagesVisited, long numberOfTreeNodes, long numberOfCleanedCrashPointers, long durationMillis) {
        this.indexMonitor.recoveryCleanupFinished(this.indexFiles.getStoreFile(), this.descriptor, numberOfPagesVisited, numberOfTreeNodes, numberOfCleanedCrashPointers, durationMillis);
        super.cleanupFinished(numberOfPagesVisited, numberOfTreeNodes, numberOfCleanedCrashPointers, durationMillis);
    }

    public void cleanupClosed() {
        this.indexMonitor.recoveryCleanupClosed(this.indexFiles.getStoreFile(), this.descriptor);
        super.cleanupClosed();
    }

    public void cleanupFailed(Throwable throwable) {
        this.indexMonitor.recoveryCleanupFailed(this.indexFiles.getStoreFile(), this.descriptor, throwable);
        super.cleanupFailed(throwable);
    }
}

