/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;

abstract class TokenScanValueIndexAccessor {
    protected final Seeker<TokenScanKey, TokenScanValue> cursor;
    long baseEntityId;
    protected long bits;
    private int prevToken = -1;
    private long prevRange = -1L;
    protected boolean closed;

    TokenScanValueIndexAccessor(Seeker<TokenScanKey, TokenScanValue> cursor) {
        this.cursor = cursor;
    }

    boolean keysInOrder(TokenScanKey key, IndexOrder order) {
        if (order == IndexOrder.NONE) {
            return true;
        }
        if (this.prevToken != -1 && this.prevRange != -1L && order == IndexOrder.ASCENDING) {
            assert (key.tokenId >= this.prevToken) : "Expected to get ascending ordered results, got " + key + " where previous token was " + this.prevToken;
            assert (key.idRange > this.prevRange) : "Expected to get ascending ordered results, got " + key + " where previous range was " + this.prevRange;
        } else if (this.prevToken != -1 && this.prevRange != -1L && order == IndexOrder.DESCENDING) {
            assert (key.tokenId <= this.prevToken) : "Expected to get descending ordered results, got " + key + " where previous token was " + this.prevToken;
            assert (key.idRange < this.prevRange) : "Expected to get descending ordered results, got " + key + " where previous range was " + this.prevRange;
        }
        this.prevToken = key.tokenId;
        this.prevRange = key.idRange;
        return true;
    }

    public void close() {
        if (!this.closed) {
            try {
                this.cursor.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.closed = true;
            }
        }
    }
}

