/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Objects;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.SecurityContext;

public abstract class LoginContext {
    protected final AuthSubject subject;
    private final ClientConnectionInfo connectionInfo;
    public static final LoginContext AUTH_DISABLED = LoginContext.fullAccess(ClientConnectionInfo.EMBEDDED_CONNECTION);

    public LoginContext(AuthSubject subject, ClientConnectionInfo connectionInfo) {
        this.subject = subject;
        this.connectionInfo = connectionInfo;
    }

    public AuthSubject subject() {
        return this.subject;
    }

    public ClientConnectionInfo connectionInfo() {
        return this.connectionInfo;
    }

    public boolean impersonating() {
        return !Objects.equals(this.subject.executingUser(), this.subject.authenticatedUser());
    }

    public abstract SecurityContext authorize(IdLookup var1, String var2, AbstractSecurityLog var3);

    public static LoginContext fullAccess(ClientConnectionInfo connectionInfo) {
        return new LoginContext(AuthSubject.AUTH_DISABLED, connectionInfo){

            @Override
            public SecurityContext authorize(IdLookup idLookup, String dbName, AbstractSecurityLog securityLog) {
                return SecurityContext.authDisabled(AccessMode.Static.FULL, this.connectionInfo(), dbName);
            }
        };
    }

    public static interface IdLookup {
        public static final int[] NO_SUCH_PROCEDURE = new int[0];
        public static final IdLookup EMPTY = new IdLookup(){

            @Override
            public int getPropertyKeyId(String name) {
                return -1;
            }

            @Override
            public int getLabelId(String name) {
                return -1;
            }

            @Override
            public int getRelTypeId(String name) {
                return -1;
            }

            @Override
            public int[] getProcedureIds(String procedureGlobbing) {
                return NO_SUCH_PROCEDURE;
            }

            @Override
            public int[] getAdminProcedureIds() {
                return NO_SUCH_PROCEDURE;
            }

            @Override
            public int[] getFunctionIds(String functionGlobbing) {
                return NO_SUCH_PROCEDURE;
            }

            @Override
            public int[] getAggregatingFunctionIds(String functionGlobbing) {
                return NO_SUCH_PROCEDURE;
            }
        };

        public int getPropertyKeyId(String var1);

        public int getLabelId(String var1);

        public int getRelTypeId(String var1);

        public int[] getProcedureIds(String var1);

        public int[] getAdminProcedureIds();

        public int[] getFunctionIds(String var1);

        public int[] getAggregatingFunctionIds(String var1);
    }
}

