## Usage

```js
const has = require('{%= name %}');
```

Create an `isEmpty` function by returning the inverse of the result from has-values:

```js
const isEmpty = val => !has(val);
```

## Supported types

### Arrays

```js
console.log(has(['a']));      //=> true
console.log(has([0]));        //=> true
console.log(has([[[]]]));     //=> false
console.log(has([[], []]));   //=> false
console.log(has([]));         //=> false
```

### Booleans

```js
console.log(has(true));  //=> true
console.log(has(false)); //=> true
```

### Buffers

```js
console.log(has(new Buffer()));      //=> false
console.log(has(new Buffer('foo'))); //=> true
```

### Dates

Dates are always true. 

```js
console.log(has(new Date())); //=> true
```

### Errors

Returns `false` if `err.message` is an empty string.

```js
console.log(has(new Error()));      //=> false
console.log(has(new Error('foo'))); //=> true
```

### Functions

Functions are always true. 

```js
console.log(has(function(foo) {})); //=> true
console.log(has(function() {}));    //=> true
```

### Maps

```js
console.log(has(new Map()));                 //=> false
console.log(has(new Map([['foo', 'bar']]))); //=> true
```

### Null

`null` is always true, as it's assumed that this is a user-defined value, versus `undefined` which is not.

```js
console.log(has(null)); //=> true
```

### Objects

```js
console.log(has({})); //=> false
console.log(has({ a: 'a' }}));        //=> true
console.log(has({ foo: undefined })); //=> false
console.log(has({ foo: null }));      //=> true
```

### Numbers

```js
console.log(has(1)); //=> true
console.log(has(0)); //=> true
```

### Regular expressions

```js
console.log(has(new RegExp()));      //=> false
console.log(has(new RegExp('foo'))); //=> true
```

### Sets

```js
console.log(has(new Set()));               //=> false
console.log(has(new Set(['foo', 'bar']))); //=> true
```

### Strings

```js
console.log(has('a')); //=> true
console.log(has(''));  //=> false
```

## Undefined

```js
console.log(has());          //=> false
console.log(has(void 0));    //=> false
console.log(has(undefined)); //=> false
```


## Release history

### v2.0.0

- no longer supports numbers as a string
- optimizations
- adds support for `regex` and `buffer`

### v1.0.0

- adds support for `Map` and `Set`
- `zero` always returns true
- `array` now recurses, so that an array of empty arrays will return `false`
- `null` now returns true
