# A sample Makefile for building Google Test and using it in user
# tests.  Please tweak it to suit your environment and project.  You
# may want to move it to your project's root directory.
#
# SYNOPSIS:
#
#   make [all]  - makes everything.
#   make TARGET - makes the given target.
#   make clean  - removes all files generated by make.

# Please tweak the following variable definitions as needed by your
# project, except GTEST_HEADERS, which you can use in your own targets
# but shouldn't modify.

# Points to the root of Google Test, relative to where this file is.
# Remember to tweak this if you move this file.
GTEST_DIR = ./googletest/

# Where to find user code.
USER_DIR = ./googletest/samples/

# Flags passed to the preprocessor.
# Set Google Test's header directory as a system directory, such that
# the compiler doesn't generate warnings in Google Test headers.
CPPFLAGS += -isystem $(GTEST_DIR)/include

# Flags passed to the C++ compiler.
#CXXFLAGS += -std=c++11 -O2 -pthread -lz -lm -mpopcnt
CXXFLAGS += -std=c++11 -g -Wall -pthread -lz -lm -mpopcnt

# All tests produced by this Makefile.  Remember to add new tests you
# created to the list.
TESTS = test_akt

# All Google Test headers.  Usually you shouldn't change this
# definition.
GTEST_HEADERS = $(GTEST_DIR)/include/gtest/*.h \
                $(GTEST_DIR)/include/gtest/internal/*.h

# House-keeping build targets.

all : $(TESTS)

clean :
	rm -f $(TESTS) gtest.a gtest_main.a *.o

# Builds gtest.a and gtest_main.a.

# Usually you shouldn't tweak such internal variables, indicated by a
# trailing _.
GTEST_SRCS_ = $(GTEST_DIR)/src/*.cc $(GTEST_DIR)/src/*.h $(GTEST_HEADERS)

# For simplicity and to avoid depending on Google Test's
# implementation details, the dependencies specified below are
# conservative and not optimized.  This is fine as Google Test
# compiles fast and for ordinary users its source rarely changes.
gtest-all.o : $(GTEST_SRCS_)
	$(CXX) $(CPPFLAGS) -I$(GTEST_DIR) $(CXXFLAGS) -c \
            $(GTEST_DIR)/src/gtest-all.cc

gtest_main.o : $(GTEST_SRCS_)
	$(CXX) $(CPPFLAGS) -I$(GTEST_DIR) $(CXXFLAGS) -c \
            $(GTEST_DIR)/src/gtest_main.cc

gtest.a : gtest-all.o
	$(AR) $(ARFLAGS) $@ $^

gtest_main.a : gtest-all.o gtest_main.o
	$(AR) $(ARFLAGS) $@ $^


## akt build stuff starts here


IFLAGS =   -I./

OBJS=matepair.o fastqlib.o utilityfunc.o
.cpp.o:
	$(CXX) $(CXXFLAGS) $(IFLAGS) -c -o $@ $<
.c.o:
	$(CC) $(CXXFLAGS) -c -o $@ $<

matepair.o: matepair.cpp matepair.h fastqlib.h
fastqlib.o: fastqlib.cpp fastqlib.h utilityfunc.h
utilityfunc.o:  utilityfunc.cpp utilityfunc.h
nxtrim: nxtrim.cpp $(OBJS) version.h
	$(CXX) $(CXXFLAGS) nxtrim.cpp $(OBJS)  $(LFLAGS) -o $@

test_nxtrim : test_nxtrim.cpp gtest_main.a $(OBJS)
	$(CXX) $(IFLAGS)  $^ -o $@  $(CPPFLAGS) $(CXXFLAGS)
