/*
 * Copyright (c) 2018, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * @test
 * @bug 8199421
 * @summary Test vectorization of popcount
 * @run main/othervm -XX:+IgnoreUnrecognizedVMOptions -XX:+UsePopCountInstruction
 *      compiler.vectorization.TestPopCountVector
 * @run main/othervm -XX:+IgnoreUnrecognizedVMOptions -XX:+UsePopCountInstruction
 *      -XX:MaxVectorSize=8 compiler.vectorization.TestPopCountVector
 */

package compiler.vectorization;

public class TestPopCountVector {
    private int[] input;
    private int[] output;
    private static final int LEN = 1024;

    public static void main(String args[]) {
        TestPopCountVector test = new TestPopCountVector();
        int err = 0;

        for (int i = 0; i < 10_000; ++i) {
          test.vectorizeBitCount();
        }
        System.out.println("Checking popcount result");
        err += test.checkResult();

        for (int i = 0; i < 10_000; ++i) {
          test.vectorizeBitCount();
        }
        System.out.println("Checking popcount result");
        err += test.checkResult();
        if (err > 0) {
            throw new RuntimeException("Error!");
        }
    }

    public TestPopCountVector() {
        input = new int[LEN];
        output = new int[LEN];
        for (int i = 0; i < LEN; ++i) {
            input[i] = i % 2 == 0 ? i : -1 * i;
        }
    }

    public void vectorizeBitCount() {
        for (int i = 0; i < LEN; ++i) {
            output[i] = Integer.bitCount(input[i]);
        }
    }

    public int checkResult() {
        int err = 0;
        for (int i = 0; i < LEN; ++i) {
            int expected = Integer.bitCount(input[i]);
            if (output[i] != expected) {
                err++;
                System.err.println("Invalid result: output[" + i + "] = " + output[i] + " != " + expected +
                                   ", input[" + i + "] == " + Integer.toBinaryString(input[i]));
            }
        }
        return err;
    }
}

