// Vorbis decoder written in Rust
//
// Copyright (c) 2016 est31 <MTest31@outlook.com>
// and contributors. All rights reserved.
// Licensed under MIT license, or Apache 2 license,
// at your option. Please see the LICENSE file
// attached to this source distribution for details.

#![allow(dead_code)]

pub static IMDCT_INPUT_TEST_ARR_1 :[f32; 128] =
[-0.01894, -0.10670,  0.51740,  0.39750,
  0.03894,  0.00692,  0.00000,  0.00369,
  0.00092, -0.00143, -0.00056,  0.00087,
  0.00067, -0.00063, -0.00056,  0.00052,
  0.00046, -0.00043, -0.00041,  0.00036,
  0.00034, -0.00030, -0.00028,  0.00025,
  0.00025, -0.00012, -0.00022,  0.00010,
  0.00019, -0.00010, -0.00018,  0.00008,
  0.00016, -0.00007, -0.00015,  0.00007,
  0.00013, -0.00006, -0.00012,  0.00006,
  0.00011, -0.00005, -0.00010,  0.00005,
  0.00009, -0.00004, -0.00008,  0.00004,
  0.00008,  0.00000, -0.00007,  0.00000,
  0.00007,  0.00000, -0.00007,  0.00000,
  0.00007,  0.00000, -0.00007,  0.00000,
  0.00007,  0.00000, -0.00006,  0.00000,
  0.00006,  0.00000, -0.00006,  0.00000,
  0.00006,  0.00000, -0.00005,  0.00000,
  0.00005,  0.00000, -0.00003,  0.00000,
  0.00003,  0.00000, -0.00003,  0.00000,
  0.00003,  0.00000, -0.00003,  0.00000,
  0.00003,  0.00000, -0.00003,  0.00000,
  0.00004,  0.00000, -0.00004,  0.00000,
  0.00005,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000];

pub static IMDCT_OUTPUT_TEST_ARR_1 :[f32; 256] =
[ 0.03325,  0.07520,  0.11729,  0.15753,
  0.19588,  0.23308,  0.26823,  0.30140,
  0.33234,  0.36078,  0.38742,  0.41169,
  0.43321,  0.45243,  0.46889,  0.48269,
  0.49426,  0.50325,  0.50983,  0.51412,
  0.51613,  0.51621,  0.51417,  0.51004,
  0.50417,  0.49634,  0.48682,  0.47595,
  0.46349,  0.44974,  0.43492,  0.41903,
  0.40238,  0.38495,  0.36682,  0.34831,
  0.32932,  0.31015,  0.29104,  0.27183,
  0.25285,  0.23427,  0.21602,  0.19839,
  0.18134,  0.16489,  0.14925,  0.13434,
  0.12030,  0.10721,  0.09486,  0.08348,
  0.07306,  0.06339,  0.05463,  0.04662,
  0.03925,  0.03264,  0.02655,  0.02098,
  0.01586,  0.01098,  0.00648,  0.00219,
 -0.00219, -0.00648, -0.01098, -0.01586,
 -0.02098, -0.02655, -0.03264, -0.03925,
 -0.04662, -0.05463, -0.06339, -0.07306,
 -0.08348, -0.09486, -0.10721, -0.12030,
 -0.13434, -0.14925, -0.16489, -0.18134,
 -0.19839, -0.21602, -0.23427, -0.25285,
 -0.27183, -0.29104, -0.31015, -0.32932,
 -0.34831, -0.36682, -0.38495, -0.40238,
 -0.41903, -0.43492, -0.44974, -0.46349,
 -0.47595, -0.48682, -0.49634, -0.50417,
 -0.51004, -0.51417, -0.51621, -0.51613,
 -0.51412, -0.50983, -0.50325, -0.49426,
 -0.48269, -0.46889, -0.45243, -0.43321,
 -0.41169, -0.38742, -0.36078, -0.33234,
 -0.30140, -0.26823, -0.23308, -0.19588,
 -0.15753, -0.11729, -0.07520, -0.03325,
  0.01147,  0.06175,  0.11352,  0.16419,
  0.21479,  0.26472,  0.31382,  0.36215,
  0.40885,  0.45420,  0.49798,  0.53953,
  0.57931,  0.61680,  0.65136,  0.68325,
  0.71206,  0.73749,  0.75955,  0.77780,
  0.79226,  0.80284,  0.80927,  0.81177,
  0.80999,  0.80374,  0.79336,  0.77856,
  0.75936,  0.73598,  0.70826,  0.67643,
  0.64070,  0.60110,  0.55796,  0.51130,
  0.46132,  0.40853,  0.35296,  0.29496,
  0.23502,  0.17323,  0.11014,  0.04621,
 -0.01834, -0.08299, -0.14746, -0.21136,
 -0.27409, -0.33545, -0.39494, -0.45208,
 -0.50668, -0.55817, -0.60612, -0.65041,
 -0.69058, -0.72643, -0.75773, -0.78409,
 -0.80548, -0.82165, -0.83246, -0.83802,
 -0.83802, -0.83246, -0.82165, -0.80548,
 -0.78409, -0.75773, -0.72643, -0.69058,
 -0.65041, -0.60612, -0.55817, -0.50668,
 -0.45208, -0.39494, -0.33545, -0.27409,
 -0.21136, -0.14746, -0.08299, -0.01834,
  0.04621,  0.11014,  0.17323,  0.23502,
  0.29496,  0.35296,  0.40853,  0.46132,
  0.51130,  0.55796,  0.60110,  0.64070,
  0.67643,  0.70826,  0.73598,  0.75936,
  0.77856,  0.79336,  0.80374,  0.80999,
  0.81177,  0.80927,  0.80284,  0.79226,
  0.77780,  0.75955,  0.73749,  0.71206,
  0.68325,  0.65136,  0.61680,  0.57931,
  0.53953,  0.49798,  0.45420,  0.40885,
  0.36215,  0.31382,  0.26472,  0.21479,
  0.16419,  0.11352,  0.06175,  0.01147];

pub static IMDCT_INPUT_TEST_ARR_2 :[f32; 128] =
[ 0.07109,  0.29427,  0.58470, -0.36304,
  0.05009, -0.01145,  0.00184,  0.00063,
 -0.00020, -0.00018,  0.00015,  0.00013,
 -0.00011, -0.00009,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000];

pub static IMDCT_OUTPUT_TEST_ARR_2 :[f32; 256] =
[-0.78862, -0.79274, -0.79359, -0.79110,
 -0.78522, -0.77592, -0.76317, -0.74696,
 -0.72731, -0.70422, -0.67775, -0.64795,
 -0.61489, -0.57868, -0.53943, -0.49729,
 -0.45242, -0.40500, -0.35524, -0.30338,
 -0.24966, -0.19435, -0.13774, -0.08012,
 -0.02181,  0.03686,  0.09556,  0.15395,
  0.21166,  0.26837,  0.32370,  0.37732,
  0.42887,  0.47801,  0.52442,  0.56776,
  0.60774,  0.64406,  0.67645,  0.70467,
  0.72849,  0.74771,  0.76217,  0.77173,
  0.77628,  0.77576,  0.77013,  0.75940,
  0.74361,  0.72283,  0.69717,  0.66679,
  0.63188,  0.59264,  0.54935,  0.50227,
  0.45173,  0.39806,  0.34162,  0.28282,
  0.22204,  0.15972,  0.09628,  0.03217,
 -0.03217, -0.09628, -0.15972, -0.22204,
 -0.28282, -0.34162, -0.39806, -0.45173,
 -0.50227, -0.54935, -0.59264, -0.63188,
 -0.66679, -0.69717, -0.72283, -0.74361,
 -0.75940, -0.77013, -0.77576, -0.77628,
 -0.77173, -0.76217, -0.74771, -0.72849,
 -0.70467, -0.67645, -0.64406, -0.60774,
 -0.56776, -0.52442, -0.47801, -0.42887,
 -0.37732, -0.32370, -0.26837, -0.21166,
 -0.15395, -0.09556, -0.03686,  0.02181,
  0.08012,  0.13774,  0.19435,  0.24966,
  0.30338,  0.35524,  0.40500,  0.45242,
  0.49729,  0.53943,  0.57868,  0.61489,
  0.64795,  0.67775,  0.70422,  0.72731,
  0.74696,  0.76317,  0.77592,  0.78522,
  0.79110,  0.79359,  0.79274,  0.78862,
  0.78129,  0.77084,  0.75738,  0.74100,
  0.72184,  0.70003,  0.67572,  0.64906,
  0.62022,  0.58938,  0.55672,  0.52243,
  0.48671,  0.44973,  0.41171,  0.37283,
  0.33328,  0.29325,  0.25290,  0.21241,
  0.17195,  0.13166,  0.09170,  0.05219,
  0.01327, -0.02493, -0.06232, -0.09878,
 -0.13422, -0.16855, -0.20169, -0.23358,
 -0.26416, -0.29339, -0.32122, -0.34763,
 -0.37261, -0.39615, -0.41827, -0.43897,
 -0.45828, -0.47624, -0.49288, -0.50825,
 -0.52239, -0.53536, -0.54722, -0.55801,
 -0.56779, -0.57662, -0.58455, -0.59163,
 -0.59793, -0.60348, -0.60833, -0.61255,
 -0.61616, -0.61922, -0.62176, -0.62383,
 -0.62543, -0.62662, -0.62740, -0.62778,
 -0.62778, -0.62740, -0.62662, -0.62543,
 -0.62383, -0.62176, -0.61922, -0.61616,
 -0.61255, -0.60833, -0.60348, -0.59793,
 -0.59163, -0.58455, -0.57662, -0.56779,
 -0.55801, -0.54722, -0.53536, -0.52239,
 -0.50825, -0.49288, -0.47624, -0.45828,
 -0.43897, -0.41827, -0.39615, -0.37261,
 -0.34763, -0.32122, -0.29339, -0.26416,
 -0.23358, -0.20169, -0.16855, -0.13422,
 -0.09878, -0.06232, -0.02493,  0.01327,
  0.05219,  0.09170,  0.13166,  0.17195,
  0.21241,  0.25290,  0.29325,  0.33328,
  0.37283,  0.41171,  0.44973,  0.48671,
  0.52243,  0.55672,  0.58938,  0.62022,
  0.64906,  0.67572,  0.70003,  0.72184,
  0.74100,  0.75738,  0.77084,  0.78129];

pub static IMDCT_INPUT_TEST_ARR_3 :[f32; 1024] =
[-0.00325,  0.00916, -0.01147,  0.00942,
 -0.00442,  0.00059,  0.00000,  0.00430,
 -0.01291,  0.02373, -0.03052,  0.03141,
 -0.02273,  0.00975,  0.00000,  0.00836,
 -0.04179,  0.11284, -0.20060,  0.25075,
 -0.21732,  0.10448,  0.00000, -0.05433,
  0.05886, -0.03806,  0.01525,  0.00000,
 -0.00474,  0.00209,  0.00184, -0.00488,
  0.00573, -0.00379,  0.00111,  0.00209,
 -0.00277,  0.00325, -0.00215,  0.00126,
  0.00000,  0.00000, -0.00043,  0.00153,
 -0.00202,  0.00208, -0.00157,  0.00079,
 -0.00026,  0.00000,  0.00000,  0.00023,
 -0.00046,  0.00065, -0.00043,  0.00020,
  0.00020, -0.00038,  0.00057, -0.00036,
  0.00018,  0.00000,  0.00000,  0.00000,
  0.00016, -0.00032,  0.00030, -0.00030,
  0.00014,  0.00014, -0.00013,  0.00013,
  0.00000,  0.00000,  0.00012, -0.00012,
  0.00000,  0.00011, -0.00022,  0.00020,
 -0.00010,  0.00000,  0.00010, -0.00009,
  0.00000,  0.00000, -0.00008,  0.00008,
 -0.00008,  0.00000,  0.00007, -0.00014,
  0.00007, -0.00007,  0.00000,  0.00007,
  0.00000,  0.00000,  0.00006, -0.00012,
  0.00006, -0.00006,  0.00000,  0.00005,
 -0.00005,  0.00005,  0.00000, -0.00005,
  0.00005,  0.00000, -0.00005,  0.00005,
 -0.00009,  0.00004,  0.00000, -0.00004,
  0.00004, -0.00004,  0.00000,  0.00004,
 -0.00004,  0.00004,  0.00000, -0.00004,
  0.00007, -0.00003,  0.00003,  0.00000,
 -0.00003,  0.00003,  0.00000, -0.00003,
  0.00003, -0.00003,  0.00003,  0.00000,
 -0.00003,  0.00003, -0.00003,  0.00000,
  0.00003, -0.00003,  0.00000,  0.00000,
 -0.00002,  0.00005, -0.00002,  0.00000,
  0.00002, -0.00002,  0.00002,  0.00000,
 -0.00002,  0.00002, -0.00002,  0.00000,
  0.00002, -0.00004,  0.00004, -0.00002,
  0.00000,  0.00002, -0.00002,  0.00000,
  0.00002, -0.00002,  0.00002, -0.00002,
  0.00000,  0.00001, -0.00003,  0.00001,
  0.00000, -0.00001,  0.00001, -0.00001,
  0.00000,  0.00001, -0.00002,  0.00001,
  0.00000, -0.00001,  0.00001, -0.00001,
  0.00000,  0.00001, -0.00001,  0.00001,
  0.00000, -0.00001,  0.00002, -0.00002,
  0.00001,  0.00000, -0.00001,  0.00001,
 -0.00001,  0.00000,  0.00001, -0.00001,
  0.00001,  0.00000, -0.00001,  0.00002,
 -0.00001,  0.00000,  0.00001, -0.00001,
  0.00001,  0.00000, -0.00001,  0.00002,
 -0.00001,  0.00000,  0.00001, -0.00001,
  0.00001,  0.00000,  0.00000,  0.00001,
 -0.00001,  0.00000,  0.00001, -0.00001,
  0.00002, -0.00001,  0.00000,  0.00001,
 -0.00001,  0.00001,  0.00000, -0.00001,
  0.00001, -0.00001,  0.00000,  0.00001,
 -0.00001,  0.00001,  0.00000, -0.00001,
  0.00001, -0.00001,  0.00000,  0.00001,
 -0.00001,  0.00001,  0.00000, -0.00001,
  0.00001, -0.00001,  0.00000,  0.00000,
 -0.00001,  0.00001,  0.00000, -0.00001,
  0.00001, -0.00001,  0.00001,  0.00000,
 -0.00001,  0.00001, -0.00001,  0.00000,
  0.00001, -0.00001,  0.00001,  0.00000,
 -0.00001,  0.00001, -0.00001,  0.00000,
  0.00001, -0.00001,  0.00001,  0.00000,
 -0.00001,  0.00001, -0.00001,  0.00000,
  0.00001, -0.00001,  0.00001,  0.00000,
  0.00000,  0.00001, -0.00001,  0.00000,
  0.00000, -0.00001,  0.00001, -0.00001,
  0.00000,  0.00001, -0.00001,  0.00001,
  0.00000, -0.00001,  0.00001, -0.00001,
  0.00000,  0.00001, -0.00001,  0.00001,
  0.00000,  0.00000,  0.00001, -0.00001,
  0.00000,  0.00001, -0.00001,  0.00001,
  0.00000, -0.00001,  0.00001, -0.00001,
  0.00000,  0.00000, -0.00001,  0.00001,
  0.00000,  0.00000,  0.00001, -0.00001,
  0.00001,  0.00000, -0.00001,  0.00001,
 -0.00001,  0.00000,  0.00001, -0.00001,
  0.00001,  0.00000, -0.00001,  0.00001,
 -0.00001,  0.00000,  0.00000, -0.00001,
  0.00001,  0.00000, -0.00001,  0.00001,
 -0.00001,  0.00000,  0.00001, -0.00001,
  0.00001,  0.00000,  0.00000,  0.00001,
 -0.00001,  0.00000,  0.00000, -0.00001,
  0.00001, -0.00000,  0.00000,  0.00000,
 -0.00000,  0.00000,  0.00000, -0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
 -0.00000,  0.00000,  0.00000,  0.00000,
  0.00000, -0.00000,  0.00000,  0.00000,
 -0.00000,  0.00000,  0.00000,  0.00000,
  0.00000, -0.00000,  0.00000,  0.00000,
 -0.00000,  0.00000,  0.00000,  0.00000,
  0.00000, -0.00000,  0.00000,  0.00000,
 -0.00000,  0.00000, -0.00000,  0.00000,
  0.00000, -0.00000,  0.00000,  0.00000,
 -0.00000,  0.00000, -0.00000,  0.00000,
  0.00000, -0.00000,  0.00000,  0.00000,
  0.00000,  0.00000, -0.00000,  0.00000,
  0.00000, -0.00000,  0.00000,  0.00000,
  0.00000,  0.00000, -0.00000,  0.00000,
  0.00000, -0.00000,  0.00000,  0.00000,
  0.00000,  0.00000, -0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000, -0.00000,  0.00000,
  0.00000,  0.00000,  0.00000, -0.00000,
  0.00000,  0.00000, -0.00000,  0.00000,
  0.00000,  0.00000,  0.00000, -0.00000,
  0.00000,  0.00000, -0.00000,  0.00000,
  0.00000,  0.00000,  0.00000, -0.00000,
  0.00000,  0.00000, -0.00000,  0.00000,
  0.00000,  0.00000,  0.00000, -0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000, -0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000, -0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
 -0.00000,  0.00000,  0.00000, -0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
 -0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
 -0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000, -0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000, -0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000,
  0.00000,  0.00000,  0.00000,  0.00000];

pub static IMDCT_OUTPUT_TEST_ARR_3 :[f32; 2048] =
[ 0.00454,  0.00669,  0.00892,  0.01121,
  0.01351,  0.01581,  0.01811,  0.02041,
  0.02267,  0.02487,  0.02702,  0.02908,
  0.03102,  0.03282,  0.03452,  0.03617,
  0.03774,  0.03921,  0.04058,  0.04183,
  0.04296,  0.04392,  0.04472,  0.04535,
  0.04582,  0.04612,  0.04624,  0.04619,
  0.04598,  0.04560,  0.04503,  0.04427,
  0.04332,  0.04220,  0.04090,  0.03945,
  0.03782,  0.03599,  0.03400,  0.03185,
  0.02955,  0.02709,  0.02447,  0.02172,
  0.01883,  0.01580,  0.01262,  0.00933,
  0.00593,  0.00242, -0.00120, -0.00491,
 -0.00870, -0.01258, -0.01650, -0.02046,
 -0.02445, -0.02847, -0.03246, -0.03641,
 -0.04032, -0.04420, -0.04798, -0.05160,
 -0.05506, -0.05837, -0.06151, -0.06445,
 -0.06721, -0.06980, -0.07217, -0.07432,
 -0.07628, -0.07803, -0.07947, -0.08055,
 -0.08134, -0.08185, -0.08203, -0.08187,
 -0.08141, -0.08063, -0.07948, -0.07797,
 -0.07616, -0.07403, -0.07150, -0.06857,
 -0.06532, -0.06174, -0.05777, -0.05342,
 -0.04875, -0.04380, -0.03852, -0.03292,
 -0.02705, -0.02093, -0.01456, -0.00799,
 -0.00126,  0.00564,  0.01270,  0.01986,
  0.02705,  0.03427,  0.04154,  0.04878,
  0.05595,  0.06301,  0.06997,  0.07678,
  0.08341,  0.08986,  0.09613,  0.10215,
  0.10790,  0.11335,  0.11850,  0.12329,
  0.12768,  0.13165,  0.13521,  0.13831,
  0.14092,  0.14300,  0.14456,  0.14557,
  0.14601,  0.14585,  0.14512,  0.14380,
  0.14184,  0.13919,  0.13590,  0.13201,
  0.12753,  0.12241,  0.11665,  0.11028,
  0.10334,  0.09586,  0.08786,  0.07935,
  0.07030,  0.06069,  0.05056,  0.03998,
  0.02900,  0.01763,  0.00587, -0.00621,
 -0.01856, -0.03113, -0.04387, -0.05675,
 -0.06972, -0.08274, -0.09573, -0.10864,
 -0.12143, -0.13403, -0.14638, -0.15842,
 -0.17010, -0.18136, -0.19213, -0.20237,
 -0.21201, -0.22098, -0.22922, -0.23671,
 -0.24342, -0.24927, -0.25419, -0.25819,
 -0.26122, -0.26319, -0.26408, -0.26389,
 -0.26263, -0.26023, -0.25666, -0.25195,
 -0.24610, -0.23908, -0.23088, -0.22152,
 -0.21101, -0.19934, -0.18655, -0.17271,
 -0.15782, -0.14189, -0.12498, -0.10722,
 -0.08867, -0.06931, -0.04915, -0.02828,
 -0.00678,  0.01522,  0.03764,  0.06037,
  0.08332,  0.10640,  0.12956,  0.15278,
  0.17592,  0.19880,  0.22131,  0.24344,
  0.26512,  0.28620,  0.30652,  0.32606,
  0.34475,  0.36246,  0.37904,  0.39443,
  0.40859,  0.42139,  0.43269,  0.44243,
  0.45058,  0.45704,  0.46171,  0.46456,
  0.46555,  0.46464,  0.46175,  0.45689,
  0.45002,  0.44112,  0.43016,  0.41715,
  0.40211,  0.38504,  0.36597,  0.34494,
  0.32197,  0.29714,  0.27052,  0.24215,
  0.21211,  0.18049,  0.14736,  0.11283,
  0.07703,  0.04012,  0.00221, -0.03663,
 -0.07619, -0.11623, -0.15668, -0.19747,
 -0.23835, -0.27906, -0.31956, -0.35988,
 -0.39967, -0.43840, -0.47617, -0.51362,
 -0.55083, -0.58678, -0.62029, -0.65106,
 -0.67937, -0.70523, -0.72830, -0.74839,
 -0.76555, -0.77976, -0.79086, -0.79878,
 -0.80358, -0.80526, -0.80376, -0.79907,
 -0.79124, -0.78031, -0.76627, -0.74919,
 -0.72918, -0.70631, -0.68065, -0.65230,
 -0.62140, -0.58808, -0.55245, -0.51464,
 -0.47484, -0.43321, -0.38990, -0.34508,
 -0.29891, -0.25161, -0.20336, -0.15431,
 -0.10469, -0.05472, -0.00459,  0.04555,
  0.09552,  0.14508,  0.19401,  0.24218,
  0.28943,  0.33551,  0.38019,  0.42336,
  0.46488,  0.50457,  0.54222,  0.57769,
  0.61091,  0.64174,  0.67006,  0.69575,
  0.71872,  0.73889,  0.75619,  0.77058,
  0.78200,  0.79037,  0.79562,  0.79770,
  0.79662,  0.79238,  0.78505,  0.77463,
  0.76119,  0.74477,  0.72543,  0.70323,
  0.67824,  0.65061,  0.62046,  0.58787,
  0.55293,  0.51582,  0.47673,  0.43580,
  0.39314,  0.34891,  0.30334,  0.25659,
  0.20882,  0.16024,  0.11106,  0.06146,
  0.01160, -0.03830, -0.08801, -0.13736,
 -0.18618, -0.23428, -0.28147, -0.32756,
 -0.37239, -0.41576, -0.45752, -0.49750,
 -0.53555, -0.57148, -0.60517, -0.63654,
 -0.66545, -0.69174, -0.71533, -0.73615,
 -0.75411, -0.76911, -0.78108, -0.79000,
 -0.79583, -0.79849, -0.79799, -0.79436,
 -0.78766, -0.77792, -0.76515, -0.74939,
 -0.73069, -0.70911, -0.68473, -0.65765,
 -0.62797, -0.59582, -0.56134, -0.52467,
 -0.48594, -0.44529, -0.40288, -0.35886,
 -0.31341, -0.26671, -0.21892, -0.17027,
 -0.12095, -0.07118, -0.02110,  0.02908,
  0.07913,  0.12885,  0.17807,  0.22659,
  0.27422,  0.32078,  0.36610,  0.41003,
  0.45236,  0.49295,  0.53165,  0.56828,
  0.60270,  0.63479,  0.66442,  0.69145,
  0.71576,  0.73727,  0.75592,  0.77161,
  0.78424,  0.79381,  0.80029,  0.80362,
  0.80376,  0.80075,  0.79461,  0.78533,
  0.77293,  0.75749,  0.73909,  0.71773,
  0.69351,  0.66657,  0.63701,  0.60492,
  0.57044,  0.53374,  0.49490,  0.45404,
  0.41137,  0.36712,  0.32143,  0.27442,
  0.22640,  0.17775,  0.12871,  0.07942,
  0.03003, -0.01923, -0.06821, -0.11679,
 -0.16482, -0.21214, -0.25863, -0.30421,
 -0.34876, -0.39211, -0.43416, -0.47488,
 -0.51414, -0.55183, -0.58788, -0.62226,
 -0.65487, -0.68559, -0.71439, -0.74126,
 -0.76612, -0.78888, -0.80949, -0.82795,
 -0.84420, -0.85817, -0.86982, -0.87913,
 -0.88607, -0.89062, -0.89276, -0.89248,
 -0.88975, -0.88456, -0.87692, -0.86685,
 -0.85432, -0.83934, -0.82193, -0.80214,
 -0.78002, -0.75561, -0.72896, -0.70016,
 -0.66925, -0.63629, -0.60139, -0.56467,
 -0.52620, -0.48608, -0.44443, -0.40142,
 -0.35720, -0.31183, -0.26544, -0.21822,
 -0.17036, -0.12204, -0.07337, -0.02448,
  0.02448,  0.07337,  0.12204,  0.17036,
  0.21822,  0.26544,  0.31183,  0.35720,
  0.40142,  0.44443,  0.48608,  0.52620,
  0.56467,  0.60139,  0.63629,  0.66925,
  0.70016,  0.72896,  0.75561,  0.78002,
  0.80214,  0.82193,  0.83934,  0.85432,
  0.86685,  0.87692,  0.88456,  0.88975,
  0.89248,  0.89276,  0.89062,  0.88607,
  0.87913,  0.86982,  0.85817,  0.84420,
  0.82795,  0.80949,  0.78888,  0.76612,
  0.74126,  0.71439,  0.68559,  0.65487,
  0.62226,  0.58788,  0.55183,  0.51414,
  0.47488,  0.43416,  0.39211,  0.34876,
  0.30421,  0.25863,  0.21214,  0.16482,
  0.11679,  0.06821,  0.01923, -0.03003,
 -0.07942, -0.12871, -0.17775, -0.22640,
 -0.27442, -0.32143, -0.36712, -0.41137,
 -0.45404, -0.49490, -0.53374, -0.57044,
 -0.60492, -0.63701, -0.66657, -0.69351,
 -0.71773, -0.73909, -0.75749, -0.77293,
 -0.78533, -0.79461, -0.80075, -0.80376,
 -0.80362, -0.80029, -0.79381, -0.78424,
 -0.77161, -0.75592, -0.73727, -0.71576,
 -0.69145, -0.66442, -0.63479, -0.60270,
 -0.56828, -0.53165, -0.49295, -0.45236,
 -0.41003, -0.36610, -0.32078, -0.27422,
 -0.22659, -0.17807, -0.12885, -0.07913,
 -0.02908,  0.02110,  0.07118,  0.12095,
  0.17027,  0.21892,  0.26671,  0.31341,
  0.35886,  0.40288,  0.44529,  0.48594,
  0.52467,  0.56134,  0.59582,  0.62797,
  0.65765,  0.68473,  0.70911,  0.73069,
  0.74939,  0.76515,  0.77792,  0.78766,
  0.79436,  0.79799,  0.79849,  0.79583,
  0.79000,  0.78108,  0.76911,  0.75411,
  0.73615,  0.71533,  0.69174,  0.66545,
  0.63654,  0.60517,  0.57148,  0.53555,
  0.49750,  0.45752,  0.41576,  0.37239,
  0.32756,  0.28147,  0.23428,  0.18618,
  0.13736,  0.08801,  0.03830, -0.01160,
 -0.06146, -0.11106, -0.16024, -0.20882,
 -0.25659, -0.30334, -0.34891, -0.39314,
 -0.43580, -0.47673, -0.51582, -0.55293,
 -0.58787, -0.62046, -0.65061, -0.67824,
 -0.70323, -0.72543, -0.74477, -0.76119,
 -0.77463, -0.78505, -0.79238, -0.79662,
 -0.79770, -0.79562, -0.79037, -0.78200,
 -0.77058, -0.75619, -0.73889, -0.71872,
 -0.69575, -0.67006, -0.64174, -0.61091,
 -0.57769, -0.54222, -0.50457, -0.46488,
 -0.42336, -0.38019, -0.33551, -0.28943,
 -0.24218, -0.19401, -0.14508, -0.09552,
 -0.04555,  0.00459,  0.05472,  0.10469,
  0.15431,  0.20336,  0.25161,  0.29891,
  0.34508,  0.38990,  0.43321,  0.47484,
  0.51464,  0.55245,  0.58808,  0.62140,
  0.65230,  0.68065,  0.70631,  0.72918,
  0.74919,  0.76627,  0.78031,  0.79124,
  0.79907,  0.80376,  0.80526,  0.80358,
  0.79878,  0.79086,  0.77976,  0.76555,
  0.74839,  0.72830,  0.70523,  0.67937,
  0.65106,  0.62029,  0.58678,  0.55083,
  0.51362,  0.47617,  0.43840,  0.39967,
  0.35988,  0.31956,  0.27906,  0.23835,
  0.19747,  0.15668,  0.11623,  0.07619,
  0.03663, -0.00221, -0.04012, -0.07703,
 -0.11283, -0.14736, -0.18049, -0.21211,
 -0.24215, -0.27052, -0.29714, -0.32197,
 -0.34494, -0.36597, -0.38504, -0.40211,
 -0.41715, -0.43016, -0.44112, -0.45002,
 -0.45689, -0.46175, -0.46464, -0.46555,
 -0.46456, -0.46171, -0.45704, -0.45058,
 -0.44243, -0.43269, -0.42139, -0.40859,
 -0.39443, -0.37904, -0.36246, -0.34475,
 -0.32606, -0.30652, -0.28620, -0.26512,
 -0.24344, -0.22131, -0.19880, -0.17592,
 -0.15278, -0.12956, -0.10640, -0.08332,
 -0.06037, -0.03764, -0.01522,  0.00678,
  0.02828,  0.04915,  0.06931,  0.08867,
  0.10722,  0.12498,  0.14189,  0.15782,
  0.17271,  0.18655,  0.19934,  0.21101,
  0.22152,  0.23088,  0.23908,  0.24610,
  0.25195,  0.25666,  0.26023,  0.26263,
  0.26389,  0.26408,  0.26319,  0.26122,
  0.25819,  0.25419,  0.24927,  0.24342,
  0.23671,  0.22922,  0.22098,  0.21201,
  0.20237,  0.19213,  0.18136,  0.17010,
  0.15842,  0.14638,  0.13403,  0.12143,
  0.10864,  0.09573,  0.08274,  0.06972,
  0.05675,  0.04387,  0.03113,  0.01856,
  0.00621, -0.00587, -0.01763, -0.02900,
 -0.03998, -0.05056, -0.06069, -0.07030,
 -0.07935, -0.08786, -0.09586, -0.10334,
 -0.11028, -0.11665, -0.12241, -0.12753,
 -0.13201, -0.13590, -0.13919, -0.14184,
 -0.14380, -0.14512, -0.14585, -0.14601,
 -0.14557, -0.14456, -0.14300, -0.14092,
 -0.13831, -0.13521, -0.13165, -0.12768,
 -0.12329, -0.11850, -0.11335, -0.10790,
 -0.10215, -0.09613, -0.08986, -0.08341,
 -0.07678, -0.06997, -0.06301, -0.05595,
 -0.04878, -0.04154, -0.03427, -0.02705,
 -0.01986, -0.01270, -0.00564,  0.00126,
  0.00799,  0.01456,  0.02093,  0.02705,
  0.03292,  0.03852,  0.04380,  0.04875,
  0.05342,  0.05777,  0.06174,  0.06532,
  0.06857,  0.07150,  0.07403,  0.07616,
  0.07797,  0.07948,  0.08063,  0.08141,
  0.08187,  0.08203,  0.08185,  0.08134,
  0.08055,  0.07947,  0.07803,  0.07628,
  0.07432,  0.07217,  0.06980,  0.06721,
  0.06445,  0.06151,  0.05837,  0.05506,
  0.05160,  0.04798,  0.04420,  0.04032,
  0.03641,  0.03246,  0.02847,  0.02445,
  0.02046,  0.01650,  0.01258,  0.00870,
  0.00491,  0.00120, -0.00242, -0.00593,
 -0.00933, -0.01262, -0.01580, -0.01883,
 -0.02172, -0.02447, -0.02709, -0.02955,
 -0.03185, -0.03400, -0.03599, -0.03782,
 -0.03945, -0.04090, -0.04220, -0.04332,
 -0.04427, -0.04503, -0.04560, -0.04598,
 -0.04619, -0.04624, -0.04612, -0.04582,
 -0.04535, -0.04472, -0.04392, -0.04296,
 -0.04183, -0.04058, -0.03921, -0.03774,
 -0.03617, -0.03452, -0.03282, -0.03102,
 -0.02908, -0.02702, -0.02487, -0.02267,
 -0.02041, -0.01811, -0.01581, -0.01351,
 -0.01121, -0.00892, -0.00669, -0.00454,
 -0.00245, -0.00037,  0.00166,  0.00363,
  0.00553,  0.00739,  0.00920,  0.01093,
  0.01258,  0.01417,  0.01567,  0.01707,
  0.01838,  0.01960,  0.02070,  0.02166,
  0.02251,  0.02328,  0.02395,  0.02446,
  0.02486,  0.02516,  0.02535,  0.02539,
  0.02529,  0.02509,  0.02481,  0.02442,
  0.02395,  0.02339,  0.02273,  0.02195,
  0.02110,  0.02017,  0.01915,  0.01802,
  0.01687,  0.01573,  0.01459,  0.01339,
  0.01217,  0.01094,  0.00967,  0.00836,
  0.00707,  0.00583,  0.00458,  0.00331,
  0.00204,  0.00083, -0.00035, -0.00154,
 -0.00268, -0.00376, -0.00481, -0.00585,
 -0.00686, -0.00779, -0.00867, -0.00948,
 -0.01019, -0.01082, -0.01139, -0.01190,
 -0.01230, -0.01262, -0.01291, -0.01316,
 -0.01332, -0.01340, -0.01342, -0.01341,
 -0.01334, -0.01322, -0.01307, -0.01287,
 -0.01262, -0.01235, -0.01207, -0.01177,
 -0.01144, -0.01111, -0.01076, -0.01039,
 -0.00998, -0.00955, -0.00911, -0.00862,
 -0.00810, -0.00756, -0.00701, -0.00641,
 -0.00578, -0.00515, -0.00455, -0.00395,
 -0.00339, -0.00285, -0.00231, -0.00174,
 -0.00117, -0.00063, -0.00009,  0.00050,
  0.00113,  0.00172,  0.00224,  0.00270,
  0.00313,  0.00352,  0.00390,  0.00423,
  0.00447,  0.00462,  0.00471,  0.00478,
  0.00488,  0.00500,  0.00510,  0.00517,
  0.00522,  0.00528,  0.00533,  0.00532,
  0.00525,  0.00518,  0.00509,  0.00495,
  0.00478,  0.00459,  0.00441,  0.00422,
  0.00402,  0.00382,  0.00361,  0.00338,
  0.00315,  0.00293,  0.00270,  0.00243,
  0.00214,  0.00183,  0.00150,  0.00113,
  0.00073,  0.00033, -0.00008, -0.00048,
 -0.00087, -0.00126, -0.00164, -0.00199,
 -0.00232, -0.00263, -0.00293, -0.00320,
 -0.00342, -0.00361, -0.00379, -0.00396,
 -0.00409, -0.00421, -0.00433, -0.00443,
 -0.00451, -0.00457, -0.00461, -0.00462,
 -0.00464, -0.00468, -0.00469, -0.00466,
 -0.00460, -0.00451, -0.00439, -0.00419,
 -0.00397, -0.00376, -0.00355, -0.00332,
 -0.00309, -0.00287, -0.00263, -0.00236,
 -0.00208, -0.00183, -0.00156, -0.00128,
 -0.00099, -0.00067, -0.00032,  0.00007,
  0.00048,  0.00090,  0.00136,  0.00182,
  0.00225,  0.00266,  0.00305,  0.00343,
  0.00376,  0.00405,  0.00432,  0.00459,
  0.00483,  0.00504,  0.00521,  0.00536,
  0.00547,  0.00554,  0.00559,  0.00564,
  0.00571,  0.00576,  0.00577,  0.00576,
  0.00577,  0.00577,  0.00574,  0.00571,
  0.00570,  0.00566,  0.00554,  0.00543,
  0.00532,  0.00511,  0.00476,  0.00445,
  0.00426,  0.00402,  0.00359,  0.00312,
  0.00283,  0.00259,  0.00217,  0.00165,
  0.00131,  0.00112,  0.00084,  0.00042,
  0.00002, -0.00027, -0.00057, -0.00096,
 -0.00137, -0.00174, -0.00213, -0.00258,
 -0.00304, -0.00349, -0.00392, -0.00435,
 -0.00476, -0.00515, -0.00550, -0.00581,
 -0.00610, -0.00637, -0.00659, -0.00675,
 -0.00688, -0.00700, -0.00708, -0.00711,
 -0.00712, -0.00714, -0.00713, -0.00707,
 -0.00701, -0.00696, -0.00689, -0.00680,
 -0.00669, -0.00658, -0.00644, -0.00627,
 -0.00607, -0.00582, -0.00550, -0.00515,
 -0.00476, -0.00431, -0.00379, -0.00327,
 -0.00275, -0.00219, -0.00157, -0.00098,
 -0.00045,  0.00010,  0.00072,  0.00135,
  0.00188,  0.00233,  0.00275,  0.00318,
  0.00365,  0.00416,  0.00463,  0.00497,
  0.00524,  0.00556,  0.00592,  0.00624,
  0.00650,  0.00676,  0.00703,  0.00722,
  0.00733,  0.00740,  0.00747,  0.00751,
  0.00750,  0.00745,  0.00738,  0.00728,
  0.00716,  0.00704,  0.00689,  0.00673,
  0.00656,  0.00637,  0.00614,  0.00588,
  0.00560,  0.00528,  0.00489,  0.00447,
  0.00403,  0.00358,  0.00307,  0.00254,
  0.00201,  0.00150,  0.00097,  0.00042,
 -0.00012, -0.00063, -0.00111, -0.00156,
 -0.00199, -0.00239, -0.00277, -0.00311,
 -0.00347, -0.00382, -0.00412, -0.00435,
 -0.00457, -0.00481, -0.00506, -0.00529,
 -0.00552, -0.00576, -0.00598, -0.00617,
 -0.00639, -0.00663, -0.00683, -0.00695,
 -0.00700, -0.00701, -0.00698, -0.00691,
 -0.00682, -0.00673, -0.00660, -0.00641,
 -0.00622, -0.00605, -0.00587, -0.00565,
 -0.00538, -0.00512, -0.00487, -0.00459,
 -0.00430, -0.00399, -0.00368, -0.00336,
 -0.00304, -0.00272, -0.00242, -0.00212,
 -0.00181, -0.00151, -0.00123, -0.00098,
 -0.00072, -0.00047, -0.00024, -0.00003,
  0.00018,  0.00039,  0.00059,  0.00080,
  0.00101,  0.00123,  0.00144,  0.00167,
  0.00194,  0.00223,  0.00252,  0.00283,
  0.00317,  0.00351,  0.00382,  0.00412,
  0.00443,  0.00471,  0.00494,  0.00519,
  0.00549,  0.00582,  0.00611,  0.00635,
  0.00655,  0.00673,  0.00690,  0.00706,
  0.00715,  0.00714,  0.00707,  0.00699,
  0.00688,  0.00673,  0.00654,  0.00634,
  0.00612,  0.00586,  0.00558,  0.00532,
  0.00506,  0.00476,  0.00443,  0.00409,
  0.00374,  0.00336,  0.00295,  0.00252,
  0.00205,  0.00154,  0.00102,  0.00050,
 -0.00003, -0.00056, -0.00106, -0.00151,
 -0.00193, -0.00235, -0.00274, -0.00309,
 -0.00340, -0.00369, -0.00395, -0.00418,
 -0.00440, -0.00459, -0.00473, -0.00483,
 -0.00490, -0.00494, -0.00495, -0.00493,
 -0.00490, -0.00484, -0.00475, -0.00466,
 -0.00456, -0.00443, -0.00427, -0.00413,
 -0.00401, -0.00386, -0.00364, -0.00338,
 -0.00313, -0.00291, -0.00268, -0.00241,
 -0.00211, -0.00183, -0.00157, -0.00131,
 -0.00100, -0.00065, -0.00033, -0.00008,
  0.00012,  0.00029,  0.00041,  0.00047,
  0.00051,  0.00053,  0.00053,  0.00050,
  0.00046,  0.00038,  0.00025,  0.00010,
 -0.00005, -0.00020, -0.00035, -0.00050,
 -0.00061, -0.00070, -0.00080, -0.00089,
 -0.00095, -0.00099, -0.00104, -0.00109,
 -0.00109, -0.00104, -0.00099, -0.00095,
 -0.00089, -0.00080, -0.00070, -0.00061,
 -0.00050, -0.00035, -0.00020, -0.00005,
  0.00010,  0.00025,  0.00038,  0.00046,
  0.00050,  0.00053,  0.00053,  0.00051,
  0.00047,  0.00041,  0.00029,  0.00012,
 -0.00008, -0.00033, -0.00065, -0.00100,
 -0.00131, -0.00157, -0.00183, -0.00211,
 -0.00241, -0.00268, -0.00291, -0.00313,
 -0.00338, -0.00364, -0.00386, -0.00401,
 -0.00413, -0.00427, -0.00443, -0.00456,
 -0.00466, -0.00475, -0.00484, -0.00490,
 -0.00493, -0.00495, -0.00494, -0.00490,
 -0.00483, -0.00473, -0.00459, -0.00440,
 -0.00418, -0.00395, -0.00369, -0.00340,
 -0.00309, -0.00274, -0.00235, -0.00193,
 -0.00151, -0.00106, -0.00056, -0.00003,
  0.00050,  0.00102,  0.00154,  0.00205,
  0.00252,  0.00295,  0.00336,  0.00374,
  0.00409,  0.00443,  0.00476,  0.00506,
  0.00532,  0.00558,  0.00586,  0.00612,
  0.00634,  0.00654,  0.00673,  0.00688,
  0.00699,  0.00707,  0.00714,  0.00715,
  0.00706,  0.00690,  0.00673,  0.00655,
  0.00635,  0.00611,  0.00582,  0.00549,
  0.00519,  0.00494,  0.00471,  0.00443,
  0.00412,  0.00382,  0.00351,  0.00317,
  0.00283,  0.00252,  0.00223,  0.00194,
  0.00167,  0.00144,  0.00123,  0.00101,
  0.00080,  0.00059,  0.00039,  0.00018,
 -0.00003, -0.00024, -0.00047, -0.00072,
 -0.00098, -0.00123, -0.00151, -0.00181,
 -0.00212, -0.00242, -0.00272, -0.00304,
 -0.00336, -0.00368, -0.00399, -0.00430,
 -0.00459, -0.00487, -0.00512, -0.00538,
 -0.00565, -0.00587, -0.00605, -0.00622,
 -0.00641, -0.00660, -0.00673, -0.00682,
 -0.00691, -0.00698, -0.00701, -0.00700,
 -0.00695, -0.00683, -0.00663, -0.00639,
 -0.00617, -0.00598, -0.00576, -0.00552,
 -0.00529, -0.00506, -0.00481, -0.00457,
 -0.00435, -0.00412, -0.00382, -0.00347,
 -0.00311, -0.00277, -0.00239, -0.00199,
 -0.00156, -0.00111, -0.00063, -0.00012,
  0.00042,  0.00097,  0.00150,  0.00201,
  0.00254,  0.00307,  0.00358,  0.00403,
  0.00447,  0.00489,  0.00528,  0.00560,
  0.00588,  0.00614,  0.00637,  0.00656,
  0.00673,  0.00689,  0.00704,  0.00716,
  0.00728,  0.00738,  0.00745,  0.00750,
  0.00751,  0.00747,  0.00740,  0.00733,
  0.00722,  0.00703,  0.00676,  0.00650,
  0.00624,  0.00592,  0.00556,  0.00524,
  0.00497,  0.00463,  0.00416,  0.00365,
  0.00318,  0.00275,  0.00233,  0.00188,
  0.00135,  0.00072,  0.00010, -0.00045,
 -0.00098, -0.00157, -0.00219, -0.00275,
 -0.00327, -0.00379, -0.00431, -0.00476,
 -0.00515, -0.00550, -0.00582, -0.00607,
 -0.00627, -0.00644, -0.00658, -0.00669,
 -0.00680, -0.00689, -0.00696, -0.00701,
 -0.00707, -0.00713, -0.00714, -0.00712,
 -0.00711, -0.00708, -0.00700, -0.00688,
 -0.00675, -0.00659, -0.00637, -0.00610,
 -0.00581, -0.00550, -0.00515, -0.00476,
 -0.00435, -0.00392, -0.00349, -0.00304,
 -0.00258, -0.00213, -0.00174, -0.00137,
 -0.00096, -0.00057, -0.00027,  0.00002,
  0.00042,  0.00084,  0.00112,  0.00131,
  0.00165,  0.00217,  0.00259,  0.00283,
  0.00312,  0.00359,  0.00402,  0.00426,
  0.00445,  0.00476,  0.00511,  0.00532,
  0.00543,  0.00554,  0.00566,  0.00570,
  0.00571,  0.00574,  0.00577,  0.00577,
  0.00576,  0.00577,  0.00576,  0.00571,
  0.00564,  0.00559,  0.00554,  0.00547,
  0.00536,  0.00521,  0.00504,  0.00483,
  0.00459,  0.00432,  0.00405,  0.00376,
  0.00343,  0.00305,  0.00266,  0.00225,
  0.00182,  0.00136,  0.00090,  0.00048,
  0.00007, -0.00032, -0.00067, -0.00099,
 -0.00128, -0.00156, -0.00183, -0.00208,
 -0.00236, -0.00263, -0.00287, -0.00309,
 -0.00332, -0.00355, -0.00376, -0.00397,
 -0.00419, -0.00439, -0.00451, -0.00460,
 -0.00466, -0.00469, -0.00468, -0.00464,
 -0.00462, -0.00461, -0.00457, -0.00451,
 -0.00443, -0.00433, -0.00421, -0.00409,
 -0.00396, -0.00379, -0.00361, -0.00342,
 -0.00320, -0.00293, -0.00263, -0.00232,
 -0.00199, -0.00164, -0.00126, -0.00087,
 -0.00048, -0.00008,  0.00033,  0.00073,
  0.00113,  0.00150,  0.00183,  0.00214,
  0.00243,  0.00270,  0.00293,  0.00315,
  0.00338,  0.00361,  0.00382,  0.00402,
  0.00422,  0.00441,  0.00459,  0.00478,
  0.00495,  0.00509,  0.00518,  0.00525,
  0.00532,  0.00533,  0.00528,  0.00522,
  0.00517,  0.00510,  0.00500,  0.00488,
  0.00478,  0.00471,  0.00462,  0.00447,
  0.00423,  0.00390,  0.00352,  0.00313,
  0.00270,  0.00224,  0.00172,  0.00113,
  0.00050, -0.00009, -0.00063, -0.00117,
 -0.00174, -0.00231, -0.00285, -0.00339,
 -0.00395, -0.00455, -0.00515, -0.00578,
 -0.00641, -0.00701, -0.00756, -0.00810,
 -0.00862, -0.00911, -0.00955, -0.00998,
 -0.01039, -0.01076, -0.01111, -0.01144,
 -0.01177, -0.01207, -0.01235, -0.01262,
 -0.01287, -0.01307, -0.01322, -0.01334,
 -0.01341, -0.01342, -0.01340, -0.01332,
 -0.01316, -0.01291, -0.01262, -0.01230,
 -0.01190, -0.01139, -0.01082, -0.01019,
 -0.00948, -0.00867, -0.00779, -0.00686,
 -0.00585, -0.00481, -0.00376, -0.00268,
 -0.00154, -0.00035,  0.00083,  0.00204,
  0.00331,  0.00458,  0.00583,  0.00707,
  0.00836,  0.00967,  0.01094,  0.01217,
  0.01339,  0.01459,  0.01573,  0.01687,
  0.01802,  0.01915,  0.02017,  0.02110,
  0.02195,  0.02273,  0.02339,  0.02395,
  0.02442,  0.02481,  0.02509,  0.02529,
  0.02539,  0.02535,  0.02516,  0.02486,
  0.02446,  0.02395,  0.02328,  0.02251,
  0.02166,  0.02070,  0.01960,  0.01838,
  0.01707,  0.01567,  0.01417,  0.01258,
  0.01093,  0.00920,  0.00739,  0.00553,
  0.00363,  0.00166, -0.00037, -0.00245];

pub fn imdct_prepare(arr :&[f32]) -> Vec<f32> {
	let mut res = Vec::with_capacity(arr.len() * 2);
	res.extend_from_slice(arr);
	for _ in 0 .. arr.len() {
		res.push(0.);
	}
	return res;
}

pub fn fuzzy_compare_array(arr_a :&[f32], arr_b :&[f32],
		epsilon :f32, print_mismatches :bool) -> usize {
	let mut mismatch_cnt :usize = 0;
	for ((idx, entry_a), entry_b) in arr_a.iter().enumerate().zip(arr_b) {
		if (entry_a - entry_b).abs() >= epsilon {
			if print_mismatches {
				println!("Mismatch at idx {}. Expected {} but was {}",
					idx, entry_a, entry_b);
			}
			mismatch_cnt += 1;
		}
	}
	return mismatch_cnt;
}
