package crack

import "github.com/spf13/pflag"

func bindCrackFlags(f *pflag.FlagSet) {
	f.String("attack-mode", "", "crack attack mode (straight, combination, bruteforce, hybrid-wordlist-mask, hybrid-mask-wordlist, association, no-attack, or numeric)")
	f.String("hash-type", "", "hashcat hash type (number or enum name)")
	f.StringSlice("hash", nil, "hashes to crack (repeatable)")
	f.Bool("quiet", false, "quiet mode")
	f.Bool("hex-charset", false, "treat charset as hex")
	f.Bool("hex-salt", false, "treat salt as hex")
	f.Bool("hex-wordlist", false, "treat wordlist as hex")
	f.Bool("force", false, "ignore warnings")
	f.Bool("deprecated-check-disable", false, "disable deprecated check")
	f.Bool("status", false, "enable status")
	f.Bool("status-json", false, "emit status in JSON")
	f.Uint32("status-timer", 0, "status timer interval (seconds)")
	f.Uint32("stdin-timeout-abort", 0, "abort after stdin timeout (seconds)")
	f.Bool("machine-readable", false, "machine readable output")
	f.Bool("keep-guessing", false, "keep guessing")
	f.Bool("self-test-disable", false, "disable self-test")
	f.Bool("loopback", false, "use loopback mode")
	f.String("markov-hcstat2", "", "markov hcstat2 filename or identifier")
	f.Bool("markov-disable", false, "disable markov mode")
	f.Bool("markov-classic", false, "use classic markov")
	f.Bool("markov-inverse", false, "use inverse markov")
	f.Uint32("markov-threshold", 0, "markov threshold")
	f.Uint32("runtime", 0, "runtime in seconds")
	f.String("session", "", "session name")
	f.Bool("restore", false, "restore session")
	f.Bool("restore-disable", false, "disable restore")
	f.String("restore-file", "", "restore file path or identifier")
	f.StringSlice("outfile-format", nil, "outfile formats (hash-salt, plain, hex-plain, crack-pos, timestamp-absolute, timestamp-relative, or numeric)")
	f.Bool("outfile-autohex-disable", false, "disable outfile autohex")
	f.Uint32("outfile-check-timer", 0, "outfile check timer interval (seconds)")
	f.Bool("wordlist-autohex-disable", false, "disable wordlist autohex")
	f.String("separator", "", "separator character")
	f.Bool("stdout", false, "stdout output")
	f.Bool("show", false, "show cracked hashes")
	f.Bool("left", false, "show uncracked hashes")
	f.Bool("username", false, "enable username handling")
	f.Bool("remove", false, "remove cracked hashes")
	f.Uint32("remove-timer", 0, "remove timer interval (seconds)")
	f.Bool("potfile-disable", false, "disable potfile")
	f.String("potfile", "", "potfile path or identifier")
	f.String("encoding-from", "", "input encoding (iso-8859-15, utf-32le, or numeric)")
	f.String("encoding-to", "", "output encoding (iso-8859-15, utf-32le, or numeric)")
	f.Uint32("debug-mode", 0, "debug mode mask")
	f.Bool("logfile-disable", false, "disable logfile")
	f.Uint32("hccapx-message-pair", 0, "hccapx message pair")
	f.Uint32("nonce-error-corrections", 0, "nonce error corrections")
	f.String("keyboard-layout-mapping", "", "keyboard layout mapping file or identifier")
	f.Bool("benchmark", false, "run benchmark")
	f.Bool("benchmark-all", false, "run full benchmark")
	f.Bool("speed-only", false, "show speed only")
	f.Bool("progress-only", false, "show progress only")
	f.Uint32("segment-size", 0, "segment size")
	f.Uint32("bitmap-min", 0, "bitmap min")
	f.Uint32("bitmap-max", 0, "bitmap max")
	f.UintSlice("cpu-affinity", nil, "CPU affinity list")
	f.Uint32("hook-threads", 0, "hook threads")
	f.Bool("hash-info", false, "show hash information")
	f.Bool("backend-ignore-cuda", false, "ignore CUDA backend")
	f.Bool("backend-ignore-hip", false, "ignore HIP backend")
	f.Bool("backend-ignore-metal", false, "ignore Metal backend")
	f.Bool("backend-ignore-opencl", false, "ignore OpenCL backend")
	f.Bool("backend-info", false, "show backend info")
	f.UintSlice("backend-devices", nil, "backend device IDs")
	f.UintSlice("opencl-device-types", nil, "OpenCL device types")
	f.Bool("optimized-kernel-enable", false, "enable optimized kernels")
	f.Bool("multiply-accel-disabled", false, "disable multiply accel")
	f.String("workload-profile", "", "workload profile (low, default, high, nightmare, or numeric)")
	f.Uint32("kernel-accel", 0, "kernel acceleration")
	f.Uint32("kernel-loops", 0, "kernel loops")
	f.Uint32("kernel-threads", 0, "kernel threads")
	f.Uint32("backend-vector-width", 0, "backend vector width")
	f.Uint32("spin-damp", 0, "spin damp")
	f.Bool("hwmon-disable", false, "disable hardware monitoring")
	f.Uint32("hwmon-temp-abort", 0, "hardware monitor temperature abort")
	f.Uint32("scrypt-tmto", 0, "scrypt tmto")
	f.Uint64("skip", 0, "skip count")
	f.Uint64("limit", 0, "limit count")
	f.Bool("keyspace", false, "show keyspace")
	f.String("rules-file", "", "rules file path or identifier")
	f.Uint32("generate-rules", 0, "generate rules")
	f.Uint32("generate-rules-fun-min", 0, "generate rules function min")
	f.Uint32("generate-rules-fun-max", 0, "generate rules function max")
	f.String("generate-rules-func-sel", "", "generate rules function selection")
	f.Int32("generate-rules-seed", 0, "generate rules seed")
	f.String("custom-charset1", "", "custom charset 1")
	f.String("custom-charset2", "", "custom charset 2")
	f.String("custom-charset3", "", "custom charset 3")
	f.String("custom-charset4", "", "custom charset 4")
	f.String("identify", "", "identify hash")
	f.Bool("increment", false, "incremental mode")
	f.Uint32("increment-min", 0, "increment min")
	f.Uint32("increment-max", 0, "increment max")
	f.Bool("slow-candidates", false, "slow candidates")
	f.Bool("brain-server", false, "brain server mode")
	f.Uint32("brain-server-timer", 0, "brain server timer")
	f.Bool("brain-client", false, "brain client mode")
	f.String("brain-client-features", "", "brain client features")
	f.String("brain-host", "", "brain host")
	f.Uint32("brain-port", 0, "brain port")
	f.String("brain-password", "", "brain password")
	f.String("brain-session", "", "brain session")
	f.String("brain-session-whitelist", "", "brain session whitelist")
}
