// Code generated by smithy-go-codegen DO NOT EDIT.

package sns

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Use this request to set the default settings for sending SMS messages and
// receiving daily SMS usage reports.
//
// You can override some of these settings for a single message when you use the
// Publish action with the MessageAttributes.entry.N parameter. For more
// information, see [Publishing to a mobile phone]in the Amazon SNS Developer Guide.
//
// To use this operation, you must grant the Amazon SNS service principal (
// sns.amazonaws.com ) permission to perform the s3:ListBucket action.
//
// [Publishing to a mobile phone]: https://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html
func (c *Client) SetSMSAttributes(ctx context.Context, params *SetSMSAttributesInput, optFns ...func(*Options)) (*SetSMSAttributesOutput, error) {
	if params == nil {
		params = &SetSMSAttributesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SetSMSAttributes", params, optFns, c.addOperationSetSMSAttributesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SetSMSAttributesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The input for the SetSMSAttributes action.
type SetSMSAttributesInput struct {

	// The default settings for sending SMS messages from your Amazon Web Services
	// account. You can set values for the following attribute names:
	//
	// MonthlySpendLimit – The maximum amount in USD that you are willing to spend
	// each month to send SMS messages. When Amazon SNS determines that sending an SMS
	// message would incur a cost that exceeds this limit, it stops sending SMS
	// messages within minutes.
	//
	// Amazon SNS stops sending SMS messages within minutes of the limit being
	// crossed. During that interval, if you continue to send SMS messages, you will
	// incur costs that exceed your limit.
	//
	// By default, the spend limit is set to the maximum allowed by Amazon SNS. If you
	// want to raise the limit, submit an [SNS Limit Increase case]. For New limit value, enter your desired
	// monthly spend limit. In the Use Case Description field, explain that you are
	// requesting an SMS monthly spend limit increase.
	//
	// DeliveryStatusIAMRole – The ARN of the IAM role that allows Amazon SNS to write
	// logs about SMS deliveries in CloudWatch Logs. For each SMS message that you
	// send, Amazon SNS writes a log that includes the message price, the success or
	// failure status, the reason for failure (if the message failed), the message
	// dwell time, and other information.
	//
	// DeliveryStatusSuccessSamplingRate – The percentage of successful SMS deliveries
	// for which Amazon SNS will write logs in CloudWatch Logs. The value can be an
	// integer from 0 - 100. For example, to write logs only for failed deliveries, set
	// this value to 0 . To write logs for 10% of your successful deliveries, set it to
	// 10 .
	//
	// DefaultSenderID – A string, such as your business brand, that is displayed as
	// the sender on the receiving device. Support for sender IDs varies by country.
	// The sender ID can be 1 - 11 alphanumeric characters, and it must contain at
	// least one letter.
	//
	// DefaultSMSType – The type of SMS message that you will send by default. You can
	// assign the following values:
	//
	//   - Promotional – (Default) Noncritical messages, such as marketing messages.
	//   Amazon SNS optimizes the message delivery to incur the lowest cost.
	//
	//   - Transactional – Critical messages that support customer transactions, such
	//   as one-time passcodes for multi-factor authentication. Amazon SNS optimizes the
	//   message delivery to achieve the highest reliability.
	//
	// UsageReportS3Bucket – The name of the Amazon S3 bucket to receive daily SMS
	// usage reports from Amazon SNS. Each day, Amazon SNS will deliver a usage report
	// as a CSV file to the bucket. The report includes the following information for
	// each SMS message that was successfully delivered by your Amazon Web Services
	// account:
	//
	//   - Time that the message was published (in UTC)
	//
	//   - Message ID
	//
	//   - Destination phone number
	//
	//   - Message type
	//
	//   - Delivery status
	//
	//   - Message price (in USD)
	//
	//   - Part number (a message is split into multiple parts if it is too long for a
	//   single message)
	//
	//   - Total number of parts
	//
	// To receive the report, the bucket must have a policy that allows the Amazon SNS
	// service principal to perform the s3:PutObject and s3:GetBucketLocation actions.
	//
	// For an example bucket policy and usage report, see [Monitoring SMS Activity] in the Amazon SNS Developer
	// Guide.
	//
	// [Monitoring SMS Activity]: https://docs.aws.amazon.com/sns/latest/dg/sms_stats.html
	// [SNS Limit Increase case]: https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-sns
	//
	// This member is required.
	Attributes map[string]string

	noSmithyDocumentSerde
}

// The response for the SetSMSAttributes action.
type SetSMSAttributesOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSetSMSAttributesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpSetSMSAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpSetSMSAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SetSMSAttributes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSetSMSAttributesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSetSMSAttributes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSetSMSAttributes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SetSMSAttributes",
	}
}
