/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"time"
	"bytes"
	"fmt"
)

// checks if the Chat type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &Chat{}

// Chat struct for Chat
type Chat struct {
	// Chat ID.
	Id int32 `json:"id"`
	OriginalId NullableInt32 `json:"originalId"`
	// Chat partner's phone number.
	Phone string `json:"phone"`
	Contact NullableContact `json:"contact"`
	// If this field has a value, it means that the chat phone number has been unsubscribed from you and this value is an ID of an Unsubscribed contact entity. See [Get all unsubscribed contacts](https://docs.textmagic.com/#operation/getUnsubscribers).
	UnsubscribedContactId NullableInt32 `json:"unsubscribedContactId"`
	// Total unread incoming messages.
	Unread int32 `json:"unread"`
	// Time when the last incoming message arrived at this chat.
	UpdatedAt time.Time `json:"updatedAt"`
	// Chat status:   * **a** - Active;   * **c** - Closed;   * **d** - Deleted. 
	Status string `json:"status"`
	// Indicates when the chat is muted.
	Mute int32 `json:"mute"`
	// The last message content of a chat.
	LastMessage NullableString `json:"lastMessage"`
	// Last message type: * **ci** - incoming call; * **co** - outgoing call; * **i** - incoming message; * **o** - outgoing message. 
	Direction NullableString `json:"direction"`
	// Used for chats prices.
	ReplyOptionsType NullableString `json:"replyOptionsType"`
	// If filled, the value will be used as a sender number for all outgoing messages of a chat.
	From NullableString `json:"from"`
	// Date and time until the chat will be muted.
	MutedUntil NullableTime `json:"mutedUntil"`
	// Time left untill the chat will be unmuted (seconds).
	TimeLeftMute int32 `json:"timeLeftMute"`
	Country NullableCountry `json:"country"`
	// Indicates when the chat is pinned.
	Pinned NullableBool `json:"pinned"`
	// Chat type.
	Type string `json:"type"`
	SmsPrice float32 `json:"smsPrice"`
	MmsPrice float32 `json:"mmsPrice"`
	Tags []Tag `json:"tags,omitempty"`
}

type _Chat Chat

// NewChat instantiates a new Chat object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewChat(id int32, originalId NullableInt32, phone string, contact NullableContact, unsubscribedContactId NullableInt32, unread int32, updatedAt time.Time, status string, mute int32, lastMessage NullableString, direction NullableString, replyOptionsType NullableString, from NullableString, mutedUntil NullableTime, timeLeftMute int32, country NullableCountry, pinned NullableBool, type_ string, smsPrice float32, mmsPrice float32) *Chat {
	this := Chat{}
	this.Id = id
	this.OriginalId = originalId
	this.Phone = phone
	this.Contact = contact
	this.UnsubscribedContactId = unsubscribedContactId
	this.Unread = unread
	this.UpdatedAt = updatedAt
	this.Status = status
	this.Mute = mute
	this.LastMessage = lastMessage
	this.Direction = direction
	this.ReplyOptionsType = replyOptionsType
	this.From = from
	this.MutedUntil = mutedUntil
	this.TimeLeftMute = timeLeftMute
	this.Country = country
	this.Pinned = pinned
	this.Type = type_
	this.SmsPrice = smsPrice
	this.MmsPrice = mmsPrice
	return &this
}

// NewChatWithDefaults instantiates a new Chat object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewChatWithDefaults() *Chat {
	this := Chat{}
	return &this
}

// GetId returns the Id field value
func (o *Chat) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *Chat) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *Chat) SetId(v int32) {
	o.Id = v
}

// GetOriginalId returns the OriginalId field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *Chat) GetOriginalId() int32 {
	if o == nil || o.OriginalId.Get() == nil {
		var ret int32
		return ret
	}

	return *o.OriginalId.Get()
}

// GetOriginalIdOk returns a tuple with the OriginalId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Chat) GetOriginalIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.OriginalId.Get(), o.OriginalId.IsSet()
}

// SetOriginalId sets field value
func (o *Chat) SetOriginalId(v int32) {
	o.OriginalId.Set(&v)
}

// GetPhone returns the Phone field value
func (o *Chat) GetPhone() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Phone
}

// GetPhoneOk returns a tuple with the Phone field value
// and a boolean to check if the value has been set.
func (o *Chat) GetPhoneOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Phone, true
}

// SetPhone sets field value
func (o *Chat) SetPhone(v string) {
	o.Phone = v
}

// GetContact returns the Contact field value
// If the value is explicit nil, the zero value for Contact will be returned
func (o *Chat) GetContact() Contact {
	if o == nil || o.Contact.Get() == nil {
		var ret Contact
		return ret
	}

	return *o.Contact.Get()
}

// GetContactOk returns a tuple with the Contact field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Chat) GetContactOk() (*Contact, bool) {
	if o == nil {
		return nil, false
	}
	return o.Contact.Get(), o.Contact.IsSet()
}

// SetContact sets field value
func (o *Chat) SetContact(v Contact) {
	o.Contact.Set(&v)
}

// GetUnsubscribedContactId returns the UnsubscribedContactId field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *Chat) GetUnsubscribedContactId() int32 {
	if o == nil || o.UnsubscribedContactId.Get() == nil {
		var ret int32
		return ret
	}

	return *o.UnsubscribedContactId.Get()
}

// GetUnsubscribedContactIdOk returns a tuple with the UnsubscribedContactId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Chat) GetUnsubscribedContactIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.UnsubscribedContactId.Get(), o.UnsubscribedContactId.IsSet()
}

// SetUnsubscribedContactId sets field value
func (o *Chat) SetUnsubscribedContactId(v int32) {
	o.UnsubscribedContactId.Set(&v)
}

// GetUnread returns the Unread field value
func (o *Chat) GetUnread() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Unread
}

// GetUnreadOk returns a tuple with the Unread field value
// and a boolean to check if the value has been set.
func (o *Chat) GetUnreadOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Unread, true
}

// SetUnread sets field value
func (o *Chat) SetUnread(v int32) {
	o.Unread = v
}

// GetUpdatedAt returns the UpdatedAt field value
func (o *Chat) GetUpdatedAt() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.UpdatedAt
}

// GetUpdatedAtOk returns a tuple with the UpdatedAt field value
// and a boolean to check if the value has been set.
func (o *Chat) GetUpdatedAtOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.UpdatedAt, true
}

// SetUpdatedAt sets field value
func (o *Chat) SetUpdatedAt(v time.Time) {
	o.UpdatedAt = v
}

// GetStatus returns the Status field value
func (o *Chat) GetStatus() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Status
}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
func (o *Chat) GetStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Status, true
}

// SetStatus sets field value
func (o *Chat) SetStatus(v string) {
	o.Status = v
}

// GetMute returns the Mute field value
func (o *Chat) GetMute() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Mute
}

// GetMuteOk returns a tuple with the Mute field value
// and a boolean to check if the value has been set.
func (o *Chat) GetMuteOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Mute, true
}

// SetMute sets field value
func (o *Chat) SetMute(v int32) {
	o.Mute = v
}

// GetLastMessage returns the LastMessage field value
// If the value is explicit nil, the zero value for string will be returned
func (o *Chat) GetLastMessage() string {
	if o == nil || o.LastMessage.Get() == nil {
		var ret string
		return ret
	}

	return *o.LastMessage.Get()
}

// GetLastMessageOk returns a tuple with the LastMessage field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Chat) GetLastMessageOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.LastMessage.Get(), o.LastMessage.IsSet()
}

// SetLastMessage sets field value
func (o *Chat) SetLastMessage(v string) {
	o.LastMessage.Set(&v)
}

// GetDirection returns the Direction field value
// If the value is explicit nil, the zero value for string will be returned
func (o *Chat) GetDirection() string {
	if o == nil || o.Direction.Get() == nil {
		var ret string
		return ret
	}

	return *o.Direction.Get()
}

// GetDirectionOk returns a tuple with the Direction field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Chat) GetDirectionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Direction.Get(), o.Direction.IsSet()
}

// SetDirection sets field value
func (o *Chat) SetDirection(v string) {
	o.Direction.Set(&v)
}

// GetReplyOptionsType returns the ReplyOptionsType field value
// If the value is explicit nil, the zero value for string will be returned
func (o *Chat) GetReplyOptionsType() string {
	if o == nil || o.ReplyOptionsType.Get() == nil {
		var ret string
		return ret
	}

	return *o.ReplyOptionsType.Get()
}

// GetReplyOptionsTypeOk returns a tuple with the ReplyOptionsType field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Chat) GetReplyOptionsTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ReplyOptionsType.Get(), o.ReplyOptionsType.IsSet()
}

// SetReplyOptionsType sets field value
func (o *Chat) SetReplyOptionsType(v string) {
	o.ReplyOptionsType.Set(&v)
}

// GetFrom returns the From field value
// If the value is explicit nil, the zero value for string will be returned
func (o *Chat) GetFrom() string {
	if o == nil || o.From.Get() == nil {
		var ret string
		return ret
	}

	return *o.From.Get()
}

// GetFromOk returns a tuple with the From field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Chat) GetFromOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.From.Get(), o.From.IsSet()
}

// SetFrom sets field value
func (o *Chat) SetFrom(v string) {
	o.From.Set(&v)
}

// GetMutedUntil returns the MutedUntil field value
// If the value is explicit nil, the zero value for time.Time will be returned
func (o *Chat) GetMutedUntil() time.Time {
	if o == nil || o.MutedUntil.Get() == nil {
		var ret time.Time
		return ret
	}

	return *o.MutedUntil.Get()
}

// GetMutedUntilOk returns a tuple with the MutedUntil field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Chat) GetMutedUntilOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return o.MutedUntil.Get(), o.MutedUntil.IsSet()
}

// SetMutedUntil sets field value
func (o *Chat) SetMutedUntil(v time.Time) {
	o.MutedUntil.Set(&v)
}

// GetTimeLeftMute returns the TimeLeftMute field value
func (o *Chat) GetTimeLeftMute() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.TimeLeftMute
}

// GetTimeLeftMuteOk returns a tuple with the TimeLeftMute field value
// and a boolean to check if the value has been set.
func (o *Chat) GetTimeLeftMuteOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.TimeLeftMute, true
}

// SetTimeLeftMute sets field value
func (o *Chat) SetTimeLeftMute(v int32) {
	o.TimeLeftMute = v
}

// GetCountry returns the Country field value
// If the value is explicit nil, the zero value for Country will be returned
func (o *Chat) GetCountry() Country {
	if o == nil || o.Country.Get() == nil {
		var ret Country
		return ret
	}

	return *o.Country.Get()
}

// GetCountryOk returns a tuple with the Country field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Chat) GetCountryOk() (*Country, bool) {
	if o == nil {
		return nil, false
	}
	return o.Country.Get(), o.Country.IsSet()
}

// SetCountry sets field value
func (o *Chat) SetCountry(v Country) {
	o.Country.Set(&v)
}

// GetPinned returns the Pinned field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *Chat) GetPinned() bool {
	if o == nil || o.Pinned.Get() == nil {
		var ret bool
		return ret
	}

	return *o.Pinned.Get()
}

// GetPinnedOk returns a tuple with the Pinned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Chat) GetPinnedOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.Pinned.Get(), o.Pinned.IsSet()
}

// SetPinned sets field value
func (o *Chat) SetPinned(v bool) {
	o.Pinned.Set(&v)
}

// GetType returns the Type field value
func (o *Chat) GetType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Type
}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
func (o *Chat) GetTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Type, true
}

// SetType sets field value
func (o *Chat) SetType(v string) {
	o.Type = v
}

// GetSmsPrice returns the SmsPrice field value
func (o *Chat) GetSmsPrice() float32 {
	if o == nil {
		var ret float32
		return ret
	}

	return o.SmsPrice
}

// GetSmsPriceOk returns a tuple with the SmsPrice field value
// and a boolean to check if the value has been set.
func (o *Chat) GetSmsPriceOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.SmsPrice, true
}

// SetSmsPrice sets field value
func (o *Chat) SetSmsPrice(v float32) {
	o.SmsPrice = v
}

// GetMmsPrice returns the MmsPrice field value
func (o *Chat) GetMmsPrice() float32 {
	if o == nil {
		var ret float32
		return ret
	}

	return o.MmsPrice
}

// GetMmsPriceOk returns a tuple with the MmsPrice field value
// and a boolean to check if the value has been set.
func (o *Chat) GetMmsPriceOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.MmsPrice, true
}

// SetMmsPrice sets field value
func (o *Chat) SetMmsPrice(v float32) {
	o.MmsPrice = v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *Chat) GetTags() []Tag {
	if o == nil || IsNil(o.Tags) {
		var ret []Tag
		return ret
	}
	return o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Chat) GetTagsOk() ([]Tag, bool) {
	if o == nil || IsNil(o.Tags) {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *Chat) HasTags() bool {
	if o != nil && !IsNil(o.Tags) {
		return true
	}

	return false
}

// SetTags gets a reference to the given []Tag and assigns it to the Tags field.
func (o *Chat) SetTags(v []Tag) {
	o.Tags = v
}

func (o Chat) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o Chat) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["originalId"] = o.OriginalId.Get()
	toSerialize["phone"] = o.Phone
	toSerialize["contact"] = o.Contact.Get()
	toSerialize["unsubscribedContactId"] = o.UnsubscribedContactId.Get()
	toSerialize["unread"] = o.Unread
	toSerialize["updatedAt"] = o.UpdatedAt
	toSerialize["status"] = o.Status
	toSerialize["mute"] = o.Mute
	toSerialize["lastMessage"] = o.LastMessage.Get()
	toSerialize["direction"] = o.Direction.Get()
	toSerialize["replyOptionsType"] = o.ReplyOptionsType.Get()
	toSerialize["from"] = o.From.Get()
	toSerialize["mutedUntil"] = o.MutedUntil.Get()
	toSerialize["timeLeftMute"] = o.TimeLeftMute
	toSerialize["country"] = o.Country.Get()
	toSerialize["pinned"] = o.Pinned.Get()
	toSerialize["type"] = o.Type
	toSerialize["smsPrice"] = o.SmsPrice
	toSerialize["mmsPrice"] = o.MmsPrice
	if !IsNil(o.Tags) {
		toSerialize["tags"] = o.Tags
	}
	return toSerialize, nil
}

func (o *Chat) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"originalId",
		"phone",
		"contact",
		"unsubscribedContactId",
		"unread",
		"updatedAt",
		"status",
		"mute",
		"lastMessage",
		"direction",
		"replyOptionsType",
		"from",
		"mutedUntil",
		"timeLeftMute",
		"country",
		"pinned",
		"type",
		"smsPrice",
		"mmsPrice",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varChat := _Chat{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varChat)

	if err != nil {
		return err
	}

	*o = Chat(varChat)

	return err
}

type NullableChat struct {
	value *Chat
	isSet bool
}

func (v NullableChat) Get() *Chat {
	return v.value
}

func (v *NullableChat) Set(val *Chat) {
	v.value = val
	v.isSet = true
}

func (v NullableChat) IsSet() bool {
	return v.isSet
}

func (v *NullableChat) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableChat(val *Chat) *NullableChat {
	return &NullableChat{value: val, isSet: true}
}

func (v NullableChat) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableChat) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


