/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"time"
	"bytes"
	"fmt"
)

// checks if the EmailSenderItem type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &EmailSenderItem{}

// EmailSenderItem struct for EmailSenderItem
type EmailSenderItem struct {
	// Unique email sender identifier.
	Id int32 `json:"id"`
	// ID of the associated domain.
	DomainId int32 `json:"domainId"`
	// Email address of the sender.
	Email string `json:"email"`
	// When the email sender was created.
	CreatedAt time.Time `json:"createdAt"`
	// Current verification status of the associated domain.
	DomainStatus string `json:"domainStatus"`
	// Display name for the sender.
	FromName NullableString `json:"fromName,omitempty"`
	// Reply-to email address.
	ReplyTo NullableString `json:"replyTo,omitempty"`
}

type _EmailSenderItem EmailSenderItem

// NewEmailSenderItem instantiates a new EmailSenderItem object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEmailSenderItem(id int32, domainId int32, email string, createdAt time.Time, domainStatus string) *EmailSenderItem {
	this := EmailSenderItem{}
	this.Id = id
	this.DomainId = domainId
	this.Email = email
	this.CreatedAt = createdAt
	this.DomainStatus = domainStatus
	return &this
}

// NewEmailSenderItemWithDefaults instantiates a new EmailSenderItem object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEmailSenderItemWithDefaults() *EmailSenderItem {
	this := EmailSenderItem{}
	return &this
}

// GetId returns the Id field value
func (o *EmailSenderItem) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *EmailSenderItem) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *EmailSenderItem) SetId(v int32) {
	o.Id = v
}

// GetDomainId returns the DomainId field value
func (o *EmailSenderItem) GetDomainId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.DomainId
}

// GetDomainIdOk returns a tuple with the DomainId field value
// and a boolean to check if the value has been set.
func (o *EmailSenderItem) GetDomainIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.DomainId, true
}

// SetDomainId sets field value
func (o *EmailSenderItem) SetDomainId(v int32) {
	o.DomainId = v
}

// GetEmail returns the Email field value
func (o *EmailSenderItem) GetEmail() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Email
}

// GetEmailOk returns a tuple with the Email field value
// and a boolean to check if the value has been set.
func (o *EmailSenderItem) GetEmailOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Email, true
}

// SetEmail sets field value
func (o *EmailSenderItem) SetEmail(v string) {
	o.Email = v
}

// GetCreatedAt returns the CreatedAt field value
func (o *EmailSenderItem) GetCreatedAt() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.CreatedAt
}

// GetCreatedAtOk returns a tuple with the CreatedAt field value
// and a boolean to check if the value has been set.
func (o *EmailSenderItem) GetCreatedAtOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.CreatedAt, true
}

// SetCreatedAt sets field value
func (o *EmailSenderItem) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

// GetDomainStatus returns the DomainStatus field value
func (o *EmailSenderItem) GetDomainStatus() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.DomainStatus
}

// GetDomainStatusOk returns a tuple with the DomainStatus field value
// and a boolean to check if the value has been set.
func (o *EmailSenderItem) GetDomainStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.DomainStatus, true
}

// SetDomainStatus sets field value
func (o *EmailSenderItem) SetDomainStatus(v string) {
	o.DomainStatus = v
}

// GetFromName returns the FromName field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *EmailSenderItem) GetFromName() string {
	if o == nil || IsNil(o.FromName.Get()) {
		var ret string
		return ret
	}
	return *o.FromName.Get()
}

// GetFromNameOk returns a tuple with the FromName field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *EmailSenderItem) GetFromNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.FromName.Get(), o.FromName.IsSet()
}

// HasFromName returns a boolean if a field has been set.
func (o *EmailSenderItem) HasFromName() bool {
	if o != nil && o.FromName.IsSet() {
		return true
	}

	return false
}

// SetFromName gets a reference to the given NullableString and assigns it to the FromName field.
func (o *EmailSenderItem) SetFromName(v string) {
	o.FromName.Set(&v)
}
// SetFromNameNil sets the value for FromName to be an explicit nil
func (o *EmailSenderItem) SetFromNameNil() {
	o.FromName.Set(nil)
}

// UnsetFromName ensures that no value is present for FromName, not even an explicit nil
func (o *EmailSenderItem) UnsetFromName() {
	o.FromName.Unset()
}

// GetReplyTo returns the ReplyTo field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *EmailSenderItem) GetReplyTo() string {
	if o == nil || IsNil(o.ReplyTo.Get()) {
		var ret string
		return ret
	}
	return *o.ReplyTo.Get()
}

// GetReplyToOk returns a tuple with the ReplyTo field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *EmailSenderItem) GetReplyToOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ReplyTo.Get(), o.ReplyTo.IsSet()
}

// HasReplyTo returns a boolean if a field has been set.
func (o *EmailSenderItem) HasReplyTo() bool {
	if o != nil && o.ReplyTo.IsSet() {
		return true
	}

	return false
}

// SetReplyTo gets a reference to the given NullableString and assigns it to the ReplyTo field.
func (o *EmailSenderItem) SetReplyTo(v string) {
	o.ReplyTo.Set(&v)
}
// SetReplyToNil sets the value for ReplyTo to be an explicit nil
func (o *EmailSenderItem) SetReplyToNil() {
	o.ReplyTo.Set(nil)
}

// UnsetReplyTo ensures that no value is present for ReplyTo, not even an explicit nil
func (o *EmailSenderItem) UnsetReplyTo() {
	o.ReplyTo.Unset()
}

func (o EmailSenderItem) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o EmailSenderItem) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["domainId"] = o.DomainId
	toSerialize["email"] = o.Email
	toSerialize["createdAt"] = o.CreatedAt
	toSerialize["domainStatus"] = o.DomainStatus
	if o.FromName.IsSet() {
		toSerialize["fromName"] = o.FromName.Get()
	}
	if o.ReplyTo.IsSet() {
		toSerialize["replyTo"] = o.ReplyTo.Get()
	}
	return toSerialize, nil
}

func (o *EmailSenderItem) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"domainId",
		"email",
		"createdAt",
		"domainStatus",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varEmailSenderItem := _EmailSenderItem{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varEmailSenderItem)

	if err != nil {
		return err
	}

	*o = EmailSenderItem(varEmailSenderItem)

	return err
}

type NullableEmailSenderItem struct {
	value *EmailSenderItem
	isSet bool
}

func (v NullableEmailSenderItem) Get() *EmailSenderItem {
	return v.value
}

func (v *NullableEmailSenderItem) Set(val *EmailSenderItem) {
	v.value = val
	v.isSet = true
}

func (v NullableEmailSenderItem) IsSet() bool {
	return v.isSet
}

func (v *NullableEmailSenderItem) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEmailSenderItem(val *EmailSenderItem) *NullableEmailSenderItem {
	return &NullableEmailSenderItem{value: val, isSet: true}
}

func (v NullableEmailSenderItem) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEmailSenderItem) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


