/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the User type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &User{}

// User struct for User
type User struct {
	// User ID.
	Id int32 `json:"id"`
	// User's preferred format of time display: * *12h* - AM/PM format; * *24h* - 24-hour clock format. 
	DisplayTimeFormat *string `json:"displayTimeFormat,omitempty"`
	// Username.
	Username string `json:"username"`
	// Account first name.
	FirstName string `json:"firstName"`
	// Account last name.
	LastName string `json:"lastName"`
	// User email address.
	Email string `json:"email"`
	// Current account status: * **A** for Active; * **T** for Trial. 
	Status string `json:"status"`
	// Account balance (in account currency).
	Balance float32 `json:"balance"`
	// User's phone number.
	Phone NullableString `json:"phone"`
	// Account company name.
	Company NullableString `json:"company"`
	Currency Currency `json:"currency"`
	Country NullableCountry `json:"country"`
	Timezone Timezone `json:"timezone"`
	// Type of account: * **P** for Parent User; * **A** for Administrator Sub-Account; * **U** for Regular User. 
	SubaccountType string `json:"subaccountType"`
	// Does the account have a confirmed email?
	EmailAccepted bool `json:"emailAccepted"`
	// Does the account have a confirmed phone number?
	PhoneAccepted bool `json:"phoneAccepted"`
	Avatar NullableUserImage `json:"avatar"`
}

type _User User

// NewUser instantiates a new User object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUser(id int32, username string, firstName string, lastName string, email string, status string, balance float32, phone NullableString, company NullableString, currency Currency, country NullableCountry, timezone Timezone, subaccountType string, emailAccepted bool, phoneAccepted bool, avatar NullableUserImage) *User {
	this := User{}
	this.Id = id
	this.Username = username
	this.FirstName = firstName
	this.LastName = lastName
	this.Email = email
	this.Status = status
	this.Balance = balance
	this.Phone = phone
	this.Company = company
	this.Currency = currency
	this.Country = country
	this.Timezone = timezone
	this.SubaccountType = subaccountType
	this.EmailAccepted = emailAccepted
	this.PhoneAccepted = phoneAccepted
	this.Avatar = avatar
	return &this
}

// NewUserWithDefaults instantiates a new User object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUserWithDefaults() *User {
	this := User{}
	return &this
}

// GetId returns the Id field value
func (o *User) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *User) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *User) SetId(v int32) {
	o.Id = v
}

// GetDisplayTimeFormat returns the DisplayTimeFormat field value if set, zero value otherwise.
func (o *User) GetDisplayTimeFormat() string {
	if o == nil || IsNil(o.DisplayTimeFormat) {
		var ret string
		return ret
	}
	return *o.DisplayTimeFormat
}

// GetDisplayTimeFormatOk returns a tuple with the DisplayTimeFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *User) GetDisplayTimeFormatOk() (*string, bool) {
	if o == nil || IsNil(o.DisplayTimeFormat) {
		return nil, false
	}
	return o.DisplayTimeFormat, true
}

// HasDisplayTimeFormat returns a boolean if a field has been set.
func (o *User) HasDisplayTimeFormat() bool {
	if o != nil && !IsNil(o.DisplayTimeFormat) {
		return true
	}

	return false
}

// SetDisplayTimeFormat gets a reference to the given string and assigns it to the DisplayTimeFormat field.
func (o *User) SetDisplayTimeFormat(v string) {
	o.DisplayTimeFormat = &v
}

// GetUsername returns the Username field value
func (o *User) GetUsername() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Username
}

// GetUsernameOk returns a tuple with the Username field value
// and a boolean to check if the value has been set.
func (o *User) GetUsernameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Username, true
}

// SetUsername sets field value
func (o *User) SetUsername(v string) {
	o.Username = v
}

// GetFirstName returns the FirstName field value
func (o *User) GetFirstName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.FirstName
}

// GetFirstNameOk returns a tuple with the FirstName field value
// and a boolean to check if the value has been set.
func (o *User) GetFirstNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.FirstName, true
}

// SetFirstName sets field value
func (o *User) SetFirstName(v string) {
	o.FirstName = v
}

// GetLastName returns the LastName field value
func (o *User) GetLastName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.LastName
}

// GetLastNameOk returns a tuple with the LastName field value
// and a boolean to check if the value has been set.
func (o *User) GetLastNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.LastName, true
}

// SetLastName sets field value
func (o *User) SetLastName(v string) {
	o.LastName = v
}

// GetEmail returns the Email field value
func (o *User) GetEmail() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Email
}

// GetEmailOk returns a tuple with the Email field value
// and a boolean to check if the value has been set.
func (o *User) GetEmailOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Email, true
}

// SetEmail sets field value
func (o *User) SetEmail(v string) {
	o.Email = v
}

// GetStatus returns the Status field value
func (o *User) GetStatus() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Status
}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
func (o *User) GetStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Status, true
}

// SetStatus sets field value
func (o *User) SetStatus(v string) {
	o.Status = v
}

// GetBalance returns the Balance field value
func (o *User) GetBalance() float32 {
	if o == nil {
		var ret float32
		return ret
	}

	return o.Balance
}

// GetBalanceOk returns a tuple with the Balance field value
// and a boolean to check if the value has been set.
func (o *User) GetBalanceOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Balance, true
}

// SetBalance sets field value
func (o *User) SetBalance(v float32) {
	o.Balance = v
}

// GetPhone returns the Phone field value
// If the value is explicit nil, the zero value for string will be returned
func (o *User) GetPhone() string {
	if o == nil || o.Phone.Get() == nil {
		var ret string
		return ret
	}

	return *o.Phone.Get()
}

// GetPhoneOk returns a tuple with the Phone field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *User) GetPhoneOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Phone.Get(), o.Phone.IsSet()
}

// SetPhone sets field value
func (o *User) SetPhone(v string) {
	o.Phone.Set(&v)
}

// GetCompany returns the Company field value
// If the value is explicit nil, the zero value for string will be returned
func (o *User) GetCompany() string {
	if o == nil || o.Company.Get() == nil {
		var ret string
		return ret
	}

	return *o.Company.Get()
}

// GetCompanyOk returns a tuple with the Company field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *User) GetCompanyOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Company.Get(), o.Company.IsSet()
}

// SetCompany sets field value
func (o *User) SetCompany(v string) {
	o.Company.Set(&v)
}

// GetCurrency returns the Currency field value
func (o *User) GetCurrency() Currency {
	if o == nil {
		var ret Currency
		return ret
	}

	return o.Currency
}

// GetCurrencyOk returns a tuple with the Currency field value
// and a boolean to check if the value has been set.
func (o *User) GetCurrencyOk() (*Currency, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Currency, true
}

// SetCurrency sets field value
func (o *User) SetCurrency(v Currency) {
	o.Currency = v
}

// GetCountry returns the Country field value
// If the value is explicit nil, the zero value for Country will be returned
func (o *User) GetCountry() Country {
	if o == nil || o.Country.Get() == nil {
		var ret Country
		return ret
	}

	return *o.Country.Get()
}

// GetCountryOk returns a tuple with the Country field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *User) GetCountryOk() (*Country, bool) {
	if o == nil {
		return nil, false
	}
	return o.Country.Get(), o.Country.IsSet()
}

// SetCountry sets field value
func (o *User) SetCountry(v Country) {
	o.Country.Set(&v)
}

// GetTimezone returns the Timezone field value
func (o *User) GetTimezone() Timezone {
	if o == nil {
		var ret Timezone
		return ret
	}

	return o.Timezone
}

// GetTimezoneOk returns a tuple with the Timezone field value
// and a boolean to check if the value has been set.
func (o *User) GetTimezoneOk() (*Timezone, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Timezone, true
}

// SetTimezone sets field value
func (o *User) SetTimezone(v Timezone) {
	o.Timezone = v
}

// GetSubaccountType returns the SubaccountType field value
func (o *User) GetSubaccountType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.SubaccountType
}

// GetSubaccountTypeOk returns a tuple with the SubaccountType field value
// and a boolean to check if the value has been set.
func (o *User) GetSubaccountTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.SubaccountType, true
}

// SetSubaccountType sets field value
func (o *User) SetSubaccountType(v string) {
	o.SubaccountType = v
}

// GetEmailAccepted returns the EmailAccepted field value
func (o *User) GetEmailAccepted() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.EmailAccepted
}

// GetEmailAcceptedOk returns a tuple with the EmailAccepted field value
// and a boolean to check if the value has been set.
func (o *User) GetEmailAcceptedOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.EmailAccepted, true
}

// SetEmailAccepted sets field value
func (o *User) SetEmailAccepted(v bool) {
	o.EmailAccepted = v
}

// GetPhoneAccepted returns the PhoneAccepted field value
func (o *User) GetPhoneAccepted() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.PhoneAccepted
}

// GetPhoneAcceptedOk returns a tuple with the PhoneAccepted field value
// and a boolean to check if the value has been set.
func (o *User) GetPhoneAcceptedOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.PhoneAccepted, true
}

// SetPhoneAccepted sets field value
func (o *User) SetPhoneAccepted(v bool) {
	o.PhoneAccepted = v
}

// GetAvatar returns the Avatar field value
// If the value is explicit nil, the zero value for UserImage will be returned
func (o *User) GetAvatar() UserImage {
	if o == nil || o.Avatar.Get() == nil {
		var ret UserImage
		return ret
	}

	return *o.Avatar.Get()
}

// GetAvatarOk returns a tuple with the Avatar field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *User) GetAvatarOk() (*UserImage, bool) {
	if o == nil {
		return nil, false
	}
	return o.Avatar.Get(), o.Avatar.IsSet()
}

// SetAvatar sets field value
func (o *User) SetAvatar(v UserImage) {
	o.Avatar.Set(&v)
}

func (o User) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o User) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	if !IsNil(o.DisplayTimeFormat) {
		toSerialize["displayTimeFormat"] = o.DisplayTimeFormat
	}
	toSerialize["username"] = o.Username
	toSerialize["firstName"] = o.FirstName
	toSerialize["lastName"] = o.LastName
	toSerialize["email"] = o.Email
	toSerialize["status"] = o.Status
	toSerialize["balance"] = o.Balance
	toSerialize["phone"] = o.Phone.Get()
	toSerialize["company"] = o.Company.Get()
	toSerialize["currency"] = o.Currency
	toSerialize["country"] = o.Country.Get()
	toSerialize["timezone"] = o.Timezone
	toSerialize["subaccountType"] = o.SubaccountType
	toSerialize["emailAccepted"] = o.EmailAccepted
	toSerialize["phoneAccepted"] = o.PhoneAccepted
	toSerialize["avatar"] = o.Avatar.Get()
	return toSerialize, nil
}

func (o *User) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"username",
		"firstName",
		"lastName",
		"email",
		"status",
		"balance",
		"phone",
		"company",
		"currency",
		"country",
		"timezone",
		"subaccountType",
		"emailAccepted",
		"phoneAccepted",
		"avatar",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varUser := _User{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varUser)

	if err != nil {
		return err
	}

	*o = User(varUser)

	return err
}

type NullableUser struct {
	value *User
	isSet bool
}

func (v NullableUser) Get() *User {
	return v.value
}

func (v *NullableUser) Set(val *User) {
	v.value = val
	v.isSet = true
}

func (v NullableUser) IsSet() bool {
	return v.isSet
}

func (v *NullableUser) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUser(val *User) *NullableUser {
	return &NullableUser{value: val, isSet: true}
}

func (v NullableUser) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUser) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


