/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import java.io.IOException;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.CdfField;
import uk.ac.bristol.star.cdf.record.OffsetField;
import uk.ac.bristol.star.cdf.record.Pointer;
import uk.ac.bristol.star.cdf.record.Record;
import uk.ac.bristol.star.cdf.record.RecordPlan;

public class CdfDescriptorRecord
extends Record {
    @CdfField
    @OffsetField
    public final long gdrOffset;
    @CdfField
    public final int version;
    @CdfField
    public final int release;
    @CdfField
    public final int encoding;
    @CdfField
    public final int flags;
    @CdfField
    public final int rfuA;
    @CdfField
    public final int rfuB;
    @CdfField
    public final int increment;
    @CdfField
    public final int rfuD;
    @CdfField
    public final int rfuE;
    public final String[] copyright;

    public CdfDescriptorRecord(RecordPlan recordPlan) throws IOException {
        super(recordPlan, "CDR", 1);
        Buf buf = recordPlan.getBuf();
        Pointer pointer = recordPlan.createContentPointer();
        this.gdrOffset = buf.readOffset(pointer);
        this.version = buf.readInt(pointer);
        this.release = buf.readInt(pointer);
        this.encoding = buf.readInt(pointer);
        this.flags = buf.readInt(pointer);
        this.rfuA = buf.readInt(pointer);
        this.rfuB = buf.readInt(pointer);
        this.increment = buf.readInt(pointer);
        this.rfuD = buf.readInt(pointer);
        this.rfuE = buf.readInt(pointer);
        int n = this.versionAtLeast(2, 5) ? 256 : 1945;
        this.copyright = CdfDescriptorRecord.toLines(buf.readAsciiString(pointer, n));
        this.checkEndRecord(pointer);
    }

    private boolean versionAtLeast(int n, int n2) {
        return this.version > n || this.version == n && this.release >= n2;
    }
}

