// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

/*! \file biosiglib.h
 *  \author Christoph Schmidt-Hieber
 *  \date 2011-02-18
 *  \brief Use biosig to read files
 */

#ifndef _BIOSIGLIB_H
#define _BIOSIGLIB_H

#include "../stfio.h"

namespace stfio {

#if defined(WITH_BIOSIG)
//! return version of libbiosig e.g. 10403 correspond to version 1.4.3
StfioDll bool check_biosig_version(int a, int b, int c);
#endif

//! Open an BIOSIG file and store its contents to a Recording object.
/*! \param fName The full path to the file to be opened.
 *  \param ReturnData On entry, an empty Recording object. On exit,
 *         the data stored in \e fName.
 *  \param progress True if the progress dialog should be updated.
 *
 *  Return value: in case of success stfio::biosig is returned,
 *    if the file format is recognized, the corresponding filetype is returned,
 *    if the filetype is not recognized or not supported. stfio::none is returned.
 */
stfio::filetype importBiosigFile(const std::string& fName, Recording& ReturnData, ProgressInfo& progDlg);

//! Export a Recording to a GDF file using biosig.
/*! \param fName Full path to the file to be written.
 *  \param WData The data to be exported.
 */
StfioDll bool exportBiosigFile(const std::string& fName, const Recording& WData, ProgressInfo& progDlg);


}

#endif
