/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.types;

import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.FixedDateRange;
import com.paterva.maltego.typing.types.PresetsRelative;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class DateRangePresets {
    public static FixedDateRange getPresetDateRange(PresetsRelative itemName) {
        GregorianCalendar cal = new GregorianCalendar();
        return new FixedDateRange(DateRangePresets.getPresetFromDate(itemName, cal), DateRangePresets.getPresetToDate(itemName, cal));
    }

    private static DateTime getPresetFromDate(PresetsRelative presetType, Calendar calIn) {
        DateTime presetFromDate = new DateTime();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setFirstDayOfWeek(2);
        cal.setTime(calIn.getTime());
        boolean isDayIncrements = true;
        if (presetType != null) {
            switch (presetType) {
                case PRESETS_TODAY: {
                    break;
                }
                case PRESETS_WEEK_TO_DATE: 
                case PRESETS_BUSINESS_WEEK_TO_DATE: {
                    while (cal.get(7) != 2) {
                        ((Calendar)cal).add(5, -1);
                    }
                    break;
                }
                case PRESETS_MONTH_TO_DATE: {
                    cal.set(5, ((Calendar)cal).getActualMinimum(5));
                    break;
                }
                case PRESETS_YEAR_TO_DATE: {
                    cal.set(6, ((Calendar)cal).getActualMinimum(6));
                    break;
                }
                case PRESETS_YESTERDAY: {
                    ((Calendar)cal).add(5, -1);
                    break;
                }
                case PRESETS_PREV_WEEK: 
                case PRESETS_PREV_BUSINESS_WEEK: {
                    ((Calendar)cal).add(5, -7);
                    while (cal.get(7) != 2) {
                        ((Calendar)cal).add(5, -1);
                    }
                    break;
                }
                case PRESETS_PREV_MONTH: {
                    ((Calendar)cal).add(2, -1);
                    cal.set(5, ((Calendar)cal).getActualMinimum(5));
                    break;
                }
                case PRESETS_PREV_YEAR: {
                    ((Calendar)cal).add(1, -1);
                    cal.set(6, ((Calendar)cal).getActualMinimum(6));
                    break;
                }
                case PRESETS_LAST_30_MIN: {
                    ((Calendar)cal).add(12, -30);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_15_MIN: {
                    ((Calendar)cal).add(12, -15);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_60_MIN: {
                    ((Calendar)cal).add(12, -60);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_4_HOURS: {
                    ((Calendar)cal).add(11, -4);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_12_HOURS: {
                    ((Calendar)cal).add(11, -12);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_24_HOURS: {
                    ((Calendar)cal).add(11, -24);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_7_DAYS: {
                    ((Calendar)cal).add(5, -7);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_30_DAYS: {
                    ((Calendar)cal).add(5, -30);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_60_DAYS: {
                    ((Calendar)cal).add(5, -60);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_90_DAYS: {
                    ((Calendar)cal).add(5, -90);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_6_MONTHS: {
                    ((Calendar)cal).add(2, -6);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_1_YEAR: {
                    ((Calendar)cal).add(1, -1);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_2_YEARS: {
                    ((Calendar)cal).add(1, -2);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_5_YEARS: {
                    ((Calendar)cal).add(1, -5);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_LAST_10_YEARS: {
                    ((Calendar)cal).add(1, -10);
                    isDayIncrements = false;
                    break;
                }
                case PRESETS_SINCE_UNIX_EPOCH_TIME: {
                    cal.setTimeInMillis(0L);
                    isDayIncrements = false;
                }
            }
        }
        if (isDayIncrements) {
            DateRangePresets.setTimeToBeginningOfDay(cal);
        }
        presetFromDate.setDate(cal.getTime());
        return presetFromDate;
    }

    private static DateTime getPresetToDate(PresetsRelative presetType, Calendar calIn) {
        DateTime presetToDate = new DateTime();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setFirstDayOfWeek(2);
        cal.setTime(calIn.getTime());
        if (presetType != null) {
            switch (presetType) {
                case PRESETS_TODAY: 
                case PRESETS_WEEK_TO_DATE: {
                    break;
                }
                case PRESETS_BUSINESS_WEEK_TO_DATE: {
                    if (cal.get(7) != 7 && cal.get(7) != 1) break;
                    cal.set(7, 6);
                    DateRangePresets.setTimeToEndofDay(cal);
                    break;
                }
                case PRESETS_MONTH_TO_DATE: 
                case PRESETS_YEAR_TO_DATE: {
                    break;
                }
                case PRESETS_YESTERDAY: {
                    ((Calendar)cal).add(5, -1);
                    DateRangePresets.setTimeToEndofDay(cal);
                    break;
                }
                case PRESETS_PREV_WEEK: {
                    ((Calendar)cal).add(5, -7);
                    while (cal.get(7) != 1) {
                        ((Calendar)cal).add(5, 1);
                    }
                    DateRangePresets.setTimeToEndofDay(cal);
                    break;
                }
                case PRESETS_PREV_BUSINESS_WEEK: {
                    ((Calendar)cal).add(5, -7);
                    while (cal.get(7) != 2) {
                        ((Calendar)cal).add(5, -1);
                    }
                    while (cal.get(7) != 6) {
                        ((Calendar)cal).add(5, 1);
                    }
                    DateRangePresets.setTimeToEndofDay(cal);
                    break;
                }
                case PRESETS_PREV_MONTH: {
                    ((Calendar)cal).add(2, -1);
                    cal.set(5, ((Calendar)cal).getActualMaximum(5));
                    DateRangePresets.setTimeToEndofDay(cal);
                    break;
                }
                case PRESETS_PREV_YEAR: {
                    ((Calendar)cal).add(1, -1);
                    cal.set(6, ((Calendar)cal).getActualMaximum(6));
                    DateRangePresets.setTimeToEndofDay(cal);
                    break;
                }
            }
        }
        presetToDate.setDate(cal.getTime());
        return presetToDate;
    }

    private static void setTimeToBeginningOfDay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    private static void setTimeToEndofDay(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
    }
}

