/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.satelliteview;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.TopGraphViewRegistry;
import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class SatelliteViewTopComponent
extends TopComponent
implements PropertyChangeListener,
LookupListener {
    private static SatelliteViewTopComponent instance;
    private static final String PREFERRED_ID = "SatelliteViewTopComponent";
    private Lookup.Result<GraphViewCookie> _selectionResult = null;
    private JComponent _view;

    public SatelliteViewTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(SatelliteViewTopComponent.class, (String)"CTL_SatelliteViewTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SatelliteViewTopComponent.class, (String)"HINT_SatelliteViewTopComponent"));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized SatelliteViewTopComponent getDefault() {
        if (instance == null) {
            instance = new SatelliteViewTopComponent();
        }
        return instance;
    }

    public static synchronized SatelliteViewTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(SatelliteViewTopComponent.class.getName()).warning("Cannot find SatelliteViewTopComponent component. It will not be located properly in the window system.");
            return SatelliteViewTopComponent.getDefault();
        }
        if (win instanceof SatelliteViewTopComponent) {
            return (SatelliteViewTopComponent)win;
        }
        Logger.getLogger(SatelliteViewTopComponent.class.getName()).warning("There seem to be multiple components with the 'SatelliteViewTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return SatelliteViewTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        TopGraphViewRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        Lookup.Template tpl = new Lookup.Template(GraphViewCookie.class);
        this._selectionResult = Utilities.actionsGlobalContext().lookup(tpl);
        this._selectionResult.addLookupListener((LookupListener)this);
        this.updateViewControl();
    }

    public void componentClosed() {
        this._selectionResult.removeLookupListener((LookupListener)this);
        TopGraphViewRegistry.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        this._view = null;
        this.removeAll();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("topGraphViewChanged".equals(evt.getPropertyName())) {
            this.updateViewControl();
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        SatelliteViewTopComponent singleton = SatelliteViewTopComponent.getDefault();
        singleton.readPropertiesImpl(p);
        return singleton;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void resultChanged(LookupEvent le) {
        this.updateViewControl();
    }

    private void updateViewControl() {
        GraphViewCookie cookie;
        TopComponent tc;
        Collection cookies = this._selectionResult.allInstances();
        Iterator it = cookies.iterator();
        JComponent overview = null;
        if (it.hasNext()) {
            overview = ((GraphViewCookie)it.next()).getOverview();
        }
        if (overview == null && (tc = GraphEditorRegistry.getDefault().getTopmost()) != null && (cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class)) != null) {
            overview = cookie.getOverview();
        }
        this.setViewControl(overview);
    }

    private void setViewControl(JComponent overview) {
        if (this._view != null) {
            this.remove(this._view);
            this._view = null;
        }
        if (overview != null) {
            this.add(overview, "Center");
            this._view = overview;
        }
        this.validate();
        this.repaint();
    }
}

