/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.EntryDescriptor;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;

public abstract class Entry<T>
extends ZipEntry {
    private T _data;

    public Entry(T data, String folder, String name) {
        this(data, folder, name, null);
    }

    public Entry(T data, String folder, String name, String displayName) {
        super(StringUtilities.isNullOrEmpty((String)folder) ? name : folder + "/" + name);
        this.setDisplayName(displayName);
        this._data = data;
    }

    public Entry(String path) {
        super(path);
    }

    public T getData() {
        return this._data;
    }

    public String getTypeName() {
        String[] result = Entry.parse(this.getName());
        return result[1];
    }

    public String getType() {
        String[] result = Entry.parse(this.getName());
        return result[2];
    }

    public String getFolder() {
        String[] result = Entry.parse(this.getName());
        return result[0];
    }

    public String getFileName() {
        String fileName = this.getTypeName();
        String type = this.getType();
        if (!StringUtilities.isNullOrEmpty((String)type)) {
            fileName = fileName + "." + type;
        }
        return fileName;
    }

    public static String[] parse(String name) {
        String[] result = new String[3];
        if (name == null) {
            return null;
        }
        int start = name.lastIndexOf("/");
        if (start < 0 || start >= name.length() - 1) {
            result[0] = "";
            start = -1;
        } else {
            result[0] = name.substring(0, start);
        }
        int end = name.lastIndexOf(".");
        if (end < 0) {
            result[2] = "";
            end = name.length();
        } else if (end >= name.length() - 1) {
            result[2] = "";
            end = name.length() - 1;
        } else {
            result[2] = name.substring(end + 1);
        }
        result[1] = end > start ? name.substring(start + 1, end) : "";
        return result;
    }

    public String getDisplayName() {
        if (StringUtilities.isNullOrEmpty((String)this.getComment())) {
            return this.getTypeName();
        }
        return this.getComment();
    }

    public void setDisplayName(String displayName) {
        if (displayName != null) {
            this.setComment(displayName);
        } else {
            this.setComment("");
        }
    }

    public boolean equals(EntryDescriptor d) {
        if (d == null) {
            return false;
        }
        return d.getName().equals(this.getName());
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    protected abstract T read(InputStream var1) throws IOException;

    protected abstract void write(T var1, OutputStream var2) throws IOException;
}

