/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.nodes;

import com.paterva.maltego.customicons.nodes.IconLayerRegistryWrapper;
import com.paterva.maltego.customicons.nodes.IconNode;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.WrappedRegistryIcon;
import com.paterva.maltego.importexport.ConfigFolderNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import org.openide.actions.DeleteAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class IconCategoryNode
extends ConfigFolderNode {
    private IconRegistry _iconRegistry;
    private String _category;

    IconCategoryNode(IconRegistry iconRegistry, String category) {
        this(iconRegistry, category, new InstanceContent());
    }

    private IconCategoryNode(IconRegistry iconRegistry, String category, InstanceContent content) {
        super((Children)new IconChildren(iconRegistry, category), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this._iconRegistry = iconRegistry;
        this._category = category;
        this.addLookups(content);
        this.setName(category);
    }

    public String getCategory() {
        return this._category;
    }

    private void addLookups(InstanceContent content) {
        content.add((Object)this);
    }

    public boolean isCheckable() {
        return false;
    }

    public boolean canDestroy() {
        return this._iconRegistry instanceof IconLayerRegistryWrapper;
    }

    public void destroy() throws IOException {
        try {
            for (RegistryIcon icon : this._iconRegistry.getIcons(this._category)) {
                this._iconRegistry.remove(icon);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        super.destroy();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(DeleteAction.class)};
    }

    private static class IconChildren
    extends Children.Keys<WrappedRegistryIcon>
    implements PropertyChangeListener {
        private final IconRegistry _iconRegistry;
        private final String _category;

        public IconChildren(IconRegistry iconRegistry, String category) {
            this._iconRegistry = iconRegistry;
            this._category = category;
            this.update();
        }

        protected void addNotify() {
            this.update();
            if (this._iconRegistry instanceof IconLayerRegistryWrapper) {
                ((IconLayerRegistryWrapper)this._iconRegistry).addPropertyChangeListener(this);
            }
        }

        protected void removeNotify() {
            if (this._iconRegistry instanceof IconLayerRegistryWrapper) {
                ((IconLayerRegistryWrapper)this._iconRegistry).removePropertyChangeListener(this);
            }
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(WrappedRegistryIcon icon) {
            IconNode iconNode = new IconNode(icon);
            return new Node[]{iconNode};
        }

        private void update() {
            ArrayList icons = new ArrayList(this._iconRegistry.getIcons(this._category));
            ArrayList<WrappedRegistryIcon> nodeIcons = new ArrayList<WrappedRegistryIcon>();
            for (RegistryIcon icon : icons) {
                nodeIcons.add(new WrappedRegistryIcon(icon));
            }
            Collections.sort(nodeIcons);
            this.setKeys(nodeIcons);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.update();
        }
    }
}

