/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config.jre.unix;

import com.paterva.maltego.java.config.jre.DetectJavas;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class UnixDetectJava
extends DetectJavas {
    private String[] SEARCH_PARENTS = new String[]{"/usr", "/usr/java", "/usr/jdk", "/usr/j2se", "/usr/j2sdk", "/usr/java", "/usr/java/jdk", "/usr/jdk", "/usr/jdk/instances", "/usr/local", "/usr/local/java", "/usr/local/jdk", "/usr/local/j2se", "/usr/local/j2sdk", "/opt", "/opt/java", "/opt/jdk", "/opt/j2sdk", "/opt/j2se", "/usr/lib", "/usr/lib/jvm", "/usr/lib/jdk", "/export", "/export/jdk", "/export/java", "/export/j2se", "/export/j2sdk"};
    private String[] SEARCH_PREFIXES = new String[]{"/usr/java", "/usr/jdk", "/usr/j2se", "/usr/j2sdk", "/usr/java/jdk", "/usr/jdk/instances", "/usr/local/java", "/usr/local/jdk", "/usr/local/j2se", "/usr/local/j2sdk", "/opt/java", "/opt/jdk", "/opt/j2sdk", "/opt/j2se", "/usr/lib/jvm", "/usr/lib/jdk", "/export/jdk", "/export/java", "/export/j2se", "/export/j2sdk"};

    @Override
    protected Set<String> getPathsToTry() {
        Set<String> paths = super.getPathsToTry();
        paths.addAll(this.getExistingSearchPaths());
        this.removeNonJavaHomes(paths);
        this.removeSymLinkDuplicates(paths);
        return paths;
    }

    private Set<String> getExistingSearchPaths() {
        HashSet<String> searchPaths = new HashSet<String>();
        for (String parentP : this.SEARCH_PARENTS) {
            File[] files;
            File parentF = new File(parentP);
            if (!parentF.isDirectory()) continue;
            for (File file : files = parentF.listFiles()) {
                if (!file.isDirectory()) continue;
                for (String prefix : this.SEARCH_PREFIXES) {
                    String filePath = file.getAbsolutePath();
                    if (!filePath.startsWith(prefix)) continue;
                    System.out.println(prefix + ": " + filePath);
                    searchPaths.add(filePath);
                }
            }
        }
        return searchPaths;
    }
}

