/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.isg.pyramidio.stitching;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageTile {
    private final File file;
    private final Rectangle region;
    private final double correlation;

    public ImageTile(File file, Rectangle region, double correlation) {
        this.file = file;
        this.region = region;
        this.correlation = correlation;
    }

    public File getFile() {
        return this.file;
    }

    public Rectangle getRegion() {
        return this.region;
    }

    public double getCorrelation() {
        return this.correlation;
    }

    public Rectangle getIntersectionWithStitchedImageRegion(Rectangle rectangle) {
        return rectangle.intersection(this.region);
    }

    public BufferedImage readStitchedImageRegion(Rectangle rectangle) throws IOException {
        Rectangle intersection = rectangle.intersection(this.region);
        if (intersection.isEmpty()) {
            return null;
        }
        Rectangle tileRegion = new Rectangle(intersection.x - this.region.x, intersection.y - this.region.y, intersection.width, intersection.height);
        return this.readTileRegion(tileRegion);
    }

    public BufferedImage readTileRegion(Rectangle region) throws IOException {
        try (ImageInputStream iis = ImageIO.createImageInputStream(this.file);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (!readers.hasNext()) {
                throw new IOException("No image reader found for file " + this.file);
            }
            ImageReader reader = readers.next();
            reader.setInput(iis);
            ImageReadParam param = reader.getDefaultReadParam();
            param.setSourceRegion(region);
            BufferedImage bufferedImage = reader.read(0, param);
            return bufferedImage;
        }
    }
}

