/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2api.proxy;

import com.paterva.maltego.certificates.BlacklistedCertificateException;
import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.certificates.NoTrustedCertificateChainFoundException;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.transform.protocol.api.ProxyException;
import com.paterva.maltego.transform.protocol.api.proxy.HttpProxy;
import com.paterva.maltego.transform.protocol.v2api.messaging.CanceledMessage;
import com.paterva.maltego.transform.protocol.v2api.messaging.ExceptionResponse;
import com.paterva.maltego.transform.protocol.v2api.messaging.MaltegoMessageInputStream;
import com.paterva.maltego.transform.protocol.v2api.messaging.MaltegoMessageWrapper;
import com.paterva.maltego.transform.protocol.v2api.messaging.MessagingHelper;
import com.paterva.maltego.transform.protocol.v2api.messaging.Proxy;
import com.paterva.maltego.transform.protocol.v2api.messaging.TransformResponseNonBody;
import com.paterva.maltego.transform.protocol.v2api.messaging.V2ListTransformsCache;
import com.paterva.maltego.transform.protocol.v2api.proxy.ProxySettings;
import com.paterva.maltego.transform.runner.api.TransformRunRequestDecorator;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.TraceContextId;
import com.paterva.maltego.util.Version;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLException;

public class V2HttpProxy
extends HttpProxy
implements Proxy {
    private static final Logger LOG = Logger.getLogger(V2HttpProxy.class.getName());
    private ProxySettings _proxy;
    private static String V2_PROTOCOL = "2.0";
    private static int count = 0;

    public V2HttpProxy(String transformApplication) {
        this(transformApplication, null);
    }

    public V2HttpProxy(String transformApplication, ProxySettings proxy) {
        super(transformApplication, V2_PROTOCOL);
        this._proxy = proxy;
    }

    public ProxySettings getProxySettings() {
        return this._proxy;
    }

    public void setProxySettings(ProxySettings settings) {
        this._proxy = settings;
    }

    private URL getRunRequestUrl(StringBuilder runRequestUrlStringBuilder) throws MalformedURLException {
        return new URL(TransformRunRequestDecorator.decorate((String)runRequestUrlStringBuilder.toString()));
    }

    private StringBuilder getRunRequestUrlStringBuilder(String transform, String key) {
        StringBuilder url = new StringBuilder(this.transformApp);
        url.append("?Command=_RUN&TransformToRun=");
        url.append(transform);
        if (!StringUtilities.isNullOrEmpty((String)key)) {
            url.append("&Key=");
            url.append(key);
        }
        Version version = Version.getCurrent();
        url.append("&OEM=");
        url.append(version.getOem());
        return url;
    }

    @Override
    public MaltegoMessageWrapper listTransforms(boolean httpsOnly, int timeout, boolean appendUrlParam) throws ProxyException, CertificateNeedValidationException {
        String url = this.transformApp + (appendUrlParam ? "?Command=_TRANSFORMS" : "");
        MaltegoMessageWrapper wrapper = V2ListTransformsCache.get(url);
        if (wrapper == null && (wrapper = this.doGet(url, httpsOnly, timeout, true)) != null) {
            V2ListTransformsCache.put(url, wrapper);
        }
        return wrapper;
    }

    private MaltegoMessageWrapper doGet(String url, boolean httpsOnly, int timeout, boolean retryRequestOnFail) throws ProxyException, CertificateNeedValidationException {
        MaltegoMessageWrapper result = null;
        HttpAgent agent = null;
        String traceContextId = TraceContextId.create().toString();
        try {
            LOG.log(Level.FINE, "Get from {0} with trace context id: {1}", new Object[]{url, traceContextId});
            agent = new HttpAgent(new URL(url));
            agent.setConnectTimeout(timeout);
            agent.setReadTimeout(timeout);
            agent.setAcceptEncoding("gzip");
            agent.setAccessToken(this.getAccessToken(url));
            try {
                V2HttpProxy.createExceptionFromCertificateActionIfPresent((HttpAgent)agent, (String)url, (boolean)httpsOnly);
            }
            catch (BlacklistedCertificateException | NoTrustedCertificateChainFoundException ex) {
                LOG.log(Level.WARNING, String.format("Not trusted/blacklisted certificate error for GET request for URL: %s with trace context id: %s", url, traceContextId));
                MaltegoMessageWrapper maltegoMessageWrapper = new MaltegoMessageWrapper(new ExceptionResponse((Exception)ex));
                if (agent != null) {
                    agent.disconnect();
                }
                return maltegoMessageWrapper;
            }
            agent.setRequestHeader("traceparent", traceContextId);
            agent.setRequestHeader("maltego-protocol-version", V2_PROTOCOL);
            agent.doGet(true, retryRequestOnFail);
            result = MessagingHelper.read(agent.getInputStream(), agent.getContentEncoding());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(MessagingHelper.toString(result));
            }
        }
        catch (CertificateNeedValidationException ex) {
            LOG.log(Level.WARNING, String.format("Certificate error during GET request for URL: %s with trace context id: %s", url, traceContextId));
            throw ex;
        }
        catch (IOException ex) {
            String msg = "HTTP error for " + url + ": " + ex.getMessage() + ". Trace Context ID: " + traceContextId;
            if (!(ex instanceof SSLException)) {
                msg = "IOException connection problem: " + String.format("%s. Please check your network and proxy settings.", ex.getMessage());
                msg = String.format("%s Trace Context ID: %s", msg, traceContextId);
            }
            LOG.log(Level.WARNING, String.format("Error during GET request for URL: %s with trace context id: %s", url, traceContextId));
            throw new ProxyException(msg, (Exception)ex);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, String.format("Message parsing exception for GET request for URL: %s with trace context id: %s", url, traceContextId));
            throw new ProxyException("Message parsing exception for " + url + ": " + ex.getMessage() + ". Trace Context ID: " + traceContextId, ex);
        }
        finally {
            if (agent != null) {
                agent.disconnect();
            }
        }
        return result;
    }

    @Override
    public MaltegoMessageWrapper doTransform(String transform, MaltegoMessageWrapper input, String key, int timeout) throws ProxyException {
        Object accessToken;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "--==<Transform input>==--\n{0}", MessagingHelper.toString(input));
        }
        MaltegoMessageWrapper result = null;
        HttpAgent agent = null;
        InputStream is = null;
        OutputStream os = null;
        StringBuilder urlStringBuilder = this.getRunRequestUrlStringBuilder(transform, key);
        String traceContextId = TraceContextId.create().toString();
        try {
            URL url = this.getRunRequestUrl(urlStringBuilder);
            accessToken = this.getAccessToken(url.toString());
            if (!StringUtilities.isNullOrEmpty((String)accessToken)) {
                key = null;
            }
            LOG.log(Level.INFO, "Transform run started for: {0} and URL: {1} and trace context id: {2}", new Object[]{transform, this.transformApp, traceContextId});
            agent = new HttpAgent(url);
            agent.setAcceptEncoding("gzip");
            agent.setConnectTimeout(timeout);
            agent.setReadTimeout(timeout);
            agent.setAccessToken((String)accessToken);
            agent.setRequestHeader("traceparent", traceContextId);
            agent.setRequestHeader("maltego-protocol-version", V2_PROTOCOL);
            String msg = this.checkValidCertificate(agent);
            if (msg != null) {
                CanceledMessage canceledMessage = new CanceledMessage(msg);
                return canceledMessage;
            }
            boolean TEST_RESPONSE = false;
            os = agent.doPost("text/xml");
            MessagingHelper.write(input, os);
            String encoding = agent.getContentEncoding();
            is = encoding != null && encoding.contains("gzip") ? new GZIPInputStream(agent.getInputStream()) : agent.getInputStream();
            is = new MaltegoMessageInputStream(is);
            result = MessagingHelper.read(is);
            result.setTransformResponseNonBody(new TransformResponseNonBody(agent.getResponseCode()));
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "--==<Transform result>==--\n{0}", MessagingHelper.toString(result));
            }
        }
        catch (NoTrustedCertificateChainFoundException ex) {
            LOG.log(Level.WARNING, String.format("Certificate error during transform execution for transform: %s with trace context id: %s", transform, traceContextId));
            accessToken = new CanceledMessage("Transform canceled, no trusted certificate chain found");
            return accessToken;
        }
        catch (IOException ex) {
            String msg = "HTTP error: " + ex.getMessage();
            if (!(ex instanceof SSLException)) {
                msg = "IOException connection problem: " + String.format("%s. Please check your network and proxy settings.", ex.getMessage());
                msg = String.format("%s Trace Context ID: %s", msg, traceContextId);
            }
            LOG.log(Level.WARNING, String.format("Error during transform execution for transform: %s and Trace Context ID: %s", transform, traceContextId));
            throw new ProxyException(msg, (Exception)ex);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, String.format("Message parsing exception for transform: %s and Trace Context ID: %s", transform, traceContextId));
            throw new ProxyException("Message parsing exception: " + ex.getMessage() + ". Trace Context ID: " + traceContextId, ex);
        }
        finally {
            if (agent != null) {
                agent.disconnect();
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(V2HttpProxy.class.getName()).log(Level.INFO, null, ex);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(V2HttpProxy.class.getName()).log(Level.INFO, null, ex);
                }
            }
        }
        return result;
    }

    private InputStream createTestResponse() {
        ByteArrayInputStream is;
        if (++count % 6 == 0) {
            is = new ByteArrayInputStream("<MaltegoMessage>\n   <MaltegoTransformResponseMessage>\n      <Entities>\n      </Entities>\n   </MaltegoTransformResponseMessage>\n</MaltegoMessage>".getBytes(StandardCharsets.UTF_8));
        } else {
            String msgType;
            String msgContent = "<![CDATA[             You have reached the quota limit for              <b>Pipl</b> of 200 transform runs/ month.<br><br>Your quota will be              reset on 12.01.2022. You can buy additional calls from the link:              <a href='https://maltego.com/data-source'>here</a> or              <a href='http://maltego.com/data-source'>here</a> or\n              https://maltego.com/data-source or http://maltego.com/data-source or \n             <a href='https://www.maltego.com/data-source'>here</a> or              <a href='http://www.maltego.com/data-source'>here</a> or\n             https://www.maltego.com/data-source or http://www.maltego.com/data-source or\n             send an email to support@maltego.com or \n             send an email to <a href='support@maltego.com'>here</a> or\n             send an email to <a href='mailto:support@maltego.com'>here</a>         ]]>";
            switch (count % 6) {
                case 1: {
                    msgType = "FatalError";
                    break;
                }
                case 2: {
                    msgType = "FatalError";
                    msgContent = "This is a test message of type '" + msgType + "'\n---This is another line of the same message";
                    break;
                }
                case 3: {
                    msgType = "FatalError";
                    msgContent = "<![CDATA[<h4>This is a test message of type</h4>]]> '" + msgType + "'\n---This is another line of the same message";
                    break;
                }
                case 4: {
                    msgType = "PartialError";
                    break;
                }
                default: {
                    msgType = "Inform";
                }
            }
            is = new ByteArrayInputStream(("<MaltegoMessage>\n   <MaltegoTransformResponseMessage>\n      <Entities/>\n      <UIMessages>\n         <UIMessage MessageType='" + msgType + "'>" + msgContent + "          </UIMessage>\n      </UIMessages>\n      <AdditionalInfo>\n            <Buttons>\n                <Button id='buyWebSite' text='Buy more' url='https://www.maltego.com/transform-hub/'/>\n                <Button id='dummy' text='Do nothing'/>\n            </Buttons>\n      </AdditionalInfo>\n   </MaltegoTransformResponseMessage>\n</MaltegoMessage>").getBytes(StandardCharsets.UTF_8));
        }
        return is;
    }

    @Override
    public int getLoad() throws ProxyException {
        HttpAgent agent = null;
        int result = 0;
        String traceContextId = TraceContextId.create().toString();
        try {
            agent = new HttpAgent(new URL(this.transformApp + "?Command=_PERFORMANCE"));
            agent.setRequestHeader("traceparent", traceContextId);
            agent.setRequestHeader("maltego-protocol-version", V2_PROTOCOL);
            agent.doGet(false);
            String content = agent.getContentAsString();
            result = Integer.parseInt(content);
        }
        catch (IOException ex) {
            String msg = "HTTP error: " + ex.getMessage();
            if (!(ex instanceof SSLException)) {
                msg = "IOException connection problem: " + String.format("%s. Please check your network and proxy settings.", ex.getMessage());
                msg = String.format("%s Trace Context ID: %s", msg, traceContextId);
            }
            LOG.log(Level.WARNING, String.format("Error during getLoad execution for URL: %s and Trace Context ID: %s", this.transformApp, traceContextId));
            throw new ProxyException(msg, (Exception)ex);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, String.format("Message parsing exception for getLoad operation for URL: %s and Trace Context ID: %s", this.transformApp, traceContextId));
            throw new ProxyException("Message parsing exception: " + ex.getMessage() + ". Trace ID: " + traceContextId, ex);
        }
        finally {
            if (agent != null) {
                agent.disconnect();
            }
        }
        return result;
    }

    @Override
    public byte[] getMtzConfig() throws ProxyException {
        HttpAgent agent = null;
        byte[] result = null;
        String traceContextId = TraceContextId.create().toString();
        try {
            URL url = new URL(this.transformApp + "?Command=_CONFIG");
            agent = new HttpAgent(url);
            agent.setAccessToken(this.getAccessToken(url.toString()));
            agent.setRequestHeader("traceparent", traceContextId);
            agent.setRequestHeader("maltego-protocol-version", V2_PROTOCOL);
            agent.doGet(false);
            result = agent.getContentAsBytes();
        }
        catch (IOException ex) {
            String msg = "HTTP error: " + ex.getMessage();
            if (!(ex instanceof SSLException)) {
                msg = "IOException connection problem: " + String.format("%s. Please check your network and proxy settings.", ex.getMessage());
                msg = String.format("%s Trace Context ID: %s", msg, traceContextId);
            }
            LOG.log(Level.WARNING, String.format("Error during getMtzConfig execution for URL: %s and Trace Context ID: %s", this.transformApp, traceContextId));
            throw new ProxyException(msg, (Exception)ex);
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, String.format("Message parsing exception for getMtzConfig operation for URL: %s and Trace Context ID: %s", this.transformApp, traceContextId));
            throw new ProxyException("Message parsing exception: " + ex.getMessage() + ". Trace ID: " + traceContextId, ex);
        }
        finally {
            if (agent != null) {
                agent.disconnect();
            }
        }
        return result;
    }

    private String getAccessToken(String url) throws IOException {
        return LicenseManager.A().H(url);
    }
}

