/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.treelist;

import com.paterva.maltego.util.ui.search.SearchRunItem;
import com.paterva.maltego.util.ui.treelist.PersistedExpandStates;
import com.paterva.maltego.util.ui.treelist.TreeListItem;
import com.paterva.maltego.util.ui.treelist.TreeListItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;

public abstract class AbstractTreeListItem
implements TreeListItem {
    private static final Logger LOG = Logger.getLogger(AbstractTreeListItem.class.getName());
    private final String _name;
    private final TreeListItem _parent;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private final EventPopagateListener _popagateListener = new EventPopagateListener();
    private final List<TreeListItem> _children = new ArrayList<TreeListItem>();
    private final int _depth;
    private boolean _expandedCached;
    private final boolean _expandedByDefault;
    private boolean _selected = false;
    private List<TreeListItem> _listCache;

    public AbstractTreeListItem(TreeListItem parent, String name, int depth, boolean expandedByDefault) {
        this._name = name;
        this._parent = parent;
        this._depth = depth;
        this._expandedByDefault = expandedByDefault;
        this.init();
    }

    private void init() {
        this._expandedCached = PersistedExpandStates.getInstance().isExpanded(this);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public int getDepth() {
        return this._depth;
    }

    @Override
    public void setExpanded(boolean expanded) {
        if (this._expandedCached != expanded) {
            PersistedExpandStates.getInstance().setExpanded(this, expanded);
            this._expandedCached = expanded;
            this.fireExpanded(this, -1, this.getListIndex(this));
        }
    }

    @Override
    public boolean isExpanded() {
        return this._expandedCached;
    }

    @Override
    public boolean isExpandedByDefault() {
        return this._expandedByDefault;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            this._selected = selected;
            this.fireSelected(this, -1, this.getListIndex(this));
        }
    }

    @Override
    public boolean isSelected() {
        return this._selected;
    }

    @Override
    public TreeListItem getParent() {
        return this._parent;
    }

    @Override
    public boolean isVisible() {
        for (TreeListItem parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.isExpanded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addChild(TreeListItem item, int index) {
        this.resetListCaches();
        this._children.add(index, item);
        item.addPropertyChangeListener(this._popagateListener);
        this.fireChildAdded(item, index, this.getListIndex(item));
    }

    @Override
    public void removeChild(TreeListItem item) {
        int childIndex = this._children.indexOf(item);
        int listIndex = this.getListIndex(item);
        this.resetListCaches();
        item.removePropertyChangeListener(this._popagateListener);
        this._children.remove(childIndex);
        if (!(item instanceof SearchRunItem)) {
            this.fireChildRemoved(item, childIndex, listIndex);
        }
    }

    public void removeAllChildren() {
        for (int i = this._children.size() - 1; i >= 0; --i) {
            this.removeChild(this._children.get(i));
        }
    }

    @Override
    public List<TreeListItem> getChildren() {
        return Collections.unmodifiableList(this._children);
    }

    private void resetListCaches() {
        for (TreeListItem item = this; item != null; item = item.getParent()) {
            item.resetListCache();
        }
    }

    private void resetListCache() {
        this._listCache = null;
    }

    @Override
    public List<TreeListItem> getAsList() {
        if (this._listCache == null) {
            ArrayList<TreeListItem> list = new ArrayList<TreeListItem>();
            list.add(this);
            for (TreeListItem item : this._children) {
                list.addAll(item.getAsList());
            }
            this._listCache = list;
        }
        return this._listCache;
    }

    protected int getListIndex(TreeListItem item) {
        if (this._parent instanceof AbstractTreeListItem) {
            return ((AbstractTreeListItem)this._parent).getListIndex(item);
        }
        return this.getAsList().indexOf(item);
    }

    @Override
    public List<Action> getContextActions() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Action> getToolbarActions() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean mayShowDescription() {
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Arrays.asList(this._changeSupport.getPropertyChangeListeners()).contains(listener)) {
            return;
        }
        this._changeSupport.addPropertyChangeListener(listener);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "add listener this={0} {1} listener={2} count={3}", new Object[]{this, this.getName(), listener, this._changeSupport.getPropertyChangeListeners().length});
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "remove listener this={0} {1} listener={2} count={3}", new Object[]{this, this.getName(), listener, this._changeSupport.getPropertyChangeListeners().length});
        }
    }

    protected void fireChildAdded(TreeListItem item, int childIndex, int listIndex) {
        this.fire("childAdded", item, childIndex, listIndex);
    }

    protected void fireChildRemoved(TreeListItem item, int childIndex, int listIndex) {
        this.fire("childRemoved", item, childIndex, listIndex);
    }

    protected void fireChanged(TreeListItem item, int childIndex, int listIndex) {
        this.fire("changed", item, childIndex, listIndex);
    }

    protected void fireExpanded(TreeListItem item, int childIndex, int listIndex) {
        this.fire("expandedChanged", item, childIndex, listIndex);
    }

    protected void fireSelected(TreeListItem item, int childIndex, int listIndex) {
        this.fire("selected", item, childIndex, listIndex);
    }

    protected void fire(String property, TreeListItem item, int childIndex, int listIndex) {
        TreeListItemEvent evt = new TreeListItemEvent(item, childIndex, listIndex);
        this.firePropertyChange(property, null, evt);
    }

    protected void firePropertyChange(String prop, Object oldValue, Object newValue) {
        this._changeSupport.firePropertyChange(prop, oldValue, newValue);
    }

    private class EventPopagateListener
    implements PropertyChangeListener {
        private EventPopagateListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            AbstractTreeListItem.this.firePropertyChange(prop, null, evt.getNewValue());
        }
    }
}

