/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp;

import com.paterva.maltego.chatapi.conn.ConnectionInitiationCallback;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.session.CollaborationSessionInfo;
import com.paterva.maltego.collab.session.xmpp.XMPPConnectionFactory;
import com.paterva.maltego.collab.ui.PortInfo;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.ArrayUtils;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.Base64;
import org.openide.util.NbPreferences;

abstract class RegistrationStrategy {
    RegistrationStrategy() {
    }

    public abstract XMPPConnection updateRegistrationInfo(XMPPConnection var1, CollaborationSessionInfo var2, ConnectionInitiationCallback var3) throws CollaborationException;

    public abstract void authenticationFailed(CollaborationSessionInfo var1, ConnectionInitiationCallback var2);

    protected class RegistrationAndConnection {
        private RegistrationInfo _info;
        private XMPPConnection _cn;

        public RegistrationAndConnection(RegistrationInfo info, XMPPConnection cn) {
            this._info = info;
            this._cn = cn;
        }

        public RegistrationInfo getRegistrationInfo() {
            return this._info;
        }

        public XMPPConnection getConnection() {
            return this._cn;
        }
    }

    protected class RegistrationInfo {
        private String _username;
        private String _password;

        public RegistrationInfo(String username, String password) {
            this._username = username;
            this._password = password;
        }

        public String getUsername() {
            return this._username;
        }

        public String getPassword() {
            return this._password;
        }
    }

    public static class Default
    extends RegistrationStrategy {
        @Override
        public XMPPConnection updateRegistrationInfo(XMPPConnection cn, CollaborationSessionInfo info, ConnectionInitiationCallback cb) throws CollaborationException {
            return this.getStrategy(info).updateRegistrationInfo(cn, info, cb);
        }

        @Override
        public void authenticationFailed(CollaborationSessionInfo info, ConnectionInitiationCallback cb) {
            this.getStrategy(info).authenticationFailed(info, cb);
        }

        private RegistrationStrategy getStrategy(CollaborationSessionInfo info) {
            if (info.isUseDefaultServer() || info.isUsePrivatePatervaServer()) {
                return new Paterva();
            }
            return new None();
        }
    }

    public static class Paterva
    extends Auto {
        private static final String KEY1 = "5223";
        private static final String KEY2 = "maltego.persistence";

        @Override
        public XMPPConnection updateRegistrationInfo(XMPPConnection cn, CollaborationSessionInfo info, ConnectionInitiationCallback cb) throws CollaborationException {
            String service = info.getService();
            String server = info.getServer();
            int port = info.getPort();
            String msg = String.format("Checking registration for %s", server);
            if (port > 0) {
                msg = msg + ":" + port;
            }
            cb.debug(msg);
            RegistrationInfo registration = this.getRegistrationInfo(server, port);
            if (registration == null) {
                RegistrationAndConnection regAndCn = this.registerRandomAccount(cn, service, server, info.getPortInfo(), info.isDebugSession(), 3, cb);
                registration = regAndCn.getRegistrationInfo();
                cn = regAndCn.getConnection();
            }
            msg = String.format("Using registration %s:%s@%s", registration.getUsername(), registration.getPassword(), server);
            if (port > 0) {
                msg = msg + ":" + port;
            }
            cb.debug(msg);
            info.setUsername(registration.getUsername());
            info.setPassword(registration.getPassword());
            return cn;
        }

        private RegistrationAndConnection registerRandomAccount(XMPPConnection cn, String service, String server, PortInfo portInfo, boolean debug, int retries, ConnectionInitiationCallback cb) throws CollaborationException {
            try {
                RegistrationInfo registration = new RegistrationInfo(this.generateUsername(), this.generatePassword());
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("username", registration.getUsername());
                attributes.put("password", registration.getPassword());
                attributes.put("maltego.challenge-response", this.createChallengeResponse(registration.getUsername()));
                int port = portInfo.getSelectedPort();
                String msg = String.format("No registration, registering account %s:%s@%s", registration.getUsername(), registration.getPassword(), server);
                if (port > 0) {
                    msg = msg + ":" + port;
                }
                cb.debug(msg);
                cn = this.registerAccount(cn, service, server, portInfo, attributes, debug, cb);
                if (cb.isCancelled()) {
                    return null;
                }
                this.storeRegistrationInfo(server, port, registration);
                cb.debug("Saved new account");
                return new RegistrationAndConnection(registration, cn);
            }
            catch (URISyntaxException ex) {
                throw new CollaborationException(ex, true);
            }
            catch (XMPPException ex) {
                XMPPError xmppError = ex.getXMPPError();
                if (xmppError != null && xmppError.getCode() == 409 && retries > 0) {
                    return this.registerRandomAccount(cn, service, server, portInfo, debug, retries - 1, cb);
                }
                throw new CollaborationException(ex, true);
            }
        }

        private String generateUsername() {
            return this.generateRandomString();
        }

        private String generatePassword() {
            return this.generateRandomString();
        }

        private String generateRandomString() {
            long rnd = UUID.randomUUID().getLeastSignificantBits();
            return StringUtilities.toStringUnsignedLong((long)rnd, (int)36).toLowerCase();
        }

        @Override
        public void authenticationFailed(CollaborationSessionInfo info, ConnectionInitiationCallback cb) {
            cb.debug(String.format("Deleting registration info for %s:%d due to authentication failure", info.getServer(), info.getPort()));
            this.removeRegistrationInfo(info.getServer(), info.getPort());
        }

        private String createChallengeResponse(String challenge) throws CollaborationException {
            try {
                return this.encrypt(challenge, ArrayUtils.addAll((char[])ArrayUtils.addAll((char[])KEY1.toCharArray(), (char[])new char[]{'2', 'y', 'p', 'k'}), (char[])KEY2.toCharArray()));
            }
            catch (GeneralSecurityException ex) {
                throw new CollaborationException(ex, true);
            }
            catch (UnsupportedEncodingException ex) {
                throw new CollaborationException(ex, true);
            }
        }

        private String encrypt(String text, char[] key) throws GeneralSecurityException, UnsupportedEncodingException {
            SecretKey secret = this.expand(key);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, secret);
            AlgorithmParameters params = cipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] cipherText = cipher.doFinal(text.getBytes("UTF-8"));
            byte[] all = ArrayUtils.addAll((byte[])iv, (byte[])cipherText);
            return Base64.encodeBytes((byte[])all);
        }

        private String decrypt(String s, char[] key) throws GeneralSecurityException, UnsupportedEncodingException {
            byte[] ivAndCipherText = Base64.decode((String)s);
            byte[] iv = Arrays.copyOf(ivAndCipherText, 16);
            byte[] cipherText = Arrays.copyOfRange(ivAndCipherText, 16, ivAndCipherText.length);
            SecretKey secret = this.expand(key);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)secret, new IvParameterSpec(iv));
            return new String(cipher.doFinal(cipherText), "UTF-8");
        }

        private SecretKey expand(char[] key) throws NoSuchAlgorithmException, InvalidKeySpecException {
            byte[] salt = new byte[]{-92, 42, -84, 51, -57, -119, -68, -116};
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(key, salt, 65536, 128);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            return secret;
        }
    }

    public static abstract class Auto
    extends RegistrationStrategy {
        @Override
        public XMPPConnection updateRegistrationInfo(XMPPConnection cn, CollaborationSessionInfo info, ConnectionInitiationCallback cb) throws CollaborationException {
            RegistrationInfo registration = this.getRegistrationInfo(info.getServer(), info.getPort());
            if (registration == null) {
                try {
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("username", info.getUsername());
                    attributes.put("password", info.getPassword());
                    cn = this.registerAccount(cn, info.getService(), info.getServer(), info.getPortInfo(), attributes, info.isDebugSession(), cb);
                }
                catch (Exception ex) {
                    throw new CollaborationException(ex, true);
                }
            } else {
                info.setUsername(registration.getUsername());
            }
            return cn;
        }

        protected RegistrationInfo getRegistrationInfo(String server, int port) {
            String regString = NbPreferences.forModule(RegistrationStrategy.class).get(this.toString(server, port), null);
            return this.parse(regString);
        }

        protected void removeRegistrationInfo(String server, int port) {
            try {
                Preferences prefs = NbPreferences.forModule(RegistrationStrategy.class);
                prefs.remove(this.toString(server, port));
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
        }

        protected void storeRegistrationInfo(String server, int port, RegistrationInfo info) {
            try {
                Preferences prefs = NbPreferences.forModule(RegistrationStrategy.class);
                prefs.put(this.toString(server, port), this.toString(info));
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
        }

        private RegistrationInfo parse(String s) {
            int pos;
            if (s != null && (pos = s.indexOf(58)) > 0) {
                String user = s.substring(0, pos);
                String pass = s.substring(pos + 1, s.length());
                return new RegistrationInfo(user, pass);
            }
            return null;
        }

        private String toString(RegistrationInfo info) {
            return String.format("%s:%s", info.getUsername(), info.getPassword());
        }

        private String toString(String server, int port) {
            return String.format("%s:%d", server, port);
        }

        protected XMPPConnection registerAccount(XMPPConnection cn, String service, String server, PortInfo portInfo, Map<String, String> attributes, boolean debug, ConnectionInitiationCallback cb) throws XMPPException, URISyntaxException, CollaborationException {
            if (cn == null) {
                cn = XMPPConnectionFactory.create(service, server, portInfo, debug);
            }
            try {
                if (cb.isCancelled()) {
                    return null;
                }
                cb.progress(LogMessageLevel.Info, "Creating account - connecting...", 3);
                if (!cn.isConnected()) {
                    cn.connect();
                }
                AccountManager manager = cn.getAccountManager();
                if (cb.isCancelled()) {
                    return null;
                }
                if (!manager.supportsAccountCreation()) {
                    throw new CollaborationException("Account creation not supported", false);
                }
                cb.progress(LogMessageLevel.Info, "Creating account - retrieving registration parameters", 6);
                String instructions = manager.getAccountInstructions();
                Collection accountAttributes = manager.getAccountAttributes();
                if (cb.isCancelled()) {
                    return null;
                }
                cb.progress(LogMessageLevel.Info, "Creating account - performing registration", 9);
                manager.createAccount(attributes.get("username"), attributes.get("password"), attributes);
                cb.progress(LogMessageLevel.Info, "Creating account - success!", 12);
            }
            catch (XMPPException ex) {
                cn.disconnect();
                throw ex;
            }
            catch (CollaborationException ex) {
                cn.disconnect();
                throw ex;
            }
            return cn;
        }
    }

    public static class None
    extends RegistrationStrategy {
        @Override
        public XMPPConnection updateRegistrationInfo(XMPPConnection cn, CollaborationSessionInfo info, ConnectionInitiationCallback cb) throws CollaborationException {
            return null;
        }

        @Override
        public void authenticationFailed(CollaborationSessionInfo info, ConnectionInitiationCallback cb) {
        }
    }
}

