/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PartHandlerInfo {
    private boolean isHandlerInvokeOnMessageReceived = false;
    private boolean isHandlerMultithreaded = true;

    PartHandlerInfo(Class clazz) {
        if (clazz == null) {
            return;
        }
        if (IHttpRequestHandler.class.isAssignableFrom(clazz)) {
            this.isHandlerMultithreaded = PartHandlerInfo.isOnRequestMultithreaded(clazz);
            this.isHandlerInvokeOnMessageReceived = PartHandlerInfo.isOnRequestInvokeOnMessageReceived(clazz);
        }
    }

    static boolean isOnRequestMultithreaded(Class<IHttpRequestHandler> serverHandlerClass) {
        boolean isMultithreaded = HttpUtils.isHandlerMultithreaded(serverHandlerClass, true);
        return HttpUtils.isMethodMultithreaded(serverHandlerClass, "onPart", isMultithreaded, IPart.class);
    }

    static boolean isOnRequestInvokeOnMessageReceived(Class<IHttpRequestHandler> handlerClass) {
        boolean invokeOnMessageReceived = HttpUtils.isInvokeOnMessageReceived(handlerClass, false);
        return HttpUtils.isInvokeOnMessageReceived(handlerClass, "onPart", invokeOnMessageReceived, IPart.class);
    }

    public boolean isHandlerMultithreaded() {
        return this.isHandlerMultithreaded;
    }

    public boolean isHandlerInvokeOnMessageReceived() {
        return this.isHandlerInvokeOnMessageReceived;
    }
}

